/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.partitions;

import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.dto.rel.expressions.LiteralDTO;
import org.apache.gravitino.dto.rel.partitions.PartitionDTO;
import org.apache.gravitino.rel.partitions.RangePartition;

public class RangePartitionDTO
implements PartitionDTO,
RangePartition {
    private final String name;
    private final Map<String, String> properties;
    private final LiteralDTO upper;
    private final LiteralDTO lower;

    public static Builder builder() {
        return new Builder();
    }

    private RangePartitionDTO() {
        this(null, null, null, null);
    }

    private RangePartitionDTO(String name, Map<String, String> properties, LiteralDTO upper, LiteralDTO lower) {
        this.name = name;
        this.properties = properties;
        this.upper = upper;
        this.lower = lower;
    }

    public String name() {
        return this.name;
    }

    public LiteralDTO upper() {
        return this.upper;
    }

    public LiteralDTO lower() {
        return this.lower;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangePartitionDTO)) {
            return false;
        }
        RangePartitionDTO that = (RangePartitionDTO)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.properties, that.properties) && Objects.equals(this.upper, that.upper) && Objects.equals(this.lower, that.lower);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.properties, this.upper, this.lower);
    }

    @Override
    public PartitionDTO.Type type() {
        return PartitionDTO.Type.RANGE;
    }

    public static class Builder {
        private String name;
        private Map<String, String> properties;
        private LiteralDTO upper;
        private LiteralDTO lower;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder withUpper(LiteralDTO upper) {
            this.upper = upper;
            return this;
        }

        public Builder withLower(LiteralDTO lower) {
            this.lower = lower;
            return this;
        }

        public RangePartitionDTO build() {
            return new RangePartitionDTO(this.name, this.properties, this.upper, this.lower);
        }
    }
}

