/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AuthorizationMetadataObject;
import org.apache.gravitino.authorization.AuthorizationPrivilege;
import org.apache.gravitino.authorization.AuthorizationSecurableObject;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.MetadataObjectChange;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.common.PathBasedMetadataObject;
import org.apache.gravitino.authorization.common.PathBasedSecurableObject;
import org.apache.gravitino.authorization.ranger.RangerAuthorizationPlugin;
import org.apache.gravitino.authorization.ranger.RangerPrivileges;
import org.apache.gravitino.authorization.ranger.reference.RangerDefines;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationHDFSPlugin
extends RangerAuthorizationPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationHDFSPlugin.class);
    private static final Pattern HDFS_PATTERN = Pattern.compile("^hdfs://[^/]*");

    public RangerAuthorizationHDFSPlugin(String metalake, Map<String, String> config) {
        super(metalake, config);
    }

    public Map<Privilege.Name, Set<AuthorizationPrivilege>> privilegesMappingRule() {
        return ImmutableMap.of((Object)Privilege.Name.USE_CATALOG, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.CREATE_CATALOG, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.USE_SCHEMA, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.CREATE_SCHEMA, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.CREATE_TABLE, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.MODIFY_TABLE, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.SELECT_TABLE, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.READ_FILESET, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.WRITE_FILESET, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)), (Object)Privilege.Name.CREATE_FILESET, (Object)ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE)));
    }

    public Set<AuthorizationPrivilege> ownerMappingRule() {
        return ImmutableSet.of((Object)((Object)RangerPrivileges.RangerHdfsPrivilege.READ), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.WRITE), (Object)((Object)RangerPrivileges.RangerHdfsPrivilege.EXECUTE));
    }

    @Override
    public List<String> policyResourceDefinesRule() {
        return ImmutableList.of((Object)RangerDefines.PolicyResource.PATH.getName());
    }

    String getAuthorizationPath(PathBasedMetadataObject pathBasedMetadataObject) {
        return HDFS_PATTERN.matcher(pathBasedMetadataObject.path()).replaceAll("");
    }

    @Override
    public RangerPolicy findManagedPolicy(AuthorizationMetadataObject authzMetadataObject) throws AuthorizationPluginException {
        List nsMetadataObj = authzMetadataObject.names();
        PathBasedMetadataObject pathAuthzMetadataObject = (PathBasedMetadataObject)authzMetadataObject;
        HashMap<String, String> preciseFilters = new HashMap<String, String>();
        for (int i = 0; i < nsMetadataObj.size() && i < this.policyResourceDefinesRule().size(); ++i) {
            preciseFilters.put(this.policyResourceDefinesRule().get(i), this.getAuthorizationPath(pathAuthzMetadataObject));
        }
        return this.preciseFindPolicy(authzMetadataObject, preciseFilters);
    }

    @Override
    protected List<RangerPolicy> wildcardSearchPolicies(AuthorizationMetadataObject authzMetadataObject) {
        Preconditions.checkArgument((boolean)(authzMetadataObject instanceof PathBasedMetadataObject));
        PathBasedMetadataObject pathBasedMetadataObject = (PathBasedMetadataObject)authzMetadataObject;
        List<String> resourceDefines = this.policyResourceDefinesRule();
        HashMap<String, String> searchFilters = new HashMap<String, String>();
        searchFilters.put("serviceName", this.rangerServiceName);
        resourceDefines.forEach(resourceDefine -> searchFilters.put("resource:" + resourceDefine, this.getAuthorizationPath(pathBasedMetadataObject)));
        try {
            return this.rangerClient.findPolicies(searchFilters);
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e, "Failed to find policies in Ranger", new Object[0]);
        }
    }

    @Override
    protected void renameMetadataObject(AuthorizationMetadataObject authzMetadataObject, AuthorizationMetadataObject newAuthzMetadataObject) {
        Preconditions.checkArgument((boolean)(authzMetadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
        Preconditions.checkArgument((boolean)(newAuthzMetadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
        this.updatePolicyByMetadataObject(newAuthzMetadataObject.type().metadataObjectType(), authzMetadataObject, newAuthzMetadataObject);
    }

    @Override
    protected void updatePolicyByMetadataObject(MetadataObject.Type operationType, AuthorizationMetadataObject oldAuthzMetaObject, AuthorizationMetadataObject newAuthzMetaObject) {
        List<RangerPolicy> oldPolicies = this.wildcardSearchPolicies(oldAuthzMetaObject);
        List<RangerPolicy> existNewPolicies = this.wildcardSearchPolicies(newAuthzMetaObject);
        if (oldPolicies.isEmpty()) {
            LOG.warn("Cannot find the Ranger policy for the metadata object({})!", (Object)oldAuthzMetaObject);
            return;
        }
        if (!existNewPolicies.isEmpty()) {
            LOG.warn("The Ranger policy for the metadata object({}) already exists!", (Object)newAuthzMetaObject);
        }
        oldPolicies.forEach(policy -> {
            try {
                String oldResource = (String)((RangerPolicy.RangerPolicyResource)policy.getResources().get(this.rangerHelper.policyResourceDefines.get(0))).getValues().get(0);
                List oldResourceNames = Arrays.stream(oldResource.split("/")).filter(path -> StringUtils.isNotBlank((String)path) && !".".equals(path)).collect(Collectors.toList());
                List newResourceNames = Arrays.stream(this.getAuthorizationPath((PathBasedMetadataObject)newAuthzMetaObject).split("/")).filter(path -> StringUtils.isNotBlank((String)path) && !".".equals(path)).collect(Collectors.toList());
                int minLen = Math.min(oldResourceNames.size(), newResourceNames.size());
                for (int i = 0; i < minLen; ++i) {
                    String newName;
                    String oldName = (String)oldResourceNames.get(i);
                    if (oldName.equals(newName = (String)newResourceNames.get(i))) continue;
                    if (oldName.equals(oldAuthzMetaObject.name()) && newName.equals(newAuthzMetaObject.name())) {
                        oldResourceNames.set(i, newAuthzMetaObject.name());
                        break;
                    }
                    return;
                }
                String newResourcePath = "/" + String.join((CharSequence)"/", oldResourceNames);
                policy.setName(newResourcePath);
                policy.getResources().put(this.rangerHelper.policyResourceDefines.get(0), new RangerPolicy.RangerPolicyResource(newResourcePath));
                boolean alreadyExist = existNewPolicies.stream().anyMatch(existNewPolicy -> existNewPolicy.getName().equals(policy.getName()) || existNewPolicy.getResources().equals(policy.getResources()));
                if (alreadyExist) {
                    LOG.warn("The Ranger policy for the metadata object({}) already exists!", (Object)newAuthzMetaObject);
                    return;
                }
                this.rangerClient.updatePolicy(policy.getId(), (RangerPolicy)policy);
            }
            catch (RangerServiceException e) {
                LOG.error("Failed to rename the policy {}!", policy);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    protected void removeMetadataObject(AuthorizationMetadataObject authzMetadataObject) {
        if (authzMetadataObject.metadataObjectType() == MetadataObject.Type.SCHEMA) {
            this.removeSchemaMetadataObject(authzMetadataObject);
        } else if (authzMetadataObject.metadataObjectType() == MetadataObject.Type.TABLE) {
            this.removeTableMetadataObject(authzMetadataObject);
        } else if (authzMetadataObject.metadataObjectType() == MetadataObject.Type.FILESET) {
            this.removePolicyByMetadataObject(authzMetadataObject);
        } else if (authzMetadataObject.metadataObjectType() != MetadataObject.Type.METALAKE && authzMetadataObject.metadataObjectType() != MetadataObject.Type.CATALOG) {
            throw new IllegalArgumentException("Unsupported authorization metadata object type: " + String.valueOf(authzMetadataObject.type()));
        }
    }

    private void removeSchemaMetadataObject(AuthorizationMetadataObject authzMetadataObject) {
        Preconditions.checkArgument((boolean)(authzMetadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
        Preconditions.checkArgument((authzMetadataObject.names().size() == 2 ? 1 : 0) != 0, (Object)"The metadata object's name size must be 2");
        Preconditions.checkArgument((boolean)authzMetadataObject.type().equals(PathBasedMetadataObject.SCHEMA_PATH), (Object)"The metadata object type must be a path");
        this.removePolicyByMetadataObject(authzMetadataObject);
    }

    private void removeTableMetadataObject(AuthorizationMetadataObject authzMetadataObject) {
        Preconditions.checkArgument((boolean)(authzMetadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
        Preconditions.checkArgument((authzMetadataObject.names().size() == 3 ? 1 : 0) != 0, (Object)"The metadata object's name size must be 3");
        Preconditions.checkArgument((boolean)authzMetadataObject.type().equals(PathBasedMetadataObject.TABLE_PATH), (Object)"The metadata object type must be a path");
        this.removePolicyByMetadataObject(authzMetadataObject);
    }

    @Override
    protected RangerPolicy createPolicyAddResources(AuthorizationMetadataObject metadataObject) {
        Preconditions.checkArgument((boolean)(metadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
        PathBasedMetadataObject pathBasedMetadataObject = (PathBasedMetadataObject)metadataObject;
        RangerPolicy policy = new RangerPolicy();
        policy.setService(this.rangerServiceName);
        policy.setName(this.getAuthorizationPath(pathBasedMetadataObject));
        RangerPolicy.RangerPolicyResource policyResource = new RangerPolicy.RangerPolicyResource(this.getAuthorizationPath(pathBasedMetadataObject), Boolean.valueOf(false), Boolean.valueOf(pathBasedMetadataObject.recursive()));
        policy.getResources().put(RangerDefines.PolicyResource.PATH.getName(), policyResource);
        return policy;
    }

    @Override
    public AuthorizationSecurableObject generateAuthorizationSecurableObject(AuthorizationMetadataObject object, Set<AuthorizationPrivilege> privileges) {
        object.validateAuthorizationMetadataObject();
        Preconditions.checkArgument((boolean)(object instanceof PathBasedMetadataObject), (Object)"Object must be a path based metadata object");
        PathBasedMetadataObject metadataObject = (PathBasedMetadataObject)object;
        return new PathBasedSecurableObject(metadataObject.parent(), metadataObject.name(), metadataObject.path(), metadataObject.type(), metadataObject.recursive(), privileges);
    }

    public Set<Privilege.Name> allowPrivilegesRule() {
        return ImmutableSet.of((Object)Privilege.Name.CREATE_FILESET, (Object)Privilege.Name.READ_FILESET, (Object)Privilege.Name.WRITE_FILESET, (Object)Privilege.Name.CREATE_TABLE, (Object)Privilege.Name.SELECT_TABLE, (Object)Privilege.Name.MODIFY_TABLE, (Object[])new Privilege.Name[]{Privilege.Name.CREATE_SCHEMA, Privilege.Name.USE_SCHEMA});
    }

    public Set<MetadataObject.Type> allowMetadataObjectTypesRule() {
        return ImmutableSet.of((Object)MetadataObject.Type.TABLE, (Object)MetadataObject.Type.FILESET, (Object)MetadataObject.Type.SCHEMA, (Object)MetadataObject.Type.CATALOG, (Object)MetadataObject.Type.METALAKE);
    }

    public List<AuthorizationSecurableObject> translatePrivilege(SecurableObject securableObject) {
        ArrayList<AuthorizationSecurableObject> rangerSecurableObjects = new ArrayList<AuthorizationSecurableObject>();
        NameIdentifier identifier = securableObject.type().equals((Object)MetadataObject.Type.METALAKE) ? NameIdentifier.of((String[])new String[]{securableObject.fullName()}) : NameIdentifier.parse((String)String.join((CharSequence)".", this.metalake, securableObject.fullName()));
        securableObject.privileges().stream().filter(Objects::nonNull).forEach(gravitinoPrivilege -> {
            HashSet<AuthorizationPrivilege> rangerPrivileges = new HashSet<AuthorizationPrivilege>();
            if (!this.privilegesMappingRule().containsKey(gravitinoPrivilege.name())) {
                return;
            }
            this.privilegesMappingRule().get(gravitinoPrivilege.name()).forEach(rangerPrivilege -> rangerPrivileges.add(new RangerPrivileges.RangerHDFSPrivilegeImpl((AuthorizationPrivilege)rangerPrivilege, gravitinoPrivilege.condition())));
            block0 : switch (gravitinoPrivilege.name()) {
                case USE_CATALOG: 
                case CREATE_CATALOG: {
                    break;
                }
                case USE_SCHEMA: {
                    switch (securableObject.type()) {
                        case METALAKE: {
                            this.extractMetalakeLocations(securableObject, identifier, rangerSecurableObjects, rangerPrivileges, true);
                            break block0;
                        }
                        case CATALOG: 
                        case SCHEMA: {
                            AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)identifier, (Entity.EntityType)MetadataObjectUtil.toEntityType((MetadataObject)securableObject)).forEach(locationPath -> this.createPathBasedMetadataObject(securableObject, (String)locationPath, rangerSecurableObjects, (Set<AuthorizationPrivilege>)rangerPrivileges, true));
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                case CREATE_SCHEMA: {
                    switch (securableObject.type()) {
                        case METALAKE: {
                            this.extractMetalakeLocations(securableObject, identifier, rangerSecurableObjects, rangerPrivileges, false);
                            break block0;
                        }
                        case CATALOG: {
                            AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)identifier, (Entity.EntityType)MetadataObjectUtil.toEntityType((MetadataObject)securableObject)).forEach(locationPath -> this.createPathBasedMetadataObject(securableObject, (String)locationPath, rangerSecurableObjects, (Set<AuthorizationPrivilege>)rangerPrivileges, false));
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                case SELECT_TABLE: 
                case MODIFY_TABLE: 
                case READ_FILESET: 
                case WRITE_FILESET: {
                    if (!gravitinoPrivilege.canBindTo(securableObject.type())) {
                        throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                    }
                    this.createSecurableObjects(securableObject, rangerSecurableObjects, identifier, rangerPrivileges, true, new TableOrFilesetPathExtractor());
                    break;
                }
                case CREATE_TABLE: 
                case CREATE_FILESET: {
                    switch (securableObject.type()) {
                        case METALAKE: 
                        case CATALOG: 
                        case SCHEMA: {
                            this.createSecurableObjects(securableObject, rangerSecurableObjects, identifier, rangerPrivileges, false, new SchemaPathExtractor());
                            break block0;
                        }
                    }
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
                default: {
                    throw new AuthorizationPluginException("The privilege %s is not supported for the securable object: %s", new Object[]{gravitinoPrivilege.name(), securableObject.type()});
                }
            }
        });
        return rangerSecurableObjects;
    }

    private void createSecurableObjects(SecurableObject securableObject, List<AuthorizationSecurableObject> rangerSecurableObjects, NameIdentifier identifier, Set<AuthorizationPrivilege> rangerPrivileges, boolean recursive, PathExtractor pathExtractor) {
        Entity.EntityType type = MetadataObjectUtil.toEntityType((MetadataObject)securableObject);
        ArrayList locations = Lists.newArrayList();
        if (type == Entity.EntityType.METALAKE) {
            NameIdentifier[] catalogs;
            for (NameIdentifier catalog : catalogs = GravitinoEnv.getInstance().catalogDispatcher().listCatalogs(Namespace.of((String[])new String[]{identifier.name()}))) {
                locations.addAll(AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)catalog, (Entity.EntityType)Entity.EntityType.CATALOG));
            }
        } else {
            locations.addAll(AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)identifier, (Entity.EntityType)type));
        }
        locations.forEach(locationPath -> {
            MetadataObject.Type pathObjectType;
            Entity.EntityType pathEntityType;
            if (type == Entity.EntityType.METALAKE) {
                pathEntityType = Entity.EntityType.CATALOG;
                pathObjectType = MetadataObject.Type.CATALOG;
            } else {
                pathEntityType = type;
                pathObjectType = securableObject.type();
            }
            PathBasedMetadataObject pathBaseMetadataObject = new PathBasedMetadataObject(securableObject.parent(), securableObject.name(), pathExtractor.getPath(pathEntityType, (String)locationPath), (AuthorizationMetadataObject.Type)PathBasedMetadataObject.PathType.get((MetadataObject.Type)pathObjectType), recursive);
            pathBaseMetadataObject.validateAuthorizationMetadataObject();
            rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((AuthorizationMetadataObject)pathBaseMetadataObject, rangerPrivileges));
        });
    }

    private void extractMetalakeLocations(SecurableObject securableObject, NameIdentifier identifier, List<AuthorizationSecurableObject> rangerSecurableObjects, Set<AuthorizationPrivilege> rangerPrivileges, boolean recursive) {
        NameIdentifier[] catalogs;
        for (NameIdentifier catalog : catalogs = GravitinoEnv.getInstance().catalogDispatcher().listCatalogs(Namespace.of((String[])new String[]{identifier.name()}))) {
            AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)catalog, (Entity.EntityType)Entity.EntityType.CATALOG).forEach(locationPath -> this.createPathBasedMetadataObject(securableObject, (String)locationPath, rangerSecurableObjects, rangerPrivileges, recursive));
        }
    }

    private void createPathBasedMetadataObject(SecurableObject securableObject, String locationPath, List<AuthorizationSecurableObject> rangerSecurableObjects, Set<AuthorizationPrivilege> rangerPrivileges, boolean recursive) {
        PathBasedMetadataObject pathBaseMetadataObject = new PathBasedMetadataObject(securableObject.parent(), securableObject.name(), locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.PathType.get((MetadataObject.Type)securableObject.type()), recursive);
        pathBaseMetadataObject.validateAuthorizationMetadataObject();
        rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((AuthorizationMetadataObject)pathBaseMetadataObject, rangerPrivileges));
    }

    public List<AuthorizationSecurableObject> translateOwner(MetadataObject gravitinoMetadataObject) {
        ArrayList<AuthorizationSecurableObject> rangerSecurableObjects = new ArrayList<AuthorizationSecurableObject>();
        switch (gravitinoMetadataObject.type()) {
            case METALAKE: 
            case CATALOG: 
            case SCHEMA: 
            case FILESET: 
            case TABLE: {
                this.translateMetadataObject(gravitinoMetadataObject).forEach(metadataObject -> {
                    Preconditions.checkArgument((boolean)(metadataObject instanceof PathBasedMetadataObject), (Object)"The metadata object must be a PathBasedMetadataObject");
                    PathBasedMetadataObject pathBasedMetadataObject = (PathBasedMetadataObject)metadataObject;
                    rangerSecurableObjects.add(this.generateAuthorizationSecurableObject((AuthorizationMetadataObject)pathBasedMetadataObject, this.ownerMappingRule()));
                });
                break;
            }
            default: {
                throw new AuthorizationPluginException("The owner privilege is not supported for the securable object: %s", new Object[]{gravitinoMetadataObject.type()});
            }
        }
        return rangerSecurableObjects;
    }

    public List<AuthorizationMetadataObject> translateMetadataObject(MetadataObject metadataObject) {
        ArrayList<AuthorizationMetadataObject> authzMetadataObjects = new ArrayList<AuthorizationMetadataObject>();
        Entity.EntityType entityType = MetadataObjectUtil.toEntityType((MetadataObject)metadataObject);
        NameIdentifier identifier = metadataObject.type().equals((Object)MetadataObject.Type.METALAKE) ? NameIdentifier.of((String[])new String[]{metadataObject.fullName()}) : NameIdentifier.parse((String)String.join((CharSequence)".", this.metalake, metadataObject.fullName()));
        ArrayList locations = Lists.newArrayList();
        if (metadataObject.type() == MetadataObject.Type.METALAKE) {
            NameIdentifier[] catalogs;
            for (NameIdentifier catalog : catalogs = GravitinoEnv.getInstance().catalogDispatcher().listCatalogs(Namespace.of((String[])new String[]{identifier.name()}))) {
                locations.addAll(AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)catalog, (Entity.EntityType)Entity.EntityType.CATALOG));
            }
        } else {
            locations.addAll(AuthorizationUtils.getMetadataObjectLocation((NameIdentifier)identifier, (Entity.EntityType)entityType));
        }
        locations.forEach(locationPath -> {
            PathBasedMetadataObject.PathType type = PathBasedMetadataObject.PathType.get((MetadataObject.Type)metadataObject.type());
            PathBasedMetadataObject pathBaseMetadataObject = new PathBasedMetadataObject(metadataObject.parent(), metadataObject.name(), locationPath, (AuthorizationMetadataObject.Type)type);
            pathBaseMetadataObject.validateAuthorizationMetadataObject();
            authzMetadataObjects.add((AuthorizationMetadataObject)pathBaseMetadataObject);
        });
        return authzMetadataObjects;
    }

    @Override
    public Boolean onMetadataUpdated(MetadataObjectChange ... changes) throws RuntimeException {
        for (MetadataObjectChange change : changes) {
            if (change instanceof MetadataObjectChange.RenameMetadataObject) {
                MetadataObjectChange.RenameMetadataObject renameChange = (MetadataObjectChange.RenameMetadataObject)change;
                MetadataObject metadataObject = renameChange.metadataObject();
                MetadataObject newMetadataObject = renameChange.newMetadataObject();
                Preconditions.checkArgument((metadataObject.type() == newMetadataObject.type() ? 1 : 0) != 0, (Object)"The old and new metadata object types must be equal!");
                if (metadataObject.type() == MetadataObject.Type.METALAKE) {
                    this.metalake = newMetadataObject.name();
                    continue;
                }
                if (metadataObject.type() == MetadataObject.Type.CATALOG || renameChange.locations() == null || renameChange.locations().isEmpty()) continue;
                if (metadataObject.type() == MetadataObject.Type.TABLE) {
                    Table table;
                    NameIdentifier ident = MetadataObjectUtil.toEntityIdent((String)this.metalake, (MetadataObject)newMetadataObject);
                    NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier((NameIdentifier)ident);
                    if (!GravitinoEnv.getInstance().catalogDispatcher().loadCatalog(catalogIdent).provider().equals("hive") || ((String)(table = GravitinoEnv.getInstance().tableDispatcher().loadTable(ident)).properties().get("table-type")).equals("EXTERNAL_TABLE")) continue;
                }
                ArrayList oldAuthzMetadataObjects = Lists.newArrayList();
                renameChange.locations().forEach(locationPath -> {
                    PathBasedMetadataObject pathBaseMetadataObject = new PathBasedMetadataObject(metadataObject.parent(), metadataObject.name(), locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.PathType.get((MetadataObject.Type)metadataObject.type()));
                    pathBaseMetadataObject.validateAuthorizationMetadataObject();
                    oldAuthzMetadataObjects.add(pathBaseMetadataObject);
                });
                List<AuthorizationMetadataObject> newAuthzMetadataObjects = this.translateMetadataObject(newMetadataObject);
                Preconditions.checkArgument((oldAuthzMetadataObjects.size() == newAuthzMetadataObjects.size() ? 1 : 0) != 0, (Object)"The old and new metadata objects sizes must be equal!");
                for (int i = 0; i < oldAuthzMetadataObjects.size(); ++i) {
                    AuthorizationMetadataObject newAuthzMetadataObject;
                    AuthorizationMetadataObject oldAuthMetadataObject = (AuthorizationMetadataObject)oldAuthzMetadataObjects.get(i);
                    if (oldAuthMetadataObject.equals(newAuthzMetadataObject = newAuthzMetadataObjects.get(i))) {
                        LOG.info("The metadata object({}) and new metadata object({}) are equal, so ignoring rename!", (Object)oldAuthMetadataObject.fullName(), (Object)newAuthzMetadataObject.fullName());
                        continue;
                    }
                    this.renameMetadataObject(oldAuthMetadataObject, newAuthzMetadataObject);
                }
                continue;
            }
            if (change instanceof MetadataObjectChange.RemoveMetadataObject) {
                MetadataObjectChange.RemoveMetadataObject changeMetadataObject = (MetadataObjectChange.RemoveMetadataObject)change;
                ArrayList authzMetadataObjects = new ArrayList();
                changeMetadataObject.getLocations().forEach(locationPath -> {
                    PathBasedMetadataObject pathBaseMetadataObject = new PathBasedMetadataObject(changeMetadataObject.metadataObject().parent(), changeMetadataObject.metadataObject().name(), locationPath, (AuthorizationMetadataObject.Type)PathBasedMetadataObject.PathType.get((MetadataObject.Type)changeMetadataObject.metadataObject().type()));
                    pathBaseMetadataObject.validateAuthorizationMetadataObject();
                    authzMetadataObjects.add(pathBaseMetadataObject);
                });
                authzMetadataObjects.forEach(this::removeMetadataObject);
                continue;
            }
            throw new IllegalArgumentException("Unsupported metadata object change type: " + (change == null ? "null" : change.getClass().getSimpleName()));
        }
        return Boolean.TRUE;
    }

    @Override
    protected String getServiceType() {
        return "hdfs";
    }

    @Override
    protected Map<String, String> getServiceConfigs(Map<String, String> config) {
        return ImmutableMap.builder().put((Object)"authorization.ranger.username".substring(this.getPrefixLength()), (Object)config.get("authorization.ranger.username")).put((Object)"authorization.ranger.password".substring(this.getPrefixLength()), (Object)config.get("authorization.ranger.password")).put((Object)"authorization.ranger.hadoop.security.authentication".substring(this.getPrefixLength()), (Object)this.getConfValue(config, "authorization.ranger.hadoop.security.authentication", "simple")).put((Object)"authorization.ranger.hadoop.rpc.protection".substring(this.getPrefixLength()), (Object)this.getConfValue(config, "authorization.ranger.hadoop.rpc.protection", "authentication")).put((Object)"authorization.ranger.hadoop.security.authorization".substring(this.getPrefixLength()), (Object)this.getConfValue(config, "authorization.ranger.hadoop.security.authorization", "false")).put((Object)"authorization.ranger.fs.default.name".substring(this.getPrefixLength()), (Object)this.getConfValue(config, "authorization.ranger.fs.default.name", "hdfs://127.0.0.1:8090")).build();
    }

    private static interface PathExtractor {
        public String getPath(Entity.EntityType var1, String var2);
    }

    private static class TableOrFilesetPathExtractor
    implements PathExtractor {
        private TableOrFilesetPathExtractor() {
        }

        @Override
        public String getPath(Entity.EntityType type, String location) {
            if (type == Entity.EntityType.CATALOG) {
                return String.format("%s/*/*", location);
            }
            if (type == Entity.EntityType.SCHEMA) {
                return String.format("%s/*", location);
            }
            if (type == Entity.EntityType.TABLE || type == Entity.EntityType.FILESET) {
                return location;
            }
            throw new AuthorizationPluginException("It's not allowed to extract table or fileset path from entity %s", new Object[]{type});
        }
    }

    private static class SchemaPathExtractor
    implements PathExtractor {
        private SchemaPathExtractor() {
        }

        @Override
        public String getPath(Entity.EntityType type, String location) {
            if (type == Entity.EntityType.CATALOG) {
                return String.format("%s/*/", location);
            }
            if (type == Entity.EntityType.SCHEMA) {
                return location;
            }
            throw new AuthorizationPluginException("It's not allowed to extract table or fileset path from entity %s", new Object[]{type});
        }
    }
}

