/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileIndexWriter;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.FileWriterContext;
import org.apache.paimon.io.StatsCollectingSingleFileWriter;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.stats.SimpleStatsConverter;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.LongCounter;
import org.apache.paimon.utils.Pair;

public class RowDataFileWriter
extends StatsCollectingSingleFileWriter<InternalRow, DataFileMeta> {
    private final long schemaId;
    private final LongCounter seqNumCounter;
    private final boolean isExternalPath;
    private final SimpleStatsConverter statsArraySerializer;
    @Nullable
    private final DataFileIndexWriter dataFileIndexWriter;
    private final FileSource fileSource;

    public RowDataFileWriter(FileIO fileIO, FileWriterContext context, Path path, RowType writeSchema, long schemaId, LongCounter seqNumCounter, FileIndexOptions fileIndexOptions, FileSource fileSource, boolean asyncFileWrite, boolean statsDenseStore, boolean isExternalPath) {
        super(fileIO, context, path, Function.identity(), writeSchema, asyncFileWrite);
        this.schemaId = schemaId;
        this.seqNumCounter = seqNumCounter;
        this.isExternalPath = isExternalPath;
        this.statsArraySerializer = new SimpleStatsConverter(writeSchema, statsDenseStore);
        this.dataFileIndexWriter = DataFileIndexWriter.create(fileIO, DataFilePathFactory.dataFileToFileIndexPath(path), writeSchema, fileIndexOptions);
        this.fileSource = fileSource;
    }

    @Override
    public void write(InternalRow row) throws IOException {
        super.write(row);
        if (this.dataFileIndexWriter != null) {
            this.dataFileIndexWriter.write(row);
        }
        this.seqNumCounter.add(1L);
    }

    @Override
    public void close() throws IOException {
        if (this.dataFileIndexWriter != null) {
            this.dataFileIndexWriter.close();
        }
        super.close();
    }

    @Override
    public DataFileMeta result() throws IOException {
        long fileSize = this.outputBytes;
        Pair<List<String>, SimpleStats> statsPair = this.statsArraySerializer.toBinary(this.fieldStats(fileSize));
        DataFileIndexWriter.FileIndexResult indexResult = this.dataFileIndexWriter == null ? DataFileIndexWriter.EMPTY_RESULT : this.dataFileIndexWriter.result();
        String externalPath = this.isExternalPath ? this.path.toString() : null;
        return DataFileMeta.forAppend(this.path.getName(), fileSize, this.recordCount(), (SimpleStats)statsPair.getRight(), this.seqNumCounter.getValue() - super.recordCount(), this.seqNumCounter.getValue() - 1L, this.schemaId, indexResult.independentIndexFile() == null ? Collections.emptyList() : Collections.singletonList(indexResult.independentIndexFile()), indexResult.embeddedIndexBytes(), this.fileSource, (List)statsPair.getKey(), externalPath);
    }
}

