/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.lookup.LookupStoreReader;
import org.apache.paimon.mergetree.LookupUtils;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.RemovalCause;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileIOUtils;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupFile {
    private static final Logger LOG = LoggerFactory.getLogger(LookupFile.class);
    private final File localFile;
    private final DataFileMeta remoteFile;
    private final LookupStoreReader reader;
    private final Runnable callback;
    private long requestCount;
    private long hitCount;
    private boolean isClosed = false;

    public LookupFile(File localFile, DataFileMeta remoteFile, LookupStoreReader reader, Runnable callback) {
        this.localFile = localFile;
        this.remoteFile = remoteFile;
        this.reader = reader;
        this.callback = callback;
    }

    @Nullable
    public byte[] get(byte[] key) throws IOException {
        Preconditions.checkArgument((!this.isClosed ? 1 : 0) != 0);
        ++this.requestCount;
        byte[] res = this.reader.lookup(key);
        if (res != null) {
            ++this.hitCount;
        }
        return res;
    }

    public DataFileMeta remoteFile() {
        return this.remoteFile;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close(RemovalCause cause) throws IOException {
        this.reader.close();
        this.isClosed = true;
        this.callback.run();
        LOG.info("Delete Lookup file {} due to {}. Access stats: requestCount={}, hitCount={}, size={}KB", new Object[]{this.localFile.getName(), cause, this.requestCount, this.hitCount, this.localFile.length() >> 10});
        FileIOUtils.deleteFileOrDirectory((File)this.localFile);
    }

    public static Cache<String, LookupFile> createCache(Duration fileRetention, MemorySize maxDiskSize) {
        return Caffeine.newBuilder().expireAfterAccess(fileRetention).maximumWeight(maxDiskSize.getKibiBytes()).weigher(LookupFile::fileWeigh).removalListener(LookupFile::removalCallback).executor(Runnable::run).build();
    }

    private static int fileWeigh(String file, LookupFile lookupFile) {
        return LookupUtils.fileKibiBytes(lookupFile.localFile);
    }

    private static void removalCallback(String file, LookupFile lookupFile, RemovalCause cause) {
        if (lookupFile != null) {
            try {
                lookupFile.close(cause);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static String localFilePrefix(RowType partitionType, BinaryRow partition, int bucket, String remoteFileName) {
        if (partition.getFieldCount() == 0) {
            return String.format("%s-%s", bucket, remoteFileName);
        }
        String partitionString = InternalRowPartitionComputer.partToSimpleString((RowType)partitionType, (BinaryRow)partition, (String)"-", (int)20);
        return String.format("%s-%s-%s", partitionString, bucket, remoteFileName);
    }
}

