/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.index.IndexMaintainer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.memory.MemoryPoolFactory;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.Restorable;

public interface FileStoreWrite<T>
extends Restorable<List<State<T>>> {
    public FileStoreWrite<T> withIOManager(IOManager var1);

    default public FileStoreWrite<T> withMemoryPool(MemorySegmentPool memoryPool) {
        return this.withMemoryPoolFactory(new MemoryPoolFactory(memoryPool));
    }

    public FileStoreWrite<T> withMemoryPoolFactory(MemoryPoolFactory var1);

    public void withIgnorePreviousFiles(boolean var1);

    public void withIgnoreNumBucketCheck(boolean var1);

    public void withExecutionMode(boolean var1);

    public FileStoreWrite<T> withMetricRegistry(MetricRegistry var1);

    public void withCompactExecutor(ExecutorService var1);

    public void write(BinaryRow var1, int var2, T var3) throws Exception;

    public void compact(BinaryRow var1, int var2, boolean var3) throws Exception;

    public void notifyNewFiles(long var1, BinaryRow var3, int var4, List<DataFileMeta> var5);

    public List<CommitMessage> prepareCommit(boolean var1, long var2) throws Exception;

    public void close() throws Exception;

    public static class State<T> {
        protected final BinaryRow partition;
        protected final int bucket;
        protected final int totalBuckets;
        protected final long baseSnapshotId;
        protected final long lastModifiedCommitIdentifier;
        protected final List<DataFileMeta> dataFiles;
        protected final long maxSequenceNumber;
        @Nullable
        protected final IndexMaintainer<T> indexMaintainer;
        @Nullable
        protected final DeletionVectorsMaintainer deletionVectorsMaintainer;
        protected final CommitIncrement commitIncrement;

        protected State(BinaryRow partition, int bucket, int totalBuckets, long baseSnapshotId, long lastModifiedCommitIdentifier, Collection<DataFileMeta> dataFiles, long maxSequenceNumber, @Nullable IndexMaintainer<T> indexMaintainer, @Nullable DeletionVectorsMaintainer deletionVectorsMaintainer, CommitIncrement commitIncrement) {
            this.partition = partition;
            this.bucket = bucket;
            this.totalBuckets = totalBuckets;
            this.baseSnapshotId = baseSnapshotId;
            this.lastModifiedCommitIdentifier = lastModifiedCommitIdentifier;
            this.dataFiles = new ArrayList<DataFileMeta>(dataFiles);
            this.maxSequenceNumber = maxSequenceNumber;
            this.indexMaintainer = indexMaintainer;
            this.deletionVectorsMaintainer = deletionVectorsMaintainer;
            this.commitIncrement = commitIncrement;
        }

        public String toString() {
            return String.format("{%s, %d, %d, %d, %d, %s, %d, %s, %s, %s}", this.partition, this.bucket, this.totalBuckets, this.baseSnapshotId, this.lastModifiedCommitIdentifier, this.dataFiles, this.maxSequenceNumber, this.indexMaintainer, this.deletionVectorsMaintainer, this.commitIncrement);
        }
    }
}

