/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.BucketEntry;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.operation.ManifestsReader;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.PredicateReplaceVisitor;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingContext;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SimpleFileReader;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class AuditLogTable
implements DataTable,
ReadonlyTable {
    public static final String AUDIT_LOG = "audit_log";
    public static final PredicateReplaceVisitor PREDICATE_CONVERTER = p -> {
        if (p.index() == 0) {
            return Optional.empty();
        }
        return Optional.of(new LeafPredicate(p.function(), p.type(), p.index() - 1, p.fieldName(), p.literals()));
    };
    private final FileStoreTable wrapped;

    public AuditLogTable(FileStoreTable wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Optional<Snapshot> latestSnapshot() {
        return this.wrapped.latestSnapshot();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.wrapped.snapshot(snapshotId);
    }

    @Override
    public SimpleFileReader<ManifestFileMeta> manifestListReader() {
        return this.wrapped.manifestListReader();
    }

    @Override
    public SimpleFileReader<ManifestEntry> manifestFileReader() {
        return this.wrapped.manifestFileReader();
    }

    @Override
    public SimpleFileReader<IndexManifestEntry> indexManifestFileReader() {
        return this.wrapped.indexManifestFileReader();
    }

    @Override
    public String name() {
        return this.wrapped.name() + "$" + AUDIT_LOG;
    }

    @Override
    public RowType rowType() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(SpecialFields.ROW_KIND);
        fields.addAll(this.wrapped.rowType().getFields());
        return new RowType(fields);
    }

    @Override
    public List<String> partitionKeys() {
        return this.wrapped.partitionKeys();
    }

    @Override
    public Map<String, String> options() {
        return this.wrapped.options();
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.emptyList();
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        return new AuditLogDataReader(this.wrapped.newSnapshotReader());
    }

    @Override
    public DataTableScan newScan() {
        return new AuditLogBatchScan(this.wrapped.newScan());
    }

    @Override
    public StreamDataTableScan newStreamScan() {
        return new AuditLogStreamScan(this.wrapped.newStreamScan());
    }

    @Override
    public CoreOptions coreOptions() {
        return this.wrapped.coreOptions();
    }

    @Override
    public Path location() {
        return this.wrapped.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.wrapped.snapshotManager();
    }

    @Override
    public ChangelogManager changelogManager() {
        return this.wrapped.changelogManager();
    }

    @Override
    public ConsumerManager consumerManager() {
        return this.wrapped.consumerManager();
    }

    @Override
    public SchemaManager schemaManager() {
        return this.wrapped.schemaManager();
    }

    @Override
    public TagManager tagManager() {
        return this.wrapped.tagManager();
    }

    @Override
    public BranchManager branchManager() {
        return this.wrapped.branchManager();
    }

    @Override
    public DataTable switchToBranch(String branchName) {
        return new AuditLogTable(this.wrapped.switchToBranch(branchName));
    }

    @Override
    public InnerTableRead newRead() {
        return new AuditLogRead(this.wrapped.newRead());
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new AuditLogTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions));
    }

    @Override
    public FileIO fileIO() {
        return this.wrapped.fileIO();
    }

    private Optional<Predicate> convert(Predicate predicate) {
        List result = PredicateBuilder.splitAnd((Predicate)predicate).stream().map(p -> (Optional)p.visit((PredicateVisitor)PREDICATE_CONVERTER)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(PredicateBuilder.and(result));
    }

    static class AuditLogRow
    extends ProjectedRow {
        AuditLogRow(int[] indexMapping, InternalRow row) {
            super(indexMapping);
            this.replaceRow(row);
        }

        public RowKind getRowKind() {
            return RowKind.INSERT;
        }

        public void setRowKind(RowKind kind) {
            throw new UnsupportedOperationException("Set row kind is not supported in AuditLogRowData.");
        }

        public boolean isNullAt(int pos) {
            if (this.indexMapping[pos] < 0) {
                return false;
            }
            return super.isNullAt(pos);
        }

        public BinaryString getString(int pos) {
            if (this.indexMapping[pos] < 0) {
                return BinaryString.fromString((String)this.row.getRowKind().shortString());
            }
            return super.getString(pos);
        }
    }

    class AuditLogRead
    implements InnerTableRead {
        protected final InnerTableRead dataRead;
        protected int[] readProjection;

        protected AuditLogRead(InnerTableRead dataRead) {
            this.dataRead = dataRead.forceKeepDelete();
            this.readProjection = this.defaultProjection();
        }

        private int[] defaultProjection() {
            int dataFieldCount = AuditLogTable.this.wrapped.rowType().getFieldCount();
            int[] projection = new int[dataFieldCount + 1];
            projection[0] = -1;
            for (int i = 0; i < dataFieldCount; ++i) {
                projection[i + 1] = i;
            }
            return projection;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            AuditLogTable.this.convert(predicate).ifPresent(this.dataRead::withFilter);
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            ArrayList dataReadFields = new ArrayList();
            List fields = readType.getFields();
            int[] readProjection = new int[fields.size()];
            boolean rowKindAppeared = false;
            for (int i = 0; i < fields.size(); ++i) {
                String fieldName = ((DataField)fields.get(i)).name();
                if (fieldName.equals(SpecialFields.ROW_KIND.name())) {
                    rowKindAppeared = true;
                    readProjection[i] = -1;
                    continue;
                }
                dataReadFields.add(fields.get(i));
                readProjection[i] = rowKindAppeared ? i - 1 : i;
            }
            this.readProjection = readProjection;
            this.dataRead.withReadType(new RowType(readType.isNullable(), dataReadFields));
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            this.dataRead.withIOManager(ioManager);
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            return this.dataRead.createReader(split).transform(this::convertRow);
        }

        private InternalRow convertRow(InternalRow data) {
            return new AuditLogRow(this.readProjection, data);
        }
    }

    private class AuditLogStreamScan
    implements StreamDataTableScan {
        private final StreamDataTableScan streamScan;

        private AuditLogStreamScan(StreamDataTableScan streamScan) {
            this.streamScan = streamScan;
        }

        @Override
        public StreamDataTableScan withFilter(Predicate predicate) {
            AuditLogTable.this.convert(predicate).ifPresent(this.streamScan::withFilter);
            return this;
        }

        @Override
        public StartingContext startingContext() {
            return this.streamScan.startingContext();
        }

        @Override
        public TableScan.Plan plan() {
            return this.streamScan.plan();
        }

        @Override
        public List<PartitionEntry> listPartitionEntries() {
            return this.streamScan.listPartitionEntries();
        }

        @Override
        @Nullable
        public Long checkpoint() {
            return this.streamScan.checkpoint();
        }

        @Override
        @Nullable
        public Long watermark() {
            return this.streamScan.watermark();
        }

        @Override
        public void restore(@Nullable Long nextSnapshotId) {
            this.streamScan.restore(nextSnapshotId);
        }

        @Override
        public void restore(@Nullable Long nextSnapshotId, boolean scanAllSnapshot) {
            this.streamScan.restore(nextSnapshotId, scanAllSnapshot);
        }

        @Override
        public void notifyCheckpointComplete(@Nullable Long nextSnapshot) {
            this.streamScan.notifyCheckpointComplete(nextSnapshot);
        }

        @Override
        public StreamDataTableScan withMetricRegistry(MetricRegistry metricsRegistry) {
            this.streamScan.withMetricRegistry(metricsRegistry);
            return this;
        }

        @Override
        public DataTableScan withShard(int indexOfThisSubtask, int numberOfParallelSubtasks) {
            this.streamScan.withShard(indexOfThisSubtask, numberOfParallelSubtasks);
            return this;
        }
    }

    private class AuditLogBatchScan
    implements DataTableScan {
        private final DataTableScan batchScan;

        private AuditLogBatchScan(DataTableScan batchScan) {
            this.batchScan = batchScan;
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            AuditLogTable.this.convert(predicate).ifPresent(this.batchScan::withFilter);
            return this;
        }

        @Override
        public InnerTableScan withMetricRegistry(MetricRegistry metricsRegistry) {
            this.batchScan.withMetricRegistry(metricsRegistry);
            return this;
        }

        @Override
        public InnerTableScan withLimit(int limit) {
            this.batchScan.withLimit(limit);
            return this;
        }

        @Override
        public InnerTableScan withPartitionFilter(Map<String, String> partitionSpec) {
            this.batchScan.withPartitionFilter(partitionSpec);
            return this;
        }

        @Override
        public InnerTableScan withPartitionFilter(List<BinaryRow> partitions) {
            this.batchScan.withPartitionFilter(partitions);
            return this;
        }

        @Override
        public InnerTableScan withPartitionsFilter(List<Map<String, String>> partitions) {
            this.batchScan.withPartitionsFilter(partitions);
            return this;
        }

        @Override
        public InnerTableScan withBucketFilter(Filter<Integer> bucketFilter) {
            this.batchScan.withBucketFilter(bucketFilter);
            return this;
        }

        @Override
        public InnerTableScan withLevelFilter(Filter<Integer> levelFilter) {
            this.batchScan.withLevelFilter(levelFilter);
            return this;
        }

        @Override
        public TableScan.Plan plan() {
            return this.batchScan.plan();
        }

        @Override
        public List<PartitionEntry> listPartitionEntries() {
            return this.batchScan.listPartitionEntries();
        }

        @Override
        public DataTableScan withShard(int indexOfThisSubtask, int numberOfParallelSubtasks) {
            this.batchScan.withShard(indexOfThisSubtask, numberOfParallelSubtasks);
            return this;
        }
    }

    private class AuditLogDataReader
    implements SnapshotReader {
        private final SnapshotReader wrapped;

        private AuditLogDataReader(SnapshotReader wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Integer parallelism() {
            return this.wrapped.parallelism();
        }

        @Override
        public SnapshotManager snapshotManager() {
            return this.wrapped.snapshotManager();
        }

        @Override
        public ChangelogManager changelogManager() {
            return this.wrapped.changelogManager();
        }

        @Override
        public ManifestsReader manifestsReader() {
            return this.wrapped.manifestsReader();
        }

        @Override
        public List<ManifestEntry> readManifest(ManifestFileMeta manifest) {
            return this.wrapped.readManifest(manifest);
        }

        @Override
        public ConsumerManager consumerManager() {
            return this.wrapped.consumerManager();
        }

        @Override
        public SplitGenerator splitGenerator() {
            return this.wrapped.splitGenerator();
        }

        @Override
        public FileStorePathFactory pathFactory() {
            return this.wrapped.pathFactory();
        }

        @Override
        public SnapshotReader withSnapshot(long snapshotId) {
            this.wrapped.withSnapshot(snapshotId);
            return this;
        }

        @Override
        public SnapshotReader withSnapshot(Snapshot snapshot) {
            this.wrapped.withSnapshot(snapshot);
            return this;
        }

        @Override
        public SnapshotReader withFilter(Predicate predicate) {
            AuditLogTable.this.convert(predicate).ifPresent(this.wrapped::withFilter);
            return this;
        }

        @Override
        public SnapshotReader withPartitionFilter(Map<String, String> partitionSpec) {
            this.wrapped.withPartitionFilter(partitionSpec);
            return this;
        }

        @Override
        public SnapshotReader withPartitionFilter(Predicate predicate) {
            this.wrapped.withPartitionFilter(predicate);
            return this;
        }

        @Override
        public SnapshotReader withPartitionFilter(List<BinaryRow> partitions) {
            this.wrapped.withPartitionFilter(partitions);
            return this;
        }

        @Override
        public SnapshotReader withPartitionsFilter(List<Map<String, String>> partitions) {
            this.wrapped.withPartitionsFilter(partitions);
            return this;
        }

        @Override
        public SnapshotReader withMode(ScanMode scanMode) {
            this.wrapped.withMode(scanMode);
            return this;
        }

        @Override
        public SnapshotReader withLevel(int level) {
            this.wrapped.withLevel(level);
            return this;
        }

        @Override
        public SnapshotReader withLevelFilter(Filter<Integer> levelFilter) {
            this.wrapped.withLevelFilter(levelFilter);
            return this;
        }

        @Override
        public SnapshotReader enableValueFilter() {
            this.wrapped.enableValueFilter();
            return this;
        }

        @Override
        public SnapshotReader withManifestEntryFilter(Filter<ManifestEntry> filter) {
            this.wrapped.withManifestEntryFilter(filter);
            return this;
        }

        @Override
        public SnapshotReader withBucket(int bucket) {
            this.wrapped.withBucket(bucket);
            return this;
        }

        @Override
        public SnapshotReader onlyReadRealBuckets() {
            this.wrapped.onlyReadRealBuckets();
            return this;
        }

        @Override
        public SnapshotReader withBucketFilter(Filter<Integer> bucketFilter) {
            this.wrapped.withBucketFilter(bucketFilter);
            return this;
        }

        @Override
        public SnapshotReader withDataFileNameFilter(Filter<String> fileNameFilter) {
            this.wrapped.withDataFileNameFilter(fileNameFilter);
            return this;
        }

        @Override
        public SnapshotReader dropStats() {
            this.wrapped.dropStats();
            return this;
        }

        @Override
        public SnapshotReader withShard(int indexOfThisSubtask, int numberOfParallelSubtasks) {
            this.wrapped.withShard(indexOfThisSubtask, numberOfParallelSubtasks);
            return this;
        }

        @Override
        public SnapshotReader withMetricRegistry(MetricRegistry registry) {
            this.wrapped.withMetricRegistry(registry);
            return this;
        }

        @Override
        public SnapshotReader.Plan read() {
            return this.wrapped.read();
        }

        @Override
        public SnapshotReader.Plan readChanges() {
            return this.wrapped.readChanges();
        }

        @Override
        public SnapshotReader.Plan readIncrementalDiff(Snapshot before) {
            return this.wrapped.readIncrementalDiff(before);
        }

        @Override
        public List<BinaryRow> partitions() {
            return this.wrapped.partitions();
        }

        @Override
        public List<PartitionEntry> partitionEntries() {
            return this.wrapped.partitionEntries();
        }

        @Override
        public List<BucketEntry> bucketEntries() {
            return this.wrapped.bucketEntries();
        }

        @Override
        public Iterator<ManifestEntry> readFileIterator() {
            return this.wrapped.readFileIterator();
        }
    }
}

