/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.UnmodifiableStatisticException;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.StatisticEntity;
import org.apache.gravitino.stats.PartitionRange;
import org.apache.gravitino.stats.PartitionStatistics;
import org.apache.gravitino.stats.PartitionStatisticsDrop;
import org.apache.gravitino.stats.PartitionStatisticsUpdate;
import org.apache.gravitino.stats.Statistic;
import org.apache.gravitino.stats.StatisticValue;
import org.apache.gravitino.stats.storage.MetadataObjectStatisticsDrop;
import org.apache.gravitino.stats.storage.MetadataObjectStatisticsUpdate;
import org.apache.gravitino.stats.storage.PartitionStatisticStorage;
import org.apache.gravitino.stats.storage.PartitionStatisticStorageFactory;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticManager
implements Closeable {
    private static final String OPTIONS_PREFIX = "gravitino.stats.partition.storageOption.";
    private static final Logger LOG = LoggerFactory.getLogger(StatisticManager.class);
    private final EntityStore store;
    private final IdGenerator idGenerator;
    private final PartitionStatisticStorage partitionStorage;

    public StatisticManager(EntityStore store, IdGenerator idGenerator, Config config) {
        this.store = store;
        this.idGenerator = idGenerator;
        String className = (String)config.get(Configs.PARTITION_STATS_STORAGE_FACTORY_CLASS);
        Map options = config.getConfigsWithPrefix(OPTIONS_PREFIX);
        try {
            PartitionStatisticStorageFactory factory = (PartitionStatisticStorageFactory)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.partitionStorage = factory.create(options);
        }
        catch (Exception e) {
            LOG.error("Failed to create and initialize partition statistics storage factory by name {}.", (Object)className, (Object)e);
            throw new RuntimeException("Failed to create and initialize partition statistics storage factory: " + className, e);
        }
    }

    public List<Statistic> listStatistics(String metalake, MetadataObject metadataObject) {
        try {
            NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
            Entity.EntityType type = StatisticEntity.getStatisticType(metadataObject.type());
            return TreeLockUtils.doWithTreeLock(identifier, LockType.READ, () -> this.store.list(Namespace.fromString((String)identifier.toString()), StatisticEntity.class, type).stream().map(entity -> {
                String name = entity.name();
                StatisticValue<?> value = entity.value();
                return new CustomStatistic(name, value, entity.auditInfo());
            }).collect(Collectors.toList()));
        }
        catch (NoSuchEntityException nse) {
            LOG.warn("Failed to list statistics for metadata object {} in the metalake {}: {}", new Object[]{metadataObject.fullName(), metalake, nse.getMessage()});
            throw new NoSuchMetadataObjectException("The metadata object %s in the metalake %s isn't found", new Object[]{metadataObject.fullName(), metalake});
        }
        catch (IOException ioe) {
            LOG.error("Failed to list statistics for metadata object {} in the metalake {} : {}", new Object[]{metadataObject.fullName(), metalake, ioe.getMessage()});
            throw new RuntimeException(ioe);
        }
    }

    public void updateStatistics(String metalake, MetadataObject metadataObject, Map<String, StatisticValue<?>> statistics) {
        try {
            NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
            ArrayList statisticEntities = Lists.newArrayList();
            for (Map.Entry<String, StatisticValue<?>> entry : statistics.entrySet()) {
                String name = entry.getKey();
                StatisticValue<?> value = entry.getValue();
                Object statistic = ((StatisticEntity.StatisticEntityBuilder)((StatisticEntity.StatisticEntityBuilder)((StatisticEntity.StatisticEntityBuilder)((StatisticEntity.StatisticEntityBuilder)((StatisticEntity.StatisticEntityBuilder)((StatisticEntity.StatisticEntityBuilder)StatisticEntity.builder(StatisticEntity.getStatisticType(metadataObject.type()))).withId(this.idGenerator.nextId())).withName(name)).withValue(value)).withNamespace(Namespace.fromString((String)identifier.toString()))).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build())).build();
                statisticEntities.add(statistic);
            }
            TreeLockUtils.doWithTreeLock(identifier, LockType.WRITE, () -> {
                this.store.batchPut(statisticEntities, true);
                return null;
            });
        }
        catch (NoSuchEntityException nse) {
            LOG.warn("Failed to update statistics for metadata object {} in the metalake {}: {}", new Object[]{metadataObject.fullName(), metalake, nse.getMessage()});
            throw new NoSuchMetadataObjectException("The metadata object %s in the metalake %s isn't found", new Object[]{metadataObject.fullName(), metalake});
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public boolean dropStatistics(String metalake, MetadataObject metadataObject, List<String> statistics) throws UnmodifiableStatisticException {
        try {
            NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
            Entity.EntityType type = StatisticEntity.getStatisticType(metadataObject.type());
            ArrayList idents = Lists.newArrayList();
            for (String statistic : statistics) {
                Pair pair = Pair.of((Object)NameIdentifierUtil.ofStatistic(identifier, statistic), (Object)((Object)type));
                idents.add(pair);
            }
            int deleteCount = TreeLockUtils.doWithTreeLock(identifier, LockType.WRITE, () -> this.store.batchDelete(idents, true));
            return deleteCount != 0;
        }
        catch (NoSuchEntityException nse) {
            LOG.warn("Failed to drop statistics for metadata object {} in the metalake {} : {}", new Object[]{metadataObject.fullName(), metalake, nse.getMessage()});
            throw new NoSuchMetadataObjectException("The metadata object %s in the metalake %s isn't found", new Object[]{metadataObject.fullName(), metalake});
        }
        catch (IOException ioe) {
            LOG.error("Failed to drop statistics for metadata object {} in the metalake {} : {}", new Object[]{metadataObject.fullName(), metalake, ioe.getMessage()});
            throw new RuntimeException(ioe);
        }
    }

    public boolean dropPartitionStatistics(String metalake, MetadataObject metadataObject, List<PartitionStatisticsDrop> partitionStatistics) {
        try {
            ArrayList partitionStatisticsToDrop = Lists.newArrayList((Object[])new MetadataObjectStatisticsDrop[]{MetadataObjectStatisticsDrop.of(metadataObject, partitionStatistics)});
            NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
            return TreeLockUtils.doWithTreeLock(identifier, LockType.WRITE, () -> this.partitionStorage.dropStatistics(metalake, partitionStatisticsToDrop)) != 0;
        }
        catch (IOException ioe) {
            LOG.error("Failed to drop partition statistics for {} in metalake {}.", new Object[]{metadataObject, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    public void updatePartitionStatistics(String metalake, MetadataObject metadataObject, List<PartitionStatisticsUpdate> partitionStatistics) {
        try {
            NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
            ArrayList statisticsToUpdate = Lists.newArrayList();
            statisticsToUpdate.add(MetadataObjectStatisticsUpdate.of(metadataObject, partitionStatistics));
            TreeLockUtils.doWithTreeLock(identifier, LockType.WRITE, () -> {
                this.partitionStorage.updateStatistics(metalake, statisticsToUpdate);
                return null;
            });
        }
        catch (IOException ioe) {
            LOG.error("Failed to update partition statistics for {} in metalake {}.", new Object[]{metadataObject, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    public List<PartitionStatistics> listPartitionStatistics(String metalake, MetadataObject metadataObject, PartitionRange range) {
        try {
            NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, metadataObject);
            List partitionStats = TreeLockUtils.doWithTreeLock(identifier, LockType.READ, () -> this.partitionStorage.listStatistics(metalake, metadataObject, range));
            ArrayList listedStats = Lists.newArrayList();
            if (partitionStats == null || partitionStats.isEmpty()) {
                return listedStats;
            }
            return partitionStats.stream().map(partitionStat -> {
                String partitionName = partitionStat.partitionName();
                Statistic[] statistics = (Statistic[])partitionStat.statistics().stream().map(entry -> {
                    String statName = entry.name();
                    StatisticValue<?> value = entry.value();
                    AuditInfo auditInfo = entry.auditInfo();
                    return new CustomStatistic(statName, value, auditInfo);
                }).toArray(Statistic[]::new);
                return new CustomPartitionStatistic(partitionName, statistics);
            }).collect(Collectors.toList());
        }
        catch (IOException ioe) {
            LOG.error("Failed to list partition statistics for {} in metalake {}.", new Object[]{metadataObject, metalake, ioe});
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void close() throws IOException {
        this.partitionStorage.close();
    }

    @VisibleForTesting
    public static class CustomPartitionStatistic
    implements PartitionStatistics {
        private final String partitionName;
        private final Statistic[] statistics;

        public CustomPartitionStatistic(String partitionName, Statistic[] statistics) {
            this.partitionName = partitionName;
            this.statistics = statistics;
        }

        public String partitionName() {
            return this.partitionName;
        }

        public Statistic[] statistics() {
            return this.statistics;
        }
    }

    @VisibleForTesting
    public static class CustomStatistic
    implements Statistic {
        private final String name;
        private final StatisticValue<?> value;
        private final Audit auditInfo;

        public CustomStatistic(String name, StatisticValue<?> value, Audit auditInfo) {
            this.name = name;
            this.value = value;
            this.auditInfo = auditInfo;
        }

        public String name() {
            return this.name;
        }

        public Optional<StatisticValue<?>> value() {
            return Optional.of(this.value);
        }

        public boolean reserved() {
            return false;
        }

        public boolean modifiable() {
            return true;
        }

        public Audit auditInfo() {
            return this.auditInfo;
        }
    }
}

