/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.annotation.Unstable;
import org.apache.gravitino.authorization.AuthorizationPrivilege;
import org.apache.gravitino.authorization.AuthorizationSecurableObject;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.MetadataObjectChange;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.RoleChange;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.authorization.jdbc.JdbcAuthorizationProperties;
import org.apache.gravitino.authorization.jdbc.JdbcAuthorizationSQL;
import org.apache.gravitino.authorization.jdbc.JdbcSecurableObjectMappingProvider;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.UserEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unstable
public abstract class JdbcAuthorizationPlugin
implements AuthorizationPlugin,
JdbcAuthorizationSQL {
    private static final String GROUP_PREFIX = "GRAVITINO_GROUP_";
    private static final Logger LOG = LoggerFactory.getLogger(JdbcAuthorizationPlugin.class);
    protected BasicDataSource dataSource = new BasicDataSource();
    protected JdbcSecurableObjectMappingProvider mappingProvider;

    protected JdbcAuthorizationPlugin(Map<String, String> config) {
        JdbcAuthorizationProperties jdbcAuthProperties = new JdbcAuthorizationProperties(config);
        jdbcAuthProperties.validate();
        String jdbcUrl = config.get("authorization.jdbc.url");
        this.dataSource.setUrl(jdbcUrl);
        this.dataSource.setDriverClassName(config.get("authorization.jdbc.driver"));
        this.dataSource.setUsername(config.get("authorization.jdbc.username"));
        this.dataSource.setPassword(config.get("authorization.jdbc.password"));
        this.dataSource.setDefaultAutoCommit(Boolean.valueOf(true));
        this.dataSource.setMaxTotal(20);
        this.dataSource.setMaxIdle(5);
        this.dataSource.setMinIdle(0);
        this.dataSource.setLogAbandoned(true);
        this.dataSource.setRemoveAbandonedOnBorrow(true);
        this.dataSource.setTestOnBorrow(false);
        this.dataSource.setTestWhileIdle(false);
        this.dataSource.setNumTestsPerEvictionRun(3);
        this.dataSource.setTestOnReturn(false);
        this.dataSource.setLifo(true);
        this.mappingProvider = new JdbcSecurableObjectMappingProvider();
        try (Connection ignored = this.getConnection();){
            LOG.info("Load the JDBC driver first");
        }
        catch (SQLException se) {
            LOG.error("Jdbc authorization plugin exception: ", (Throwable)se);
            throw this.toAuthorizationPluginException(se);
        }
    }

    public void close() throws IOException {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
                this.dataSource = null;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Boolean onMetadataUpdated(MetadataObjectChange ... changes) throws RuntimeException {
        return true;
    }

    public Boolean onRoleCreated(Role role) throws AuthorizationPluginException {
        List<String> sqls = this.getCreateRoleSQL(role.name());
        boolean createdNewly = true;
        for (String sql : sqls) {
            if (this.executeUpdateSQL(sql, "already exists")) continue;
            createdNewly = false;
        }
        if (!createdNewly) {
            return true;
        }
        if (role.securableObjects() != null) {
            for (SecurableObject object : role.securableObjects()) {
                this.onRoleUpdated(role, RoleChange.addSecurableObject((String)role.name(), (SecurableObject)object));
            }
        }
        return true;
    }

    public Boolean onRoleAcquired(Role role) throws AuthorizationPluginException {
        throw new UnsupportedOperationException("Doesn't support to acquired a role");
    }

    public Boolean onRoleDeleted(Role role) throws AuthorizationPluginException {
        List<String> sqls = this.getDropRoleSQL(role.name());
        for (String sql : sqls) {
            this.executeUpdateSQL(sql);
        }
        return true;
    }

    public Boolean onRoleUpdated(Role role, RoleChange ... changes) throws AuthorizationPluginException {
        for (RoleChange change : changes) {
            SecurableObject object;
            if (change instanceof RoleChange.AddSecurableObject) {
                object = ((RoleChange.AddSecurableObject)change).getSecurableObject();
                this.grantObjectPrivileges(role, object);
                continue;
            }
            if (change instanceof RoleChange.RemoveSecurableObject) {
                object = ((RoleChange.RemoveSecurableObject)change).getSecurableObject();
                this.revokeObjectPrivileges(role, object);
                continue;
            }
            if (change instanceof RoleChange.UpdateSecurableObject) {
                RoleChange.UpdateSecurableObject updateChange = (RoleChange.UpdateSecurableObject)change;
                SecurableObject addObject = updateChange.getNewSecurableObject();
                SecurableObject removeObject = updateChange.getSecurableObject();
                this.revokeObjectPrivileges(role, removeObject);
                this.grantObjectPrivileges(role, addObject);
                continue;
            }
            throw new IllegalArgumentException(String.format("RoleChange is not supported - %s", change));
        }
        return true;
    }

    public Boolean onGrantedRolesToUser(List<Role> roles, User user) throws AuthorizationPluginException {
        for (Role role : roles) {
            this.onRoleCreated(role);
            List<String> sqls = this.getGrantRoleSQL(role.name(), "USER", user.name());
            for (String sql : sqls) {
                this.executeUpdateSQL(sql);
            }
        }
        return true;
    }

    public Boolean onRevokedRolesFromUser(List<Role> roles, User user) throws AuthorizationPluginException {
        for (Role role : roles) {
            this.onRoleCreated(role);
            List<String> sqls = this.getRevokeRoleSQL(role.name(), "USER", user.name());
            for (String sql : sqls) {
                this.executeUpdateSQL(sql);
            }
        }
        return true;
    }

    public Boolean onGrantedRolesToGroup(List<Role> roles, Group group) throws AuthorizationPluginException {
        for (Role role : roles) {
            this.onRoleCreated(role);
            List<String> sqls = this.getGrantRoleSQL(role.name(), "USER", String.format("%s%s", GROUP_PREFIX, group.name()));
            for (String sql : sqls) {
                this.executeUpdateSQL(sql);
            }
        }
        return true;
    }

    public Boolean onRevokedRolesFromGroup(List<Role> roles, Group group) throws AuthorizationPluginException {
        for (Role role : roles) {
            this.onRoleCreated(role);
            List<String> sqls = this.getRevokeRoleSQL(role.name(), "USER", String.format("%s%s", GROUP_PREFIX, group.name()));
            for (String sql : sqls) {
                this.executeUpdateSQL(sql);
            }
        }
        return true;
    }

    public Boolean onUserAdded(User user) throws AuthorizationPluginException {
        List<String> sqls = this.getCreateUserSQL(user.name());
        for (String sql : sqls) {
            this.executeUpdateSQL(sql);
        }
        return true;
    }

    public Boolean onUserRemoved(User user) throws AuthorizationPluginException {
        List<String> sqls = this.getDropUserSQL(user.name());
        for (String sql : sqls) {
            this.executeUpdateSQL(sql);
        }
        return true;
    }

    public Boolean onUserAcquired(User user) throws AuthorizationPluginException {
        throw new UnsupportedOperationException("Doesn't support to acquired a user");
    }

    public Boolean onGroupAdded(Group group) throws AuthorizationPluginException {
        String name = String.format("%s%s", GROUP_PREFIX, group.name());
        List<String> sqls = this.getCreateUserSQL(name);
        for (String sql : sqls) {
            this.executeUpdateSQL(sql);
        }
        return true;
    }

    public Boolean onGroupRemoved(Group group) throws AuthorizationPluginException {
        String name = String.format("%s%s", GROUP_PREFIX, group.name());
        List<String> sqls = this.getDropUserSQL(name);
        for (String sql : sqls) {
            this.executeUpdateSQL(sql);
        }
        return true;
    }

    public Boolean onGroupAcquired(Group group) throws AuthorizationPluginException {
        throw new UnsupportedOperationException("Doesn't support to acquired a group");
    }

    public Boolean onOwnerSet(MetadataObject metadataObject, Owner preOwner, Owner newOwner) throws AuthorizationPluginException {
        if (newOwner.type() == Owner.Type.USER) {
            this.onUserAdded((User)UserEntity.builder().withName(newOwner.name()).withId(Long.valueOf(0L)).withAuditInfo(AuditInfo.EMPTY).build());
        } else if (newOwner.type() == Owner.Type.GROUP) {
            this.onGroupAdded((Group)GroupEntity.builder().withName(newOwner.name()).withId(Long.valueOf(0L)).withAuditInfo(AuditInfo.EMPTY).build());
        } else {
            throw new IllegalArgumentException(String.format("Don't support owner type %s", newOwner.type()));
        }
        List<AuthorizationSecurableObject> authObjects = this.mappingProvider.translateOwner(metadataObject);
        for (AuthorizationSecurableObject authObject : authObjects) {
            List sqls = this.getSetOwnerSQL(authObject.type().metadataObjectType(), authObject.fullName(), preOwner, newOwner);
            for (String sql : sqls) {
                this.executeUpdateSQL(sql);
            }
        }
        return true;
    }

    @Override
    public List<String> getCreateUserSQL(String username) {
        return Lists.newArrayList((Object[])new String[]{String.format("CREATE USER %s", username)});
    }

    @Override
    public List<String> getDropUserSQL(String username) {
        return Lists.newArrayList((Object[])new String[]{String.format("DROP USER %s", username)});
    }

    @Override
    public List<String> getCreateRoleSQL(String roleName) {
        return Lists.newArrayList((Object[])new String[]{String.format("CREATE ROLE %s", roleName)});
    }

    @Override
    public List<String> getDropRoleSQL(String roleName) {
        return Lists.newArrayList((Object[])new String[]{String.format("DROP ROLE %s", roleName)});
    }

    @Override
    public List<String> getGrantPrivilegeSQL(String privilege, String objectType, String objectName, String roleName) {
        return Lists.newArrayList((Object[])new String[]{String.format("GRANT %s ON %s %s TO ROLE %s", privilege, objectType, objectName, roleName)});
    }

    @Override
    public List<String> getRevokePrivilegeSQL(String privilege, String objectType, String objectName, String roleName) {
        return Lists.newArrayList((Object[])new String[]{String.format("REVOKE %s ON %s %s FROM ROLE %s", privilege, objectType, objectName, roleName)});
    }

    @Override
    public List<String> getGrantRoleSQL(String roleName, String grantorType, String grantorName) {
        return Lists.newArrayList((Object[])new String[]{String.format("GRANT ROLE %s TO %s %s", roleName, grantorType, grantorName)});
    }

    @Override
    public List<String> getRevokeRoleSQL(String roleName, String revokerType, String revokerName) {
        return Lists.newArrayList((Object[])new String[]{String.format("REVOKE ROLE %s FROM %s %s", roleName, revokerType, revokerName)});
    }

    @VisibleForTesting
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void executeUpdateSQL(String sql) {
        this.executeUpdateSQL(sql, null);
    }

    protected List<AuthorizationSecurableObject> convertResourceAll(AuthorizationSecurableObject object) {
        ArrayList authObjects = Lists.newArrayList();
        authObjects.add(object);
        return authObjects;
    }

    protected List<AuthorizationPrivilege> filterUnsupportedPrivileges(List<AuthorizationPrivilege> privileges) {
        return privileges;
    }

    protected AuthorizationPluginException toAuthorizationPluginException(SQLException se) {
        return new AuthorizationPluginException("JDBC authorization plugin fail to execute SQL, error code: %d", new Object[]{se.getErrorCode()});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean executeUpdateSQL(String sql, String ignoreErrorMsg) {
        try (Connection connection = this.getConnection();){
            boolean bl;
            block15: {
                Statement statement = connection.createStatement();
                try {
                    statement.executeUpdate(sql);
                    bl = true;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException se) {
            if (ignoreErrorMsg != null && se.getMessage().contains(ignoreErrorMsg)) {
                return false;
            }
            LOG.error("JDBC authorization plugin exception: ", (Throwable)se);
            throw this.toAuthorizationPluginException(se);
        }
    }

    private void grantObjectPrivileges(Role role, SecurableObject object) {
        List<AuthorizationSecurableObject> authObjects = this.mappingProvider.translatePrivilege(object);
        for (AuthorizationSecurableObject authObject : authObjects) {
            ArrayList convertedObjects = Lists.newArrayList();
            if (authObject.name().equals("*")) {
                convertedObjects.addAll(this.convertResourceAll(authObject));
            } else {
                convertedObjects.add(authObject);
            }
            for (AuthorizationSecurableObject convertedObject : convertedObjects) {
                List privileges = this.filterUnsupportedPrivileges(authObject.privileges()).stream().map(AuthorizationPrivilege::getName).collect(Collectors.toList());
                for (String privilege : privileges) {
                    List<String> sqls = this.getGrantPrivilegeSQL(privilege, convertedObject.metadataObjectType().name(), convertedObject.fullName(), role.name());
                    for (String sql : sqls) {
                        this.executeUpdateSQL(sql, "is already granted");
                    }
                }
            }
        }
    }

    private void revokeObjectPrivileges(Role role, SecurableObject removeObject) {
        List<AuthorizationSecurableObject> authObjects = this.mappingProvider.translatePrivilege(removeObject);
        for (AuthorizationSecurableObject authObject : authObjects) {
            ArrayList convertedObjects = Lists.newArrayList();
            if (authObject.name().equals("*")) {
                convertedObjects.addAll(this.convertResourceAll(authObject));
            } else {
                convertedObjects.add(authObject);
            }
            for (AuthorizationSecurableObject convertedObject : convertedObjects) {
                List privileges = this.filterUnsupportedPrivileges(authObject.privileges()).stream().map(AuthorizationPrivilege::getName).collect(Collectors.toList());
                for (String privilege : privileges) {
                    List<String> sqls = this.getRevokePrivilegeSQL(privilege, convertedObject.metadataObjectType().name(), convertedObject.fullName(), role.name());
                    for (String sql : sqls) {
                        this.executeUpdateSQL(sql, "Cannot find privilege Privilege");
                    }
                }
            }
        }
    }
}

