/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.utils;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.gravitino.storage.relational.session.SqlSessions;

public class SessionUtils {
    private SessionUtils() {
    }

    public static <T> void doWithCommit(Class<T> mapperClazz, Consumer<T> consumer) {
        try {
            T mapper = SqlSessions.getMapper(mapperClazz);
            consumer.accept(mapper);
            SqlSessions.commitAndCloseSqlSession();
        }
        catch (Exception e) {
            SqlSessions.rollbackAndCloseSqlSession();
            throw e;
        }
    }

    public static <T, R> R doWithCommitAndFetchResult(Class<T> mapperClazz, Function<T, R> func) {
        try {
            T mapper = SqlSessions.getMapper(mapperClazz);
            R result = func.apply(mapper);
            SqlSessions.commitAndCloseSqlSession();
            return result;
        }
        catch (Exception e) {
            SqlSessions.rollbackAndCloseSqlSession();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R getWithoutCommit(Class<T> mapperClazz, Function<T, R> func) {
        try {
            T mapper = SqlSessions.getMapper(mapperClazz);
            R r = func.apply(mapper);
            return r;
        }
        finally {
            SqlSessions.closeSqlSession();
        }
    }

    public static <T> void doWithoutCommit(Class<T> mapperClazz, Consumer<T> consumer) {
        try {
            T mapper = SqlSessions.getMapper(mapperClazz);
            consumer.accept(mapper);
        }
        finally {
            SqlSessions.closeSqlSession();
        }
    }

    public static void doMultipleWithCommit(Runnable ... operations) {
        SqlSessions.getSqlSession();
        try {
            Arrays.stream(operations).forEach(Runnable::run);
            SqlSessions.commitAndCloseSqlSession();
        }
        catch (Exception e) {
            SqlSessions.rollbackAndCloseSqlSession();
            throw e;
        }
    }
}

