/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.catalog.lakehouse.paimon.PaimonCatalogBackend;
import org.apache.gravitino.catalog.lakehouse.paimon.authentication.AuthenticationConfig;
import org.apache.gravitino.catalog.lakehouse.paimon.authentication.kerberos.KerberosConfig;
import org.apache.gravitino.catalog.lakehouse.paimon.storage.PaimonOSSFileSystemConfig;
import org.apache.gravitino.catalog.lakehouse.paimon.storage.PaimonS3FileSystemConfig;
import org.apache.gravitino.catalog.lakehouse.paimon.utils.CatalogUtils;
import org.apache.gravitino.connector.BaseCatalogPropertiesMetadata;
import org.apache.gravitino.connector.PropertyEntry;

public class PaimonCatalogPropertiesMetadata
extends BaseCatalogPropertiesMetadata {
    @VisibleForTesting
    public static final String GRAVITINO_CATALOG_BACKEND = "catalog-backend";
    public static final String PAIMON_METASTORE = "metastore";
    public static final String WAREHOUSE = "warehouse";
    public static final String URI = "uri";
    public static final String GRAVITINO_JDBC_USER = "jdbc-user";
    public static final String PAIMON_JDBC_USER = "jdbc.user";
    public static final String GRAVITINO_JDBC_PASSWORD = "jdbc-password";
    public static final String PAIMON_JDBC_PASSWORD = "jdbc.password";
    public static final String GRAVITINO_JDBC_DRIVER = "jdbc-driver";
    public static final String S3_ENDPOINT = "s3.endpoint";
    public static final String S3_ACCESS_KEY = "s3.access-key";
    public static final String S3_SECRET_KEY = "s3.secret-key";
    public static final Map<String, String> GRAVITINO_CONFIG_TO_PAIMON = ImmutableMap.of((Object)"catalog-backend", (Object)"metastore", (Object)"warehouse", (Object)"warehouse", (Object)"uri", (Object)"uri", (Object)"jdbc-user", (Object)"jdbc.user", (Object)"jdbc-password", (Object)"jdbc.password", (Object)"jdbc-driver", (Object)"jdbc-driver");
    private static final Map<String, PropertyEntry<?>> PROPERTIES_METADATA;
    public static final Map<String, String> KERBEROS_CONFIGURATION;
    public static final Map<String, String> S3_CONFIGURATION;
    public static final Map<String, String> OSS_CONFIGURATION;

    protected Map<String, PropertyEntry<?>> specificPropertyEntries() {
        return PROPERTIES_METADATA;
    }

    Map<String, String> transformProperties(Map<String, String> properties) {
        return CatalogUtils.toInnerProperty(properties, false);
    }

    static {
        KERBEROS_CONFIGURATION = ImmutableMap.of((Object)"authentication.kerberos.principal", (Object)"authentication.kerberos.principal", (Object)"authentication.kerberos.keytab-uri", (Object)"authentication.kerberos.keytab-uri", (Object)"authentication.kerberos.check-interval-sec", (Object)"authentication.kerberos.check-interval-sec", (Object)"authentication.kerberos.keytab-fetch-timeout-sec", (Object)"authentication.kerberos.keytab-fetch-timeout-sec", (Object)"authentication.type", (Object)"authentication.type");
        S3_CONFIGURATION = ImmutableMap.of((Object)"s3-access-key-id", (Object)S3_ACCESS_KEY, (Object)"s3-secret-access-key", (Object)S3_SECRET_KEY, (Object)"s3-endpoint", (Object)S3_ENDPOINT);
        OSS_CONFIGURATION = ImmutableMap.of((Object)"oss-access-key-id", (Object)"fs.oss.accessKeyId", (Object)"oss-secret-access-key", (Object)"fs.oss.accessKeySecret", (Object)"oss-endpoint", (Object)"fs.oss.endpoint");
        ImmutableList propertyEntries = ImmutableList.of((Object)PropertyEntry.enumPropertyEntry((String)GRAVITINO_CATALOG_BACKEND, (String)"Paimon catalog backend type", (boolean)true, (boolean)true, PaimonCatalogBackend.class, null, (boolean)false, (boolean)false), (Object)PropertyEntry.stringRequiredPropertyEntry((String)WAREHOUSE, (String)"Paimon catalog warehouse config", (boolean)false, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)URI, (String)"Paimon catalog uri config", (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)GRAVITINO_JDBC_USER, (String)"Gravitino Paimon catalog jdbc user", (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)GRAVITINO_JDBC_PASSWORD, (String)"Gravitino Paimon catalog jdbc password", (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)GRAVITINO_JDBC_DRIVER, (String)"The driver of the Jdbc connection", (boolean)false, null, (boolean)false));
        HashMap result = Maps.newHashMap();
        result.putAll(Maps.uniqueIndex((Iterable)propertyEntries, PropertyEntry::getName));
        result.putAll(KerberosConfig.KERBEROS_PROPERTY_ENTRIES);
        result.putAll(AuthenticationConfig.AUTHENTICATION_PROPERTY_ENTRIES);
        result.putAll(PaimonS3FileSystemConfig.S3_FILESYSTEM_PROPERTY_ENTRIES);
        result.putAll(PaimonOSSFileSystemConfig.OSS_FILESYSTEM_PROPERTY_ENTRIES);
        PROPERTIES_METADATA = ImmutableMap.copyOf((Map)result);
    }
}

