/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import org.apache.paimon.shade.okhttp3.ConnectionSpec;
import org.apache.paimon.shade.okhttp3.Dispatcher;
import org.apache.paimon.shade.okhttp3.Headers;
import org.apache.paimon.shade.okhttp3.MediaType;
import org.apache.paimon.shade.okhttp3.OkHttpClient;
import org.apache.paimon.shade.okhttp3.Request;
import org.apache.paimon.shade.okhttp3.RequestBody;
import org.apache.paimon.shade.okhttp3.Response;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.ThreadPoolUtils;

public class SimpleHttpClient
implements Closeable {
    private static final MediaType MEDIA_TYPE = MediaType.parse("application/json");
    private final OkHttpClient client;

    public SimpleHttpClient(String threadName) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().dispatcher(new Dispatcher(ThreadPoolUtils.createCachedThreadPool(1, threadName, new SynchronousQueue<Runnable>()))).retryOnConnectionFailure(true).connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT)).connectTimeout(Duration.ofMinutes(3L)).readTimeout(Duration.ofMinutes(3L));
        this.client = builder.build();
    }

    public String post(String url, byte[] body, Map<String, String> headers) throws IOException {
        RequestBody requestBody = RequestBody.create(body, MEDIA_TYPE);
        Request request = new Request.Builder().url(url).post(requestBody).headers(Headers.of(headers)).build();
        try (Response response = this.client.newCall(request).execute();){
            String responseBodyStr;
            String string = responseBodyStr = response.body() != null ? response.body().string() : null;
            if (!response.isSuccessful() || StringUtils.isNullOrWhitespaceOnly(responseBodyStr)) {
                throw new RuntimeException(response.isSuccessful() ? "ResponseBody is null or empty." : String.format("Response is not successful, response is %s", response));
            }
            String string2 = responseBodyStr;
            return string2;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.client.dispatcher().cancelAll();
            this.client.connectionPool().evictAll();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

