/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;

public class CreateSchema
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String comment;

    public CreateSchema(CommandContext context, String metalake, String catalog, String schema, String comment) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.comment = comment;
    }

    @Override
    public void handle() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            client.loadCatalog(this.catalog).asSchemas().createSchema(this.schema, this.comment, null);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (SchemaAlreadyExistsException err) {
            this.exitWithError("Schema already exists.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.schema + " created");
    }
}

