/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Map;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.ListProperties;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class ListCatalogProperties
extends ListProperties {
    protected final String metalake;
    protected final String catalog;

    public ListCatalogProperties(CommandContext context, String metalake, String catalog) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
    }

    @Override
    public void handle() {
        Catalog gCatalog = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            gCatalog = client.loadCatalog(this.catalog);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        Map<String, String> properties = gCatalog.properties();
        this.printProperties(properties);
    }
}

