/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.HashSet;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.Privileges;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.cli.commands.MetadataCommand;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.dto.authorization.PrivilegeDTO;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchRoleException;

public class RevokePrivilegesFromRole
extends MetadataCommand {
    protected final String metalake;
    protected final String role;
    protected final FullName entity;
    protected final String[] privileges;

    public RevokePrivilegesFromRole(CommandContext context, String metalake, String role, FullName entity, String[] privileges) {
        super(context);
        this.metalake = metalake;
        this.entity = entity;
        this.role = role;
        this.privileges = privileges;
    }

    @Override
    public void handle() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            HashSet<Privilege> privilegesSet = new HashSet<Privilege>();
            for (String privilege : this.privileges) {
                if (!Privileges.isValid(privilege)) {
                    this.exitWithError("Unknown privilege " + privilege);
                }
                PrivilegeDTO privilegeDTO = PrivilegeDTO.builder().withName(Privileges.toName(privilege)).withCondition(Privilege.Condition.DENY).build();
                privilegesSet.add(privilegeDTO);
            }
            MetadataObject metadataObject = this.constructMetadataObject(this.entity, client);
            client.revokePrivilegesFromRole(this.role, metadataObject, privilegesSet);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchRoleException err) {
            this.exitWithError("Unknown role.");
        }
        catch (NoSuchMetadataObjectException err) {
            this.exitWithError("Unknown user.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        String all = String.join((CharSequence)",", this.privileges);
        this.printInformation(this.role + " revoked " + all + " on " + this.entity.getName());
    }

    @Override
    public Command validate() {
        if (this.privileges == null) {
            this.exitWithError("Missing --privilege option.");
        }
        return super.validate();
    }
}

