/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.rel.TableChange;

public class UpdateTableName
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String table;
    protected final String name;

    public UpdateTableName(CommandContext context, String metalake, String catalog, String schema, String table, String name) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.name = name;
    }

    @Override
    public void handle() {
        try {
            NameIdentifier tableName = NameIdentifier.of(this.schema, this.table);
            GravitinoClient client = this.buildClient(this.metalake);
            TableChange change = TableChange.rename(this.name);
            client.loadCatalog(this.catalog).asTableCatalog().alterTable(tableName, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.table + " name changed.");
    }
}

