/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.outputs;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.outputs.LineUtil;

public class Column {
    public static final char ELLIPSIS = '\u2026';
    private final String header;
    private final HorizontalAlign headerAlign;
    private final HorizontalAlign dataAlign;
    private final CommandContext context;
    private int maxWidth;
    private List<String> cellContents;

    public Column(CommandContext context, String header) {
        this(context, header, HorizontalAlign.CENTER, HorizontalAlign.LEFT);
    }

    public Column(CommandContext context, String header, HorizontalAlign headerAlign, HorizontalAlign dataAlign) {
        this.context = context;
        this.header = LineUtil.capitalize(header);
        this.headerAlign = headerAlign;
        this.dataAlign = dataAlign;
        this.cellContents = Lists.newArrayList();
        this.maxWidth = LineUtil.getDisplayWidth(header);
    }

    public String getHeader() {
        return this.header;
    }

    public HorizontalAlign getHeaderAlign() {
        return this.headerAlign;
    }

    public HorizontalAlign getDataAlign() {
        return this.dataAlign;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public CommandContext getContext() {
        return this.context;
    }

    public Column copy() {
        return new Column(this.context, this.header, this.headerAlign, this.dataAlign);
    }

    public Column addCell(String cell) {
        if (cell == null) {
            cell = "null";
        }
        this.maxWidth = Math.max(this.maxWidth, LineUtil.getDisplayWidth(cell));
        this.cellContents.add(cell);
        return this;
    }

    public Column addCell(Object cell) {
        return this.addCell(cell == null ? "null" : cell.toString());
    }

    public Column addCell(char cell) {
        return this.addCell(String.valueOf(cell));
    }

    public Column addCell(int cell) {
        return this.addCell(String.valueOf(cell));
    }

    public Column addCell(double cell) {
        return this.addCell(String.valueOf(cell));
    }

    public Column addCell(boolean cell) {
        return this.addCell(String.valueOf(cell));
    }

    public Column getLimitedColumn(int limit) {
        if (this.cellContents.size() <= limit) {
            return this;
        }
        Column newColumn = this.copy();
        newColumn.cellContents = this.cellContents.subList(0, Math.min(limit, this.cellContents.size()));
        newColumn.reCalculateMaxWidth();
        newColumn.addCell('\u2026');
        return newColumn;
    }

    public String getCell(int index) {
        return this.cellContents.get(index);
    }

    public int getCellCount() {
        return this.cellContents.size();
    }

    private void reCalculateMaxWidth() {
        for (String cell : this.cellContents) {
            this.maxWidth = Math.max(this.maxWidth, LineUtil.getDisplayWidth(cell));
        }
    }

    public static enum HorizontalAlign {
        LEFT,
        CENTER,
        RIGHT;

    }
}

