/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import java.util.List;
import java.util.function.Consumer;
import org.apache.gravitino.client.ErrorHandler;
import org.apache.gravitino.dto.responses.ErrorResponse;
import org.apache.gravitino.dto.responses.OAuth2ErrorResponse;
import org.apache.gravitino.exceptions.AlreadyExistsException;
import org.apache.gravitino.exceptions.BadRequestException;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.CatalogInUseException;
import org.apache.gravitino.exceptions.CatalogNotInUseException;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.ForbiddenException;
import org.apache.gravitino.exceptions.GroupAlreadyExistsException;
import org.apache.gravitino.exceptions.IllegalMetadataObjectException;
import org.apache.gravitino.exceptions.IllegalPrivilegeException;
import org.apache.gravitino.exceptions.IllegalRoleException;
import org.apache.gravitino.exceptions.IllegalStatisticNameException;
import org.apache.gravitino.exceptions.InUseException;
import org.apache.gravitino.exceptions.JobTemplateAlreadyExistsException;
import org.apache.gravitino.exceptions.MetalakeAlreadyExistsException;
import org.apache.gravitino.exceptions.MetalakeInUseException;
import org.apache.gravitino.exceptions.MetalakeNotInUseException;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchJobException;
import org.apache.gravitino.exceptions.NoSuchJobTemplateException;
import org.apache.gravitino.exceptions.NoSuchLocationNameException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchModelVersionURINameException;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.exceptions.NoSuchUserException;
import org.apache.gravitino.exceptions.NonEmptyCatalogException;
import org.apache.gravitino.exceptions.NonEmptyMetalakeException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.NotFoundException;
import org.apache.gravitino.exceptions.NotInUseException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.exceptions.PolicyAlreadyAssociatedException;
import org.apache.gravitino.exceptions.PolicyAlreadyExistsException;
import org.apache.gravitino.exceptions.RESTException;
import org.apache.gravitino.exceptions.RoleAlreadyExistsException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.exceptions.TagAlreadyAssociatedException;
import org.apache.gravitino.exceptions.TagAlreadyExistsException;
import org.apache.gravitino.exceptions.TopicAlreadyExistsException;
import org.apache.gravitino.exceptions.UnauthorizedException;
import org.apache.gravitino.exceptions.UnmodifiableStatisticException;
import org.apache.gravitino.exceptions.UserAlreadyExistsException;

public class ErrorHandlers {
    public static Consumer<ErrorResponse> metalakeErrorHandler() {
        return MetalakeErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> catalogErrorHandler() {
        return CatalogErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> schemaErrorHandler() {
        return SchemaErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> tableErrorHandler() {
        return TableErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> partitionErrorHandler() {
        return PartitionErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> restErrorHandler() {
        return RestErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> oauthErrorHandler() {
        return OAuthErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> filesetErrorHandler() {
        return FilesetErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> topicErrorHandler() {
        return TopicErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> userErrorHandler() {
        return UserErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> groupErrorHandler() {
        return GroupErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> roleErrorHandler() {
        return RoleErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> permissionOperationErrorHandler() {
        return PermissionOperationErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> tagErrorHandler() {
        return TagErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> policyErrorHandler() {
        return PolicyErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> credentialErrorHandler() {
        return CredentialErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> ownerErrorHandler() {
        return OwnerErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> modelErrorHandler() {
        return ModelErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> jobErrorHandler() {
        return JobErrorHandler.INSTANCE;
    }

    public static Consumer<ErrorResponse> statisticsErrorHandler() {
        return StatisticsErrorHandler.INSTANCE;
    }

    private ErrorHandlers() {
    }

    private static String getStackString(List<String> stack) {
        if (stack == null || stack.isEmpty()) {
            return "";
        }
        Joiner eol = Joiner.on("\n");
        return eol.join(stack);
    }

    private static String formatErrorMessage(ErrorResponse errorResponse) {
        String message = errorResponse.getMessage();
        String stack = ErrorHandlers.getStackString(errorResponse.getStack());
        if (stack.isEmpty()) {
            return message;
        }
        return String.format("%s%n%s", message, stack);
    }

    private static class MetalakeErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new MetalakeErrorHandler();

        private MetalakeErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new MetalakeAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1010: {
                    throw new MetalakeInUseException(errorMessage, new Object[0]);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1005: {
                    throw new NonEmptyMetalakeException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class CatalogErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new CatalogErrorHandler();

        private CatalogErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1007: {
                    throw new ConnectionFailedException(errorMessage, new Object[0]);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchCatalogException.class.getSimpleName())) {
                        throw new NoSuchCatalogException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new CatalogAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1010: {
                    if (errorResponse.getType().equals(CatalogInUseException.class.getSimpleName())) {
                        throw new CatalogInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeInUseException.class.getSimpleName())) {
                        throw new MetalakeInUseException(errorMessage, new Object[0]);
                    }
                    throw new InUseException(errorMessage, new Object[0]);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
                case 1005: {
                    throw new NonEmptyCatalogException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class SchemaErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new SchemaErrorHandler();

        private SchemaErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchCatalogException.class.getSimpleName())) {
                        throw new NoSuchCatalogException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new SchemaAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1005: {
                    throw new NonEmptySchemaException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class TableErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new TableErrorHandler();

        private TableErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchTableException.class.getSimpleName())) {
                        throw new NoSuchTableException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new TableAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class PartitionErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new PartitionErrorHandler();

        private PartitionErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchTableException.class.getSimpleName())) {
                        throw new NoSuchTableException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchPartitionException.class.getSimpleName())) {
                        throw new NoSuchPartitionException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new PartitionAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class RestErrorHandler
    extends ErrorHandler {
        private static final ErrorHandler INSTANCE = new RestErrorHandler();

        private RestErrorHandler() {
        }

        @Override
        public ErrorResponse parseResponse(int code, String json, ObjectMapper mapper) {
            try {
                return mapper.readValue(json, ErrorResponse.class);
            }
            catch (Exception e) {
                String errorMsg = String.format("Error code: %d, error message: %s, json string: %s", code, e.getMessage(), json);
                return ErrorResponse.unknownError(errorMsg);
            }
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            if (errorResponse.getCode() == 1008) {
                throw new ForbiddenException("Forbidden error :%s", errorResponse.getMessage());
            }
            throw new RESTException("Unable to process: %s", ErrorHandlers.formatErrorMessage(errorResponse));
        }
    }

    public static class OAuthErrorHandler
    extends RestErrorHandler {
        private static final ErrorHandler INSTANCE = new OAuthErrorHandler();

        @Override
        public ErrorResponse parseResponse(int code, String json, ObjectMapper mapper) {
            try {
                OAuth2ErrorResponse response = mapper.readValue(json, OAuth2ErrorResponse.class);
                return ErrorResponse.oauthError(code, response.getType(), response.getMessage());
            }
            catch (Exception e) {
                String errorMsg = String.format("Error code: %d, error message: %s, json string: %s", code, e.getMessage(), json);
                return ErrorResponse.unknownError(errorMsg);
            }
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            if (errorResponse.getType() != null) {
                switch (errorResponse.getType()) {
                    case "invalid_client": {
                        throw new UnauthorizedException("Not authorized: %s: %s", errorResponse.getType(), errorResponse.getMessage());
                    }
                    case "invalid_request": 
                    case "invalid_grant": 
                    case "unauthorized_client": 
                    case "unsupported_grant_type": 
                    case "invalid_scope": {
                        throw new BadRequestException("Malformed request: %s: %s", errorResponse.getType(), errorResponse.getMessage());
                    }
                }
                super.accept(errorResponse);
            }
            super.accept(errorResponse);
        }
    }

    private static class FilesetErrorHandler
    extends RestErrorHandler {
        private static final FilesetErrorHandler INSTANCE = new FilesetErrorHandler();

        private FilesetErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchCatalogException.class.getSimpleName())) {
                        throw new NoSuchCatalogException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchFilesetException.class.getSimpleName())) {
                        throw new NoSuchFilesetException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchLocationNameException.class.getSimpleName())) {
                        throw new NoSuchLocationNameException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new FilesetAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class TopicErrorHandler
    extends RestErrorHandler {
        private static final TopicErrorHandler INSTANCE = new TopicErrorHandler();

        private TopicErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchTopicException.class.getSimpleName())) {
                        throw new NoSuchTopicException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new TopicAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class UserErrorHandler
    extends RestErrorHandler {
        private static final UserErrorHandler INSTANCE = new UserErrorHandler();

        private UserErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchUserException.class.getSimpleName())) {
                        throw new NoSuchUserException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new UserAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class GroupErrorHandler
    extends RestErrorHandler {
        private static final GroupErrorHandler INSTANCE = new GroupErrorHandler();

        private GroupErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchGroupException.class.getSimpleName())) {
                        throw new NoSuchGroupException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new GroupAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class RoleErrorHandler
    extends RestErrorHandler {
        private static final RoleErrorHandler INSTANCE = new RoleErrorHandler();

        private RoleErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    if (errorResponse.getType().equals(IllegalPrivilegeException.class.getSimpleName())) {
                        throw new IllegalPrivilegeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(IllegalMetadataObjectException.class.getSimpleName())) {
                        throw new IllegalMetadataObjectException(errorMessage, new Object[0]);
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchRoleException.class.getSimpleName())) {
                        throw new NoSuchRoleException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchMetadataObjectException.class.getSimpleName())) {
                        throw new NoSuchMetadataObjectException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    throw new RoleAlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class PermissionOperationErrorHandler
    extends RestErrorHandler {
        private static final PermissionOperationErrorHandler INSTANCE = new PermissionOperationErrorHandler();

        private PermissionOperationErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    if (errorResponse.getType().equals(IllegalPrivilegeException.class.getSimpleName())) {
                        throw new IllegalPrivilegeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(IllegalRoleException.class.getSimpleName())) {
                        throw new IllegalRoleException(errorMessage, new Object[0]);
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchUserException.class.getSimpleName())) {
                        throw new NoSuchUserException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchGroupException.class.getSimpleName())) {
                        throw new NoSuchGroupException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchRoleException.class.getSimpleName())) {
                        throw new NoSuchRoleException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchMetadataObjectException.class.getSimpleName())) {
                        throw new NoSuchMetadataObjectException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class TagErrorHandler
    extends RestErrorHandler {
        private static final TagErrorHandler INSTANCE = new TagErrorHandler();

        private TagErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchTagException.class.getSimpleName())) {
                        throw new NoSuchTagException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    if (errorResponse.getType().equals(TagAlreadyExistsException.class.getSimpleName())) {
                        throw new TagAlreadyExistsException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(TagAlreadyAssociatedException.class.getSimpleName())) {
                        throw new TagAlreadyAssociatedException(errorMessage, new Object[0]);
                    }
                    throw new AlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class PolicyErrorHandler
    extends RestErrorHandler {
        private static final PolicyErrorHandler INSTANCE = new PolicyErrorHandler();

        private PolicyErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchPolicyException.class.getSimpleName())) {
                        throw new NoSuchPolicyException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1004: {
                    if (errorResponse.getType().equals(PolicyAlreadyExistsException.class.getSimpleName())) {
                        throw new PolicyAlreadyExistsException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(PolicyAlreadyAssociatedException.class.getSimpleName())) {
                        throw new PolicyAlreadyAssociatedException(errorMessage, new Object[0]);
                    }
                    throw new AlreadyExistsException(errorMessage, new Object[0]);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class CredentialErrorHandler
    extends RestErrorHandler {
        private static final CredentialErrorHandler INSTANCE = new CredentialErrorHandler();

        private CredentialErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class OwnerErrorHandler
    extends RestErrorHandler {
        private static final OwnerErrorHandler INSTANCE = new OwnerErrorHandler();

        private OwnerErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetadataObjectException.class.getSimpleName())) {
                        throw new NoSuchMetadataObjectException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1006: {
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1009: {
                    throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class ModelErrorHandler
    extends RestErrorHandler {
        private static final ModelErrorHandler INSTANCE = new ModelErrorHandler();

        private ModelErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMsg = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMsg);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMsg, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchModelException.class.getSimpleName())) {
                        throw new NoSuchModelException(errorMsg, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchModelVersionException.class.getSimpleName())) {
                        throw new NoSuchModelVersionException(errorMsg, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchModelVersionURINameException.class.getSimpleName())) {
                        throw new NoSuchModelVersionURINameException(errorMsg, new Object[0]);
                    }
                    throw new NotFoundException(errorMsg, new Object[0]);
                }
                case 1004: {
                    if (errorResponse.getType().equals(ModelAlreadyExistsException.class.getSimpleName())) {
                        throw new ModelAlreadyExistsException(errorMsg, new Object[0]);
                    }
                    if (errorResponse.getType().equals(ModelVersionAliasesAlreadyExistException.class.getSimpleName())) {
                        throw new ModelVersionAliasesAlreadyExistException(errorMsg, new Object[0]);
                    }
                    throw new AlreadyExistsException(errorMsg, new Object[0]);
                }
                case 1008: {
                    throw new ForbiddenException(errorMsg, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMsg);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMsg, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMsg, new Object[0]);
                    }
                    throw new NotInUseException(errorMsg, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class JobErrorHandler
    extends RestErrorHandler {
        private static final JobErrorHandler INSTANCE = new JobErrorHandler();

        private JobErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMsg = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    throw new IllegalArgumentException(errorMsg);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchMetalakeException.class.getSimpleName())) {
                        throw new NoSuchMetalakeException(errorMsg, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchJobTemplateException.class.getSimpleName())) {
                        throw new NoSuchJobTemplateException(errorMsg, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchJobException.class.getSimpleName())) {
                        throw new NoSuchJobException(errorMsg, new Object[0]);
                    }
                    throw new NotFoundException(errorMsg, new Object[0]);
                }
                case 1004: {
                    throw new JobTemplateAlreadyExistsException(errorMsg, new Object[0]);
                }
                case 1008: {
                    throw new ForbiddenException(errorMsg, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMsg);
                }
                case 1009: {
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMsg, new Object[0]);
                    }
                    throw new NotInUseException(errorMsg, new Object[0]);
                }
                case 1010: {
                    throw new InUseException(errorMsg, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }

    private static class StatisticsErrorHandler
    extends RestErrorHandler {
        private static final StatisticsErrorHandler INSTANCE = new StatisticsErrorHandler();

        private StatisticsErrorHandler() {
        }

        @Override
        public void accept(ErrorResponse errorResponse) {
            String errorMessage = ErrorHandlers.formatErrorMessage(errorResponse);
            switch (errorResponse.getCode()) {
                case 1001: {
                    if (errorResponse.getType().equals(IllegalStatisticNameException.class.getSimpleName())) {
                        throw new IllegalStatisticNameException(errorMessage, new Object[0]);
                    }
                    throw new IllegalArgumentException(errorMessage);
                }
                case 1003: {
                    if (errorResponse.getType().equals(NoSuchSchemaException.class.getSimpleName())) {
                        throw new NoSuchSchemaException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchTableException.class.getSimpleName())) {
                        throw new NoSuchTableException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(NoSuchMetadataObjectException.class.getSimpleName())) {
                        throw new NoSuchMetadataObjectException(errorMessage, new Object[0]);
                    }
                    throw new NotFoundException(errorMessage, new Object[0]);
                }
                case 1006: {
                    if (errorResponse.getType().equals(UnmodifiableStatisticException.class.getSimpleName())) {
                        throw new UnmodifiableStatisticException(errorMessage, new Object[0]);
                    }
                    throw new UnsupportedOperationException(errorMessage);
                }
                case 1008: {
                    throw new ForbiddenException(errorMessage, new Object[0]);
                }
                case 1002: {
                    throw new RuntimeException(errorMessage);
                }
                case 1009: {
                    if (errorResponse.getType().equals(CatalogNotInUseException.class.getSimpleName())) {
                        throw new CatalogNotInUseException(errorMessage, new Object[0]);
                    }
                    if (errorResponse.getType().equals(MetalakeNotInUseException.class.getSimpleName())) {
                        throw new MetalakeNotInUseException(errorMessage, new Object[0]);
                    }
                    throw new NotInUseException(errorMessage, new Object[0]);
                }
                case 1010: {
                    throw new InUseException(errorMessage, new Object[0]);
                }
            }
            super.accept(errorResponse);
        }
    }
}

