/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.gravitino.credential.CredentialContext;

public class PathBasedCredentialContext
implements CredentialContext {
    @NotNull
    private final Set<String> writePaths;
    @NotNull
    private final Set<String> readPaths;
    @NotNull
    private final String userName;

    public PathBasedCredentialContext(String userName, Set<String> writePaths, Set<String> readPaths) {
        Preconditions.checkNotNull(userName, "User name should not be null");
        Preconditions.checkNotNull(writePaths, "Write paths should not be null");
        Preconditions.checkNotNull(readPaths, "Read paths should not be null");
        this.userName = userName;
        this.writePaths = writePaths;
        this.readPaths = readPaths;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public Set<String> getWritePaths() {
        return this.writePaths;
    }

    public Set<String> getReadPaths() {
        return this.readPaths;
    }

    public int hashCode() {
        return Objects.hash(this.userName, this.writePaths, this.readPaths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathBasedCredentialContext)) {
            return false;
        }
        PathBasedCredentialContext that = (PathBasedCredentialContext)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.writePaths, that.writePaths) && Objects.equals(this.readPaths, that.readPaths);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("User name: ").append(this.userName).append(", write path: ").append(this.writePaths).append(", read path: ").append(this.readPaths);
        return stringBuilder.toString();
    }
}

