/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.gravitino.dto.policy.PolicyDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class PolicyListResponse
extends BaseResponse {
    @JsonProperty(value="policies")
    private final PolicyDTO[] policies;

    public PolicyListResponse(PolicyDTO[] policies) {
        super(0);
        this.policies = policies;
    }

    public PolicyListResponse() {
        this.policies = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.policies != null, "\"policies\" must not be null");
        Arrays.stream(this.policies).forEach(t2 -> {
            Preconditions.checkArgument(t2 != null, "policy must not be null");
            Preconditions.checkArgument(t2.content() != null, "policy content must not be null");
            t2.content().validate();
        });
    }

    public PolicyDTO[] getPolicies() {
        return this.policies;
    }

    @Override
    public String toString() {
        return "PolicyListResponse(policies=" + Arrays.deepToString(this.getPolicies()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolicyListResponse)) {
            return false;
        }
        PolicyListResponse other = (PolicyListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getPolicies(), other.getPolicies());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PolicyListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getPolicies());
        return result;
    }
}

