/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.job.local;

import java.io.File;
import java.util.Map;
import org.apache.gravitino.job.JobTemplate;
import org.apache.gravitino.job.ShellJobTemplate;
import org.apache.gravitino.job.local.ShellProcessBuilder;

public abstract class LocalProcessBuilder {
    protected final JobTemplate jobTemplate;
    protected final File workingDirectory;

    protected LocalProcessBuilder(JobTemplate jobTemplate, Map<String, String> configs) {
        this.jobTemplate = jobTemplate;
        this.workingDirectory = new File(jobTemplate.executable()).getAbsoluteFile().getParentFile();
    }

    public abstract Process start();

    public static LocalProcessBuilder create(JobTemplate jobTemplate, Map<String, String> configs) {
        if (jobTemplate instanceof ShellJobTemplate) {
            return new ShellProcessBuilder((ShellJobTemplate)jobTemplate, configs);
        }
        throw new IllegalArgumentException("Unsupported job template type: " + String.valueOf(jobTemplate.jobType()));
    }
}

