/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.AuditInfo;

public class SchemaEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The schema's unique identifier");
    public static final Field NAME = Field.required("name", String.class, "The schema's name");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the schema");
    public static final Field COMMENT = Field.optional("comment", String.class, "The comment or description of the schema");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The properties of the schema");
    private Long id;
    private String name;
    private String comment;
    private AuditInfo auditInfo;
    protected Namespace namespace;
    private Map<String, String> properties;

    private SchemaEntity() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(AUDIT_INFO, this.auditInfo);
        fields.put(COMMENT, this.comment);
        fields.put(PROPERTIES, this.properties);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.SCHEMA;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaEntity)) {
            return false;
        }
        SchemaEntity schema = (SchemaEntity)o;
        return Objects.equal((Object)this.id, (Object)schema.id) && Objects.equal((Object)this.name, (Object)schema.name) && Objects.equal((Object)this.namespace, (Object)schema.namespace) && Objects.equal((Object)this.comment, (Object)schema.comment) && Objects.equal(this.properties, schema.properties) && Objects.equal((Object)this.auditInfo, (Object)schema.auditInfo);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.auditInfo, this.comment, this.properties});
    }

    public String toString() {
        return "SchemaEntity(id=" + this.id + ", name=" + this.name + ", comment=" + this.comment + ", auditInfo=" + String.valueOf(this.auditInfo) + ", namespace=" + String.valueOf(this.namespace) + ", properties=" + String.valueOf(this.properties) + ")";
    }

    public static class Builder {
        private final SchemaEntity schema = new SchemaEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.schema.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.schema.name = name;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.schema.namespace = namespace;
            return this;
        }

        public Builder withComment(String comment) {
            this.schema.comment = comment;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.schema.properties = properties;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.schema.auditInfo = auditInfo;
            return this;
        }

        public SchemaEntity build() {
            this.schema.validate();
            return this.schema;
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

