/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.ModelMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.ModelMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.ModelPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class ModelMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, ModelMetaBaseSQLProvider> MODEL_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new ModelMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new ModelMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new ModelMetaPostgreSQLProvider());

    public static ModelMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return MODEL_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String insertModelMeta(@Param(value="modelMeta") ModelPO modelPO) {
        return ModelMetaSQLProviderFactory.getProvider().insertModelMeta(modelPO);
    }

    public static String insertModelMetaOnDuplicateKeyUpdate(@Param(value="modelMeta") ModelPO modelPO) {
        return ModelMetaSQLProviderFactory.getProvider().insertModelMetaOnDuplicateKeyUpdate(modelPO);
    }

    public static String listModelPOsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return ModelMetaSQLProviderFactory.getProvider().listModelPOsBySchemaId(schemaId);
    }

    public static String listModelPOsByModelIds(@Param(value="modelIds") List<Long> modelIds) {
        return ModelMetaSQLProviderFactory.getProvider().listModelPOsByModelIds(modelIds);
    }

    public static String selectModelMetaBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return ModelMetaSQLProviderFactory.getProvider().selectModelMetaBySchemaIdAndModelName(schemaId, modelName);
    }

    public static String selectModelIdBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return ModelMetaSQLProviderFactory.getProvider().selectModelIdBySchemaIdAndModelName(schemaId, modelName);
    }

    public static String selectModelMetaByModelId(@Param(value="modelId") Long modelId) {
        return ModelMetaSQLProviderFactory.getProvider().selectModelMetaByModelId(modelId);
    }

    public static String softDeleteModelMetaBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return ModelMetaSQLProviderFactory.getProvider().softDeleteModelMetaBySchemaIdAndModelName(schemaId, modelName);
    }

    public static String softDeleteModelMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return ModelMetaSQLProviderFactory.getProvider().softDeleteModelMetasByCatalogId(catalogId);
    }

    public static String softDeleteModelMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return ModelMetaSQLProviderFactory.getProvider().softDeleteModelMetasByMetalakeId(metalakeId);
    }

    public static String softDeleteModelMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return ModelMetaSQLProviderFactory.getProvider().softDeleteModelMetasBySchemaId(schemaId);
    }

    public static String deleteModelMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return ModelMetaSQLProviderFactory.getProvider().deleteModelMetasByLegacyTimeline(legacyTimeline, limit);
    }

    public static String updateModelLatestVersion(@Param(value="modelId") Long modelId) {
        return ModelMetaSQLProviderFactory.getProvider().updateModelLatestVersion(modelId);
    }

    public static String updateModelMeta(@Param(value="newModelMeta") ModelPO newModelPO, @Param(value="oldModelMeta") ModelPO oldModelPO) {
        return ModelMetaSQLProviderFactory.getProvider().updateModelMeta(newModelPO, oldModelPO);
    }

    static class ModelMetaMySQLProvider
    extends ModelMetaBaseSQLProvider {
        ModelMetaMySQLProvider() {
        }
    }

    static class ModelMetaH2Provider
    extends ModelMetaBaseSQLProvider {
        ModelMetaH2Provider() {
        }
    }
}

