/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.utils.ArrayUtils;
import java.util.List;
import java.util.Map;

public class SeqContainsKeyFunction
extends AbstractFunction {
    private static final long serialVersionUID = 1543232112837279691L;

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        Object first = arg1.getValue(env);
        if (first == null) {
            return AviatorBoolean.FALSE;
        }
        Class<?> clazz = first.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            Map seq = (Map)first;
            try {
                return AviatorBoolean.valueOf(seq.containsKey(arg2.getValue(env)));
            }
            catch (Exception e) {
                RuntimeUtils.printStackTrace(env, e);
                return AviatorBoolean.FALSE;
            }
        }
        if (clazz.isArray()) {
            int index = FunctionUtils.getNumberValue(arg2, env).intValue();
            return AviatorBoolean.valueOf(index >= 0 && index < ArrayUtils.getLength(first));
        }
        if (List.class.isAssignableFrom(clazz)) {
            int index = FunctionUtils.getNumberValue(arg2, env).intValue();
            return AviatorBoolean.valueOf(index >= 0 && index < ((List)first).size());
        }
        throw new IllegalArgumentException(arg1.desc(env) + " is not a map or array.");
    }

    @Override
    public String getName() {
        return "seq.contains_key";
    }
}

