/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.FSDirDeleteOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirEncryptionZoneOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirMkdirOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirStatAndListingOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.Time;

class FSDirWriteFileOp {
    private FSDirWriteFileOp() {
    }

    static boolean unprotectedRemoveBlock(FSDirectory fsd, String path, INodesInPath iip, INodeFile fileNode, Block block) throws IOException {
        BlockInfo uc = fileNode.removeLastBlock(block);
        if (uc == null) {
            return false;
        }
        if (uc.getUnderConstructionFeature() != null) {
            DatanodeStorageInfo.decrementBlocksScheduled(uc.getUnderConstructionFeature().getExpectedStorageLocations());
        }
        fsd.getBlockManager().removeBlockFromMap(uc);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.removeBlock: " + path + " with " + block + " block is removed from the file system");
        }
        fsd.updateCount(iip, 0L, -fileNode.getPreferredBlockSize(), fileNode.getPreferredBlockReplication(), true);
        return true;
    }

    static void persistBlocks(FSDirectory fsd, String path, INodeFile file, boolean logRetryCache) {
        assert (fsd.getFSNamesystem().hasWriteLock());
        Preconditions.checkArgument((boolean)file.isUnderConstruction());
        fsd.getEditLog().logUpdateBlocks(path, file, logRetryCache);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("persistBlocks: " + path + " with " + file.getBlocks().length + " blocks is persisted to" + " the file system");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void abandonBlock(FSDirectory fsd, FSPermissionChecker pc, ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        INodesInPath iip = fsd.resolvePath(pc, src, fileId);
        src = iip.getPath();
        FSNamesystem fsn = fsd.getFSNamesystem();
        INodeFile file = fsn.checkLease(iip, holder, fileId);
        Preconditions.checkState((boolean)file.isUnderConstruction());
        Block localBlock = ExtendedBlock.getLocalBlock((ExtendedBlock)b);
        fsd.writeLock();
        try {
            if (!FSDirWriteFileOp.unprotectedRemoveBlock(fsd, src, iip, file, localBlock)) {
                return;
            }
        }
        finally {
            fsd.writeUnlock();
        }
        FSDirWriteFileOp.persistBlocks(fsd, src, file, false);
    }

    static void checkBlock(FSNamesystem fsn, ExtendedBlock block) throws IOException {
        String bpId = fsn.getBlockPoolId();
        if (block != null && !bpId.equals(block.getBlockPoolId())) {
            throw new IOException("Unexpected BlockPoolId " + block.getBlockPoolId() + " - expected " + bpId);
        }
    }

    static ValidateAddBlockResult validateAddBlock(FSNamesystem fsn, FSPermissionChecker pc, String src, long fileId, String clientName, ExtendedBlock previous, LocatedBlock[] onRetryBlock) throws IOException {
        INodesInPath iip = fsn.dir.resolvePath(pc, src, fileId);
        FileState fileState = FSDirWriteFileOp.analyzeFileState(fsn, iip, fileId, clientName, previous, onRetryBlock);
        if (onRetryBlock[0] != null && onRetryBlock[0].getLocations().length > 0) {
            return null;
        }
        INodeFile pendingFile = fileState.inode;
        if (!fsn.checkFileProgress(src, pendingFile, false)) {
            throw new NotReplicatedYetException("Not replicated yet: " + src);
        }
        if ((long)pendingFile.getBlocks().length >= fsn.maxBlocksPerFile) {
            throw new IOException("File has reached the limit on maximum number of blocks (dfs.namenode.fs-limits.max-blocks-per-file): " + pendingFile.getBlocks().length + " >= " + fsn.maxBlocksPerFile);
        }
        long blockSize = pendingFile.getPreferredBlockSize();
        String clientMachine = pendingFile.getFileUnderConstructionFeature().getClientMachine();
        short replication = pendingFile.getFileReplication();
        byte storagePolicyID = pendingFile.getStoragePolicyID();
        return new ValidateAddBlockResult(blockSize, replication, storagePolicyID, clientMachine);
    }

    static LocatedBlock makeLocatedBlock(FSNamesystem fsn, Block blk, DatanodeStorageInfo[] locs, long offset) throws IOException {
        LocatedBlock lBlk = BlockManager.newLocatedBlock(fsn.getExtendedBlock(blk), locs, offset, false);
        fsn.getFSDirectory().getBlockManager().setBlockToken(lBlk, BlockTokenIdentifier.AccessMode.WRITE);
        return lBlk;
    }

    static LocatedBlock storeAllocatedBlock(FSNamesystem fsn, String src, long fileId, String clientName, ExtendedBlock previous, DatanodeStorageInfo[] targets) throws IOException {
        LocatedBlock[] onRetryBlock = new LocatedBlock[1];
        INodesInPath iip = fsn.dir.resolvePath(null, src, fileId);
        FileState fileState = FSDirWriteFileOp.analyzeFileState(fsn, iip, fileId, clientName, previous, onRetryBlock);
        INodeFile pendingFile = fileState.inode;
        src = fileState.path;
        if (onRetryBlock[0] != null) {
            if (onRetryBlock[0].getLocations().length > 0) {
                return onRetryBlock[0];
            }
            BlockInfo lastBlockInFile = pendingFile.getLastBlock();
            lastBlockInFile.getUnderConstructionFeature().setExpectedLocations(lastBlockInFile, targets);
            long offset = pendingFile.computeFileSize();
            return FSDirWriteFileOp.makeLocatedBlock(fsn, lastBlockInFile, targets, offset);
        }
        fsn.commitOrCompleteLastBlock(pendingFile, fileState.iip, ExtendedBlock.getLocalBlock((ExtendedBlock)previous));
        Block newBlock = fsn.createNewBlock();
        INodesInPath inodesInPath = INodesInPath.fromINode(pendingFile);
        FSDirWriteFileOp.saveAllocatedBlock(fsn, src, inodesInPath, newBlock, targets);
        FSDirWriteFileOp.persistNewBlock(fsn, src, pendingFile);
        long offset = pendingFile.computeFileSize();
        return FSDirWriteFileOp.makeLocatedBlock(fsn, newBlock, targets, offset);
    }

    static DatanodeStorageInfo[] chooseTargetForNewBlock(BlockManager bm, String src, DatanodeInfo[] excludedNodes, String[] favoredNodes, EnumSet<AddBlockFlag> flags, ValidateAddBlockResult r) throws IOException {
        DatanodeDescriptor clientNode = bm.getDatanodeManager().getDatanodeByHost(r.clientMachine);
        if (clientNode == null) {
            clientNode = FSDirWriteFileOp.getClientNode(bm, r.clientMachine);
        }
        HashSet<Node> excludedNodesSet = null;
        if (excludedNodes != null) {
            excludedNodesSet = new HashSet<Node>(excludedNodes.length);
            Collections.addAll(excludedNodesSet, excludedNodes);
        }
        List<String> favoredNodesList = favoredNodes == null ? null : Arrays.asList(favoredNodes);
        return bm.chooseTarget4NewBlock(src, r.replication, (Node)clientNode, excludedNodesSet, r.blockSize, favoredNodesList, r.storagePolicyID, flags);
    }

    static Node getClientNode(BlockManager bm, String clientMachine) {
        ArrayList<String> hosts = new ArrayList<String>(1);
        hosts.add(clientMachine);
        List<String> rName = bm.getDatanodeManager().resolveNetworkLocation(hosts);
        NodeBase clientNode = null;
        if (rName != null) {
            clientNode = new NodeBase(rName.get(0) + "/" + clientMachine);
        }
        return clientNode;
    }

    static INodesInPath resolvePathForStartFile(FSDirectory dir, FSPermissionChecker pc, String src, EnumSet<CreateFlag> flag, boolean createParent) throws IOException {
        INode inode;
        INodesInPath iip = dir.resolvePath(pc, src, FSDirectory.DirOp.CREATE);
        if (dir.isPermissionEnabled()) {
            dir.checkAncestorAccess(pc, iip, FsAction.WRITE);
        }
        if ((inode = iip.getLastINode()) != null) {
            if (inode.isDirectory()) {
                throw new FileAlreadyExistsException(iip.getPath() + " already exists as a directory");
            }
            INodeFile.valueOf(inode, src);
            if (dir.isPermissionEnabled() && flag.contains(CreateFlag.OVERWRITE)) {
                dir.checkPathAccess(pc, iip, FsAction.WRITE);
            }
        } else {
            if (!createParent) {
                dir.verifyParentDir(iip);
            }
            if (!flag.contains(CreateFlag.CREATE)) {
                throw new FileNotFoundException("Can't overwrite non-existent " + src);
            }
        }
        return iip;
    }

    static HdfsFileStatus startFile(FSNamesystem fsn, INodesInPath iip, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, FileEncryptionInfo feInfo, INode.BlocksMapUpdateInfo toRemoveBlocks, boolean logRetryEntry) throws IOException {
        assert (fsn.hasWriteLock());
        boolean overwrite = flag.contains(CreateFlag.OVERWRITE);
        boolean isLazyPersist = flag.contains(CreateFlag.LAZY_PERSIST);
        String src = iip.getPath();
        FSDirectory fsd = fsn.getFSDirectory();
        if (iip.getLastINode() != null) {
            if (overwrite) {
                ChunkedArrayList toRemoveINodes = new ChunkedArrayList();
                ChunkedArrayList toRemoveUCFiles = new ChunkedArrayList();
                long ret = FSDirDeleteOp.delete(fsd, iip, toRemoveBlocks, (List<INode>)toRemoveINodes, (List<Long>)toRemoveUCFiles, Time.now());
                if (ret >= 0L) {
                    iip = INodesInPath.replace(iip, iip.length() - 1, null);
                    FSDirDeleteOp.incrDeletedFileCount(ret);
                    fsn.removeLeasesAndINodes((List<Long>)toRemoveUCFiles, (List<INode>)toRemoveINodes, true);
                }
            } else {
                fsn.recoverLeaseInternal(FSNamesystem.RecoverLeaseOp.CREATE_FILE, iip, src, holder, clientMachine, false);
                throw new FileAlreadyExistsException(src + " for client " + clientMachine + " already exists");
            }
        }
        fsn.checkFsObjectLimit();
        INodeFile newNode = null;
        INodesInPath parent = FSDirMkdirOp.createAncestorDirectories(fsd, iip, permissions);
        if (parent != null) {
            INodeFile iNodeFile = newNode = (iip = FSDirWriteFileOp.addFile(fsd, parent, iip.getLastLocalName(), permissions, replication, blockSize, holder, clientMachine)) != null ? iip.getLastINode().asFile() : null;
        }
        if (newNode == null) {
            throw new IOException("Unable to add " + src + " to namespace");
        }
        fsn.leaseManager.addLease(newNode.getFileUnderConstructionFeature().getClientName(), newNode.getId());
        if (feInfo != null) {
            FSDirEncryptionZoneOp.setFileEncryptionInfo(fsd, iip, feInfo);
        }
        FSDirWriteFileOp.setNewINodeStoragePolicy(fsd.getBlockManager(), iip, isLazyPersist);
        fsd.getEditLog().logOpenFile(src, newNode, overwrite, logRetryEntry);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.startFile: added " + src + " inode " + newNode.getId() + " " + holder);
        }
        return FSDirStatAndListingOp.getFileInfo(fsd, iip);
    }

    static INodeFile addFileForEditLog(FSDirectory fsd, long id, INodesInPath existing, byte[] localName, PermissionStatus permissions, List<AclEntry> aclEntries, List<XAttr> xAttrs, short replication, long modificationTime, long atime, long preferredBlockSize, boolean underConstruction, String clientName, String clientMachine, byte storagePolicyId) {
        block8: {
            INodeFile newNode;
            assert (fsd.hasWriteLock());
            if (underConstruction) {
                newNode = FSDirWriteFileOp.newINodeFile(id, permissions, modificationTime, modificationTime, replication, preferredBlockSize, storagePolicyId);
                newNode.toUnderConstruction(clientName, clientMachine);
            } else {
                newNode = FSDirWriteFileOp.newINodeFile(id, permissions, modificationTime, atime, replication, preferredBlockSize, storagePolicyId);
            }
            newNode.setLocalName(localName);
            try {
                INodesInPath iip = fsd.addINode(existing, newNode);
                if (iip != null) {
                    if (aclEntries != null) {
                        AclStorage.updateINodeAcl(newNode, aclEntries, 0x7FFFFFFE);
                    }
                    if (xAttrs != null) {
                        XAttrStorage.updateINodeXAttrs(newNode, xAttrs, 0x7FFFFFFE);
                    }
                    return newNode;
                }
            }
            catch (IOException e) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedAddFile: exception when add " + existing.getPath() + " to the file system", (Throwable)e);
                if (!(e instanceof FSLimitException.MaxDirectoryItemsExceededException)) break block8;
                NameNode.stateChangeLog.warn("Please increase dfs.namenode.fs-limits.max-directory-items and make it consistent across all NameNodes.");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlockInfo addBlock(FSDirectory fsd, String path, INodesInPath inodesInPath, Block block, DatanodeStorageInfo[] targets) throws IOException {
        fsd.writeLock();
        try {
            INodeFile fileINode = inodesInPath.getLastINode().asFile();
            Preconditions.checkState((boolean)fileINode.isUnderConstruction());
            fsd.updateCount(inodesInPath, 0L, fileINode.getPreferredBlockSize(), fileINode.getFileReplication(), true);
            BlockInfoContiguous blockInfo = new BlockInfoContiguous(block, fileINode.getFileReplication());
            blockInfo.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, targets);
            fsd.getBlockManager().addBlockCollection(blockInfo, fileINode);
            fileINode.addBlock(blockInfo);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug("DIR* FSDirectory.addBlock: " + path + " with " + block + " block is added to the in-memory " + "file system");
            }
            BlockInfoContiguous blockInfoContiguous = blockInfo;
            return blockInfoContiguous;
        }
        finally {
            fsd.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static INodesInPath addFile(FSDirectory fsd, INodesInPath existing, byte[] localName, PermissionStatus permissions, short replication, long preferredBlockSize, String clientName, String clientMachine) throws IOException {
        INodesInPath newiip;
        long modTime = Time.now();
        INodeFile newNode = FSDirWriteFileOp.newINodeFile(fsd.allocateNewInodeId(), permissions, modTime, modTime, replication, preferredBlockSize);
        newNode.setLocalName(localName);
        newNode.toUnderConstruction(clientName, clientMachine);
        fsd.writeLock();
        try {
            newiip = fsd.addINode(existing, newNode);
        }
        finally {
            fsd.writeUnlock();
        }
        if (newiip == null) {
            NameNode.stateChangeLog.info("DIR* addFile: failed to add " + existing.getPath() + "/" + DFSUtil.bytes2String(localName));
            return null;
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* addFile: " + DFSUtil.bytes2String(localName) + " is added");
        }
        return newiip;
    }

    private static FileState analyzeFileState(FSNamesystem fsn, INodesInPath iip, long fileId, String clientName, ExtendedBlock previous, LocatedBlock[] onRetryBlock) throws IOException {
        assert (fsn.hasReadLock());
        String src = iip.getPath();
        FSDirWriteFileOp.checkBlock(fsn, previous);
        onRetryBlock[0] = null;
        fsn.checkNameNodeSafeMode("Cannot add block to " + src);
        fsn.checkFsObjectLimit();
        Block previousBlock = ExtendedBlock.getLocalBlock((ExtendedBlock)previous);
        INodeFile file = fsn.checkLease(iip, clientName, fileId);
        BlockInfo lastBlockInFile = file.getLastBlock();
        if (!Block.matchingIdAndGenStamp((Block)previousBlock, (Block)lastBlockInFile)) {
            BlockInfo penultimateBlock = file.getPenultimateBlock();
            if (previous == null && lastBlockInFile != null && lastBlockInFile.getNumBytes() >= file.getPreferredBlockSize() && lastBlockInFile.isComplete()) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("BLOCK* NameSystem.allocateBlock: handling block allocation writing to a file with a complete previous block: src=" + src + " lastBlock=" + (Object)((Object)lastBlockInFile));
                }
            } else {
                if (Block.matchingIdAndGenStamp((Block)penultimateBlock, (Block)previousBlock)) {
                    if (lastBlockInFile.getNumBytes() != 0L) {
                        throw new IOException("Request looked like a retry to allocate block " + (Object)((Object)lastBlockInFile) + " but it already contains " + lastBlockInFile.getNumBytes() + " bytes");
                    }
                    NameNode.stateChangeLog.info("BLOCK* allocateBlock: caught retry for allocation of a new block in " + src + ". Returning previously" + " allocated block " + (Object)((Object)lastBlockInFile));
                    long offset = file.computeFileSize();
                    BlockUnderConstructionFeature uc = lastBlockInFile.getUnderConstructionFeature();
                    onRetryBlock[0] = FSDirWriteFileOp.makeLocatedBlock(fsn, lastBlockInFile, uc.getExpectedStorageLocations(), offset);
                    return new FileState(file, src, iip);
                }
                throw new IOException("Cannot allocate block in " + src + ": " + "passed 'previous' block " + previous + " does not match actual " + "last block in file " + (Object)((Object)lastBlockInFile));
            }
        }
        return new FileState(file, src, iip);
    }

    static boolean completeFile(FSNamesystem fsn, FSPermissionChecker pc, String srcArg, String holder, ExtendedBlock last, long fileId) throws IOException {
        String src = srcArg;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.completeFile: " + src + " for " + holder);
        }
        FSDirWriteFileOp.checkBlock(fsn, last);
        INodesInPath iip = fsn.dir.resolvePath(pc, src, fileId);
        boolean success = FSDirWriteFileOp.completeFileInternal(fsn, iip, holder, ExtendedBlock.getLocalBlock((ExtendedBlock)last), fileId);
        if (success) {
            NameNode.stateChangeLog.info("DIR* completeFile: " + srcArg + " is closed by " + holder);
        }
        return success;
    }

    private static boolean completeFileInternal(FSNamesystem fsn, INodesInPath iip, String holder, Block last, long fileId) throws IOException {
        INodeFile pendingFile;
        assert (fsn.hasWriteLock());
        String src = iip.getPath();
        INode inode = null;
        try {
            inode = iip.getLastINode();
            pendingFile = fsn.checkLease(iip, holder, fileId);
        }
        catch (LeaseExpiredException lee) {
            BlockInfo realLastBlock;
            if (inode != null && inode.isFile() && !inode.asFile().isUnderConstruction() && Block.matchingIdAndGenStamp((Block)last, (Block)(realLastBlock = inode.asFile().getLastBlock()))) {
                NameNode.stateChangeLog.info("DIR* completeFile: request from " + holder + " to complete inode " + fileId + "(" + src + ") which is already closed. But, it appears to be " + "an RPC retry. Returning success");
                return true;
            }
            throw lee;
        }
        if (!fsn.checkFileProgress(src, pendingFile, false)) {
            return false;
        }
        fsn.commitOrCompleteLastBlock(pendingFile, iip, last);
        if (!fsn.checkFileProgress(src, pendingFile, true)) {
            return false;
        }
        fsn.addCommittedBlocksToPending(pendingFile);
        fsn.finalizeINodeFileUnderConstruction(src, pendingFile, 0x7FFFFFFE, true);
        return true;
    }

    private static INodeFile newINodeFile(long id, PermissionStatus permissions, long mtime, long atime, short replication, long preferredBlockSize, byte storagePolicyId) {
        return new INodeFile(id, null, permissions, mtime, atime, BlockInfo.EMPTY_ARRAY, replication, preferredBlockSize, storagePolicyId);
    }

    private static INodeFile newINodeFile(long id, PermissionStatus permissions, long mtime, long atime, short replication, long preferredBlockSize) {
        return FSDirWriteFileOp.newINodeFile(id, permissions, mtime, atime, replication, preferredBlockSize, (byte)0);
    }

    private static void persistNewBlock(FSNamesystem fsn, String path, INodeFile file) {
        Preconditions.checkArgument((boolean)file.isUnderConstruction());
        fsn.getEditLog().logAddBlock(path, file);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("persistNewBlock: " + path + " with new block " + file.getLastBlock().toString() + ", current total block count is " + file.getBlocks().length);
        }
    }

    static void saveAllocatedBlock(FSNamesystem fsn, String src, INodesInPath inodesInPath, Block newBlock, DatanodeStorageInfo[] targets) throws IOException {
        assert (fsn.hasWriteLock());
        BlockInfo b = FSDirWriteFileOp.addBlock(fsn.dir, src, inodesInPath, newBlock, targets);
        FSDirWriteFileOp.logAllocatedBlock(src, b);
        DatanodeStorageInfo.incrementBlocksScheduled(targets);
    }

    private static void logAllocatedBlock(String src, BlockInfo b) {
        if (!NameNode.stateChangeLog.isInfoEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder(150);
        sb.append("BLOCK* allocate ");
        b.appendStringTo(sb);
        sb.append(", ");
        BlockUnderConstructionFeature uc = b.getUnderConstructionFeature();
        if (uc != null) {
            uc.appendUCPartsConcise(sb);
        }
        sb.append(" for " + src);
        NameNode.stateChangeLog.info(sb.toString());
    }

    private static void setNewINodeStoragePolicy(BlockManager bm, INodesInPath iip, boolean isLazyPersist) throws IOException {
        INodeFile inode = iip.getLastINode().asFile();
        if (isLazyPersist) {
            BlockStoragePolicy lpPolicy = bm.getStoragePolicy("LAZY_PERSIST");
            if (lpPolicy == null) {
                throw new HadoopIllegalArgumentException("The LAZY_PERSIST storage policy has been disabled by the administrator.");
            }
            inode.setStoragePolicyID(lpPolicy.getId(), iip.getLatestSnapshotId());
        } else {
            BlockStoragePolicy effectivePolicy = bm.getStoragePolicy(inode.getStoragePolicyID());
            if (effectivePolicy != null && effectivePolicy.isCopyOnCreateFile()) {
                inode.setStoragePolicyID(effectivePolicy.getId(), iip.getLatestSnapshotId());
            }
        }
    }

    static class ValidateAddBlockResult {
        final long blockSize;
        final int replication;
        final byte storagePolicyID;
        final String clientMachine;

        ValidateAddBlockResult(long blockSize, int replication, byte storagePolicyID, String clientMachine) {
            this.blockSize = blockSize;
            this.replication = replication;
            this.storagePolicyID = storagePolicyID;
            this.clientMachine = clientMachine;
        }
    }

    private static class FileState {
        final INodeFile inode;
        final String path;
        final INodesInPath iip;

        FileState(INodeFile inode, String fullPath, INodesInPath iip) {
            this.inode = inode;
            this.path = fullPath;
            this.iip = iip;
        }
    }
}

