/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.gcs.fs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemProvider;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.gravitino.catalog.hadoop.fs.SupportsCredentialVending;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.GCSTokenCredential;
import org.apache.gravitino.gcs.fs.GCSCredentialsProvider;
import org.apache.gravitino.gcs.fs.GCSUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class GCSFileSystemProvider
implements FileSystemProvider,
SupportsCredentialVending {
    private static final String GCS_SERVICE_ACCOUNT_JSON_FILE = "fs.gs.auth.service.account.json.keyfile";
    private static final String GCS_TOKEN_PROVIDER_IMPL = "fs.gs.auth.access.token.provider.impl";
    @VisibleForTesting
    public static final Map<String, String> GRAVITINO_KEY_TO_GCS_HADOOP_KEY = ImmutableMap.of((Object)"gcs-service-account-file", (Object)"fs.gs.auth.service.account.json.keyfile");

    public FileSystem getFileSystem(Path path, Map<String, String> config) throws IOException {
        Map<String, String> hadoopConfMap = FileSystemUtils.toHadoopConfigMap(config, GRAVITINO_KEY_TO_GCS_HADOOP_KEY);
        hadoopConfMap = this.additionalGCSConfig(hadoopConfMap);
        Configuration configuration = FileSystemUtils.createConfiguration(hadoopConfMap);
        return FileSystem.newInstance((URI)path.toUri(), (Configuration)configuration);
    }

    public Map<String, String> getFileSystemCredentialConf(Credential[] credentials) {
        Credential credential = GCSUtils.getGCSTokenCredential(credentials);
        HashMap result = Maps.newHashMap();
        if (credential instanceof GCSTokenCredential) {
            result.put(GCS_TOKEN_PROVIDER_IMPL, GCSCredentialsProvider.class.getName());
        }
        return result;
    }

    public String scheme() {
        return "gs";
    }

    public String name() {
        return "gcs";
    }

    private Map<String, String> additionalGCSConfig(Map<String, String> configs) {
        HashMap additionalConfigs = Maps.newHashMap(configs);
        if (!configs.containsKey("fs.gs.http.connect-timeout")) {
            additionalConfigs.put("fs.gs.http.connect-timeout", "5000");
        }
        if (!configs.containsKey("fs.gs.http.max.retry")) {
            additionalConfigs.put("fs.gs.http.max.retry", "2");
        }
        return ImmutableMap.copyOf((Map)additionalConfigs);
    }
}

