/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.postgresql.operation;

import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.catalog.jdbc.JdbcSchema;
import org.apache.gravitino.catalog.jdbc.config.JdbcConfig;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.catalog.jdbc.operation.JdbcDatabaseOperations;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.meta.AuditInfo;

public class PostgreSqlSchemaOperations
extends JdbcDatabaseOperations {
    private String database;

    public void initialize(DataSource dataSource, JdbcExceptionConverter exceptionMapper, Map<String, String> conf) {
        super.initialize(dataSource, exceptionMapper, conf);
        this.database = new JdbcConfig(conf).getJdbcDatabase();
    }

    public JdbcSchema load(String schema) throws NoSuchSchemaException {
        JdbcSchema jdbcSchema;
        block9: {
            Connection connection = this.getConnection();
            try {
                if (!this.schemaExists(connection, schema)) {
                    throw new NoSuchSchemaException("No such schema: %s", new Object[]{schema});
                }
                String comment = this.getSchemaComment(schema, connection);
                jdbcSchema = (JdbcSchema)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)JdbcSchema.builder().withName(schema)).withComment(comment)).withAuditInfo(AuditInfo.EMPTY)).withProperties(Collections.emptyMap())).build();
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.exceptionMapper.toGravitinoException(e);
                }
            }
            connection.close();
        }
        return jdbcSchema;
    }

    public List<String> listDatabases() {
        ArrayList<String> result = new ArrayList<String>();
        try (Connection connection = this.getConnection();
             ResultSet resultSet = this.getSchema(connection, null);){
            while (resultSet.next()) {
                String schemaName = resultSet.getString(1);
                if (this.isSystemDatabase(schemaName)) continue;
                result.add(resultSet.getString(1));
            }
        }
        catch (SQLException se) {
            throw this.exceptionMapper.toGravitinoException(se);
        }
        return result;
    }

    public String generateCreateDatabaseSql(String schema, String comment, Map<String, String> properties) {
        if (MapUtils.isNotEmpty(properties)) {
            throw new UnsupportedOperationException("PostgreSQL does not support properties on database create.");
        }
        StringBuilder sqlBuilder = new StringBuilder("CREATE SCHEMA \"" + schema + "\";");
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            sqlBuilder.append("COMMENT ON SCHEMA ").append("\"").append(schema).append("\"").append(" IS '").append(comment).append("'");
        }
        return sqlBuilder.toString();
    }

    private ResultSet getSchema(Connection connection, String schemaName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getSchemas(this.database, schemaName);
    }

    public String generateDropDatabaseSql(String schema, boolean cascade) {
        StringBuilder sqlBuilder = new StringBuilder(String.format("DROP SCHEMA %s%s%s", "\"", schema, "\""));
        if (cascade) {
            sqlBuilder.append(" CASCADE");
        }
        return sqlBuilder.toString();
    }

    protected Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setCatalog(this.database);
        return connection;
    }

    protected String generateDatabaseExistSql(String databaseName) {
        return String.format("SELECT n.datname FROM pg_catalog.pg_database n where n.datname='%s'", databaseName);
    }

    protected boolean supportSchemaComment() {
        return true;
    }

    protected Set<String> createSysDatabaseNameSet() {
        return ImmutableSet.of((Object)"pg_toast", (Object)"pg_catalog", (Object)"information_schema");
    }

    public boolean schemaExists(Connection connection, String schema) throws SQLException {
        try (ResultSet resultSet = this.getSchema(connection, schema);){
            while (resultSet.next()) {
                if (!Objects.equals(resultSet.getString(1), schema)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private String getShowSchemaCommentSql(String schema) {
        return String.format("SELECT obj_description(n.oid, 'pg_namespace') AS comment\nFROM pg_catalog.pg_namespace n\nWHERE n.nspname = '%s';\n", schema);
    }

    private String getSchemaComment(String schema, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getShowSchemaCommentSql(schema));
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                String string = resultSet.getString("comment");
                return string;
            }
        }
        return null;
    }
}

