/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace;

import com.google.common.collect.ImmutableMap;
import com.lancedb.lance.namespace.Configurable;
import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.util.DynConstructors;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;

public class LanceNamespaces {
    public static final Map<String, String> NATIVE_IMPLEMENTATIONS = ImmutableMap.builder().put((Object)"dir", (Object)"com.lancedb.lance.namespace.dir.DirectoryNamespace").put((Object)"rest", (Object)"com.lancedb.lance.namespace.rest.RestNamespace").put((Object)"hive2", (Object)"com.lancedb.lance.namespace.hive2.Hive2Namespace").put((Object)"hive3", (Object)"com.lancedb.lance.namespace.hive3.Hive3Namespace").put((Object)"glue", (Object)"com.lancedb.lance.namespace.glue.GlueNamespace").build();

    private LanceNamespaces() {
    }

    public static LanceNamespace connect(String impl, Map<String, String> properties, Object conf, BufferAllocator allocator) {
        LanceNamespace ns;
        String resolvedImpl = NATIVE_IMPLEMENTATIONS.getOrDefault(impl, impl);
        try {
            ns = (LanceNamespace)DynConstructors.builder(LanceNamespace.class).impl(resolvedImpl, new Class[0]).buildChecked().newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Failed to construct namespace, impl: %s", impl), e);
        }
        if (ns instanceof Configurable && conf != null) {
            ((Configurable)((Object)ns)).setConf(conf);
        }
        ns.initialize(properties, allocator);
        return ns;
    }
}

