/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.web.Log4jWebLifeCycle;
import org.apache.logging.log4j.web.WebLoggerContextUtils;

public class Log4jServletContextListener
implements ServletContextListener {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ServletContext servletContext;
    private Log4jWebLifeCycle initializer;

    public void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        LOGGER.debug("Log4jServletContextListener ensuring that Log4j starts up properly.");
        this.initializer = WebLoggerContextUtils.getWebLifeCycle(this.servletContext);
        try {
            this.initializer.start();
            this.initializer.setLoggerContext();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Failed to initialize Log4j properly.", e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.servletContext == null || this.initializer == null) {
            LOGGER.warn("Context destroyed before it was initialized.");
            return;
        }
        LOGGER.debug("Log4jServletContextListener ensuring that Log4j shuts down properly.");
        this.initializer.clearLoggerContext();
        this.initializer.stop();
    }
}

