/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AllowPartialScanResultCache;
import org.apache.hadoop.hbase.client.BatchScanResultCache;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.CompleteScanResultCache;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.ShortCircuitMasterConnection;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ConnectionUtils {
    private static final Log LOG = LogFactory.getLog(ConnectionUtils.class);
    static final NonceGenerator NO_NONCE_GENERATOR = new NonceGenerator(){

        @Override
        public long newNonce() {
            return 0L;
        }

        @Override
        public long getNonceGroup() {
            return 0L;
        }
    };
    static final byte[] MAX_BYTE_ARRAY = Bytes.createMaxByteArray((int)9);
    static final long SLEEP_DELTA_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final String MY_ADDRESS = ConnectionUtils.getMyAddress();

    private ConnectionUtils() {
    }

    public static long getPauseTime(long pause, int tries) {
        int ntries = tries;
        if (ntries >= HConstants.RETRY_BACKOFF.length) {
            ntries = HConstants.RETRY_BACKOFF.length - 1;
        }
        if (ntries < 0) {
            ntries = 0;
        }
        long normalPause = pause * (long)HConstants.RETRY_BACKOFF[ntries];
        long jitter = (long)((float)normalPause * ThreadLocalRandom.current().nextFloat() * 0.01f);
        return normalPause + jitter;
    }

    public static NonceGenerator injectNonceGeneratorForTesting(ClusterConnection conn, NonceGenerator cnm) {
        return ConnectionImplementation.injectNonceGeneratorForTesting(conn, cnm);
    }

    public static void setServerSideHConnectionRetriesConfig(Configuration c, String sn, Log log) {
        int hcRetries = c.getInt("hbase.client.retries.number", 35);
        int serversideMultiplier = c.getInt("hbase.client.serverside.retries.multiplier", 10);
        int retries = hcRetries * serversideMultiplier;
        c.setInt("hbase.client.retries.number", retries);
        log.info((Object)(sn + " server-side Connection retries=" + retries));
    }

    public static ClusterConnection createShortCircuitConnection(Configuration conf, ExecutorService pool, User user, ServerName serverName, AdminProtos.AdminService.BlockingInterface admin, ClientProtos.ClientService.BlockingInterface client) throws IOException {
        if (user == null) {
            user = UserProvider.instantiate((Configuration)conf).getCurrent();
        }
        return new ShortCircuitingClusterConnection(conf, pool, user, serverName, admin, client);
    }

    @VisibleForTesting
    public static void setupMasterlessConnection(Configuration conf) {
        conf.set("hbase.client.connection.impl", MasterlessConnection.class.getName());
    }

    static int retries2Attempts(int retries) {
        return Math.max(1, retries == Integer.MAX_VALUE ? Integer.MAX_VALUE : retries + 1);
    }

    static String getStubKey(String serviceName, ServerName serverName, boolean hostnameCanChange) {
        String hostname = serverName.getHostname();
        int port = serverName.getPort();
        if (hostnameCanChange) {
            try {
                InetAddress ip = InetAddress.getByName(hostname);
                return serviceName + "@" + hostname + "-" + ip.getHostAddress() + ":" + port;
            }
            catch (UnknownHostException e) {
                LOG.warn((Object)("Can not resolve " + hostname + ", please check your network"), (Throwable)e);
            }
        }
        return serviceName + "@" + hostname + ":" + port;
    }

    static void checkHasFamilies(Mutation mutation) {
        Preconditions.checkArgument((mutation.numFamilies() > 0 ? 1 : 0) != 0, (String)"Invalid arguments to %s, zero columns specified", (Object)mutation.toString());
    }

    static byte[] createClosestRowAfter(byte[] row) {
        return Arrays.copyOf(row, row.length + 1);
    }

    static byte[] createCloseRowBefore(byte[] row) {
        if (row.length == 0) {
            return MAX_BYTE_ARRAY;
        }
        if (row[row.length - 1] == 0) {
            return Arrays.copyOf(row, row.length - 1);
        }
        byte[] nextRow = new byte[row.length + MAX_BYTE_ARRAY.length];
        System.arraycopy(row, 0, nextRow, 0, row.length - 1);
        nextRow[row.length - 1] = (byte)((row[row.length - 1] & 0xFF) - 1);
        System.arraycopy(MAX_BYTE_ARRAY, 0, nextRow, row.length, MAX_BYTE_ARRAY.length);
        return nextRow;
    }

    static boolean isEmptyStartRow(byte[] row) {
        return Bytes.equals((byte[])row, (byte[])HConstants.EMPTY_START_ROW);
    }

    static boolean isEmptyStopRow(byte[] row) {
        return Bytes.equals((byte[])row, (byte[])HConstants.EMPTY_END_ROW);
    }

    static void resetController(HBaseRpcController controller, long timeoutNs) {
        controller.reset();
        if (timeoutNs >= 0L) {
            controller.setCallTimeout((int)Math.min(Integer.MAX_VALUE, TimeUnit.NANOSECONDS.toMillis(timeoutNs)));
        }
    }

    static Throwable translateException(Throwable t) {
        if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof ServiceException && t.getCause() != null) {
            t = ConnectionUtils.translateException(t.getCause());
        }
        return t;
    }

    static long calcEstimatedSize(Result rs) {
        long estimatedHeapSizeOfResult = 0L;
        for (Cell cell : rs.rawCells()) {
            estimatedHeapSizeOfResult += PrivateCellUtil.estimatedHeapSizeOf((Cell)cell);
        }
        return estimatedHeapSizeOfResult;
    }

    static Result filterCells(Result result, Cell keepCellsAfter) {
        if (keepCellsAfter == null) {
            return result;
        }
        if (!PrivateCellUtil.matchingRows((Cell)keepCellsAfter, (byte[])result.getRow(), (int)0, (int)result.getRow().length)) {
            return result;
        }
        Cell[] rawCells = result.rawCells();
        int index = Arrays.binarySearch(rawCells, keepCellsAfter, (arg_0, arg_1) -> ((CellComparatorImpl)CellComparatorImpl.COMPARATOR).compareWithoutRow(arg_0, arg_1));
        index = index < 0 ? -index - 1 : ++index;
        if (index == 0) {
            return result;
        }
        if (index == rawCells.length) {
            return null;
        }
        return Result.create(Arrays.copyOfRange(rawCells, index, rawCells.length), null, result.isStale(), result.mayHaveMoreCellsInRow());
    }

    static Get toCheckExistenceOnly(Get get) {
        if (get.isCheckExistenceOnly()) {
            return get;
        }
        return ((Get)ReflectionUtils.newInstance(get.getClass(), (Object[])new Object[]{get})).setCheckExistenceOnly(true);
    }

    static List<Get> toCheckExistenceOnly(List<Get> gets) {
        return gets.stream().map(ConnectionUtils::toCheckExistenceOnly).collect(Collectors.toList());
    }

    static RegionLocateType getLocateType(Scan scan) {
        if (scan.isReversed()) {
            if (ConnectionUtils.isEmptyStartRow(scan.getStartRow())) {
                return RegionLocateType.BEFORE;
            }
            return scan.includeStartRow() ? RegionLocateType.CURRENT : RegionLocateType.BEFORE;
        }
        return scan.includeStartRow() ? RegionLocateType.CURRENT : RegionLocateType.AFTER;
    }

    static boolean noMoreResultsForScan(Scan scan, HRegionInfo info) {
        if (ConnectionUtils.isEmptyStopRow(info.getEndKey())) {
            return true;
        }
        if (ConnectionUtils.isEmptyStopRow(scan.getStopRow())) {
            return false;
        }
        int c = Bytes.compareTo((byte[])info.getEndKey(), (byte[])scan.getStopRow());
        return c > 0 || c == 0 && !scan.includeStopRow();
    }

    static boolean noMoreResultsForReverseScan(Scan scan, HRegionInfo info) {
        if (ConnectionUtils.isEmptyStartRow(info.getStartKey())) {
            return true;
        }
        if (ConnectionUtils.isEmptyStopRow(scan.getStopRow())) {
            return false;
        }
        return Bytes.compareTo((byte[])info.getStartKey(), (byte[])scan.getStopRow()) <= 0;
    }

    static <T> CompletableFuture<List<T>> allOf(List<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(f -> f.getNow(null)).collect(Collectors.toList()));
    }

    public static ScanResultCache createScanResultCache(Scan scan) {
        if (scan.getAllowPartialResults()) {
            return new AllowPartialScanResultCache();
        }
        if (scan.getBatch() > 0) {
            return new BatchScanResultCache(scan.getBatch());
        }
        return new CompleteScanResultCache();
    }

    private static String getMyAddress() {
        try {
            return DNS.getDefaultHost((String)"default", (String)"default");
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)"cannot determine my address", (Throwable)uhe);
            return null;
        }
    }

    static boolean isRemote(String host) {
        return !host.equalsIgnoreCase(MY_ADDRESS);
    }

    static void incRPCCallsMetrics(ScanMetrics scanMetrics, boolean isRegionServerRemote) {
        if (scanMetrics == null) {
            return;
        }
        scanMetrics.countOfRPCcalls.incrementAndGet();
        if (isRegionServerRemote) {
            scanMetrics.countOfRemoteRPCcalls.incrementAndGet();
        }
    }

    static void incRPCRetriesMetrics(ScanMetrics scanMetrics, boolean isRegionServerRemote) {
        if (scanMetrics == null) {
            return;
        }
        scanMetrics.countOfRPCRetries.incrementAndGet();
        if (isRegionServerRemote) {
            scanMetrics.countOfRemoteRPCRetries.incrementAndGet();
        }
    }

    static void updateResultsMetrics(ScanMetrics scanMetrics, Result[] rrs, boolean isRegionServerRemote) {
        if (scanMetrics == null || rrs == null || rrs.length == 0) {
            return;
        }
        long resultSize = 0L;
        for (Result rr : rrs) {
            for (Cell cell : rr.rawCells()) {
                resultSize += (long)PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
        }
        scanMetrics.countOfBytesInResults.addAndGet(resultSize);
        if (isRegionServerRemote) {
            scanMetrics.countOfBytesInRemoteResults.addAndGet(resultSize);
        }
    }

    static void updateServerSideMetrics(ScanMetrics scanMetrics, ClientProtos.ScanResponse response) {
        if (scanMetrics == null || response == null || !response.hasScanMetrics()) {
            return;
        }
        ResponseConverter.getScanMetrics(response).forEach(scanMetrics::addToCounter);
    }

    static void incRegionCountMetrics(ScanMetrics scanMetrics) {
        if (scanMetrics == null) {
            return;
        }
        scanMetrics.countOfRegions.incrementAndGet();
    }

    static class MasterlessConnection
    extends ConnectionImplementation {
        MasterlessConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
            super(conf, pool, user);
        }

        @Override
        public boolean isTableDisabled(TableName tableName) throws IOException {
            return false;
        }
    }

    @VisibleForTesting
    public static class ShortCircuitingClusterConnection
    extends ConnectionImplementation {
        private final ServerName serverName;
        private final AdminProtos.AdminService.BlockingInterface localHostAdmin;
        private final ClientProtos.ClientService.BlockingInterface localHostClient;

        private ShortCircuitingClusterConnection(Configuration conf, ExecutorService pool, User user, ServerName serverName, AdminProtos.AdminService.BlockingInterface admin, ClientProtos.ClientService.BlockingInterface client) throws IOException {
            super(conf, pool, user);
            this.serverName = serverName;
            this.localHostAdmin = admin;
            this.localHostClient = client;
        }

        @Override
        public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName sn) throws IOException {
            return this.serverName.equals((Object)sn) ? this.localHostAdmin : super.getAdmin(sn);
        }

        @Override
        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            return this.serverName.equals((Object)sn) ? this.localHostClient : super.getClient(sn);
        }

        @Override
        public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
            if (this.localHostClient instanceof MasterProtos.MasterService.BlockingInterface) {
                return new ShortCircuitMasterConnection((MasterProtos.MasterService.BlockingInterface)this.localHostClient);
            }
            return super.getKeepAliveMasterService();
        }
    }
}

