/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.rest.auth.AuthProvider;
import org.apache.paimon.rest.auth.DLFAuthSignature;
import org.apache.paimon.rest.auth.DLFToken;
import org.apache.paimon.rest.auth.DLFTokenLoader;
import org.apache.paimon.rest.auth.RESTAuthParameter;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLFAuthProvider
implements AuthProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DLFAuthProvider.class);
    public static final String DLF_AUTHORIZATION_HEADER_KEY = "Authorization";
    public static final String DLF_CONTENT_MD5_HEADER_KEY = "Content-MD5";
    public static final String DLF_CONTENT_TYPE_KEY = "Content-Type";
    public static final String DLF_DATE_HEADER_KEY = "x-dlf-date";
    public static final String DLF_SECURITY_TOKEN_HEADER_KEY = "x-dlf-security-token";
    public static final String DLF_AUTH_VERSION_HEADER_KEY = "x-dlf-version";
    public static final String DLF_CONTENT_SHA56_HEADER_KEY = "x-dlf-content-sha256";
    public static final String DLF_CONTENT_SHA56_VALUE = "UNSIGNED-PAYLOAD";
    public static final DateTimeFormatter AUTH_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
    protected static final String MEDIA_TYPE = "application/json";
    @Nullable
    private final DLFTokenLoader tokenLoader;
    @Nullable
    protected DLFToken token;
    private final String region;

    public static DLFAuthProvider fromTokenLoader(DLFTokenLoader tokenLoader, String region) {
        return new DLFAuthProvider(tokenLoader, null, region);
    }

    public static DLFAuthProvider fromAccessKey(String accessKeyId, String accessKeySecret, String securityToken, String region) {
        DLFToken token = new DLFToken(accessKeyId, accessKeySecret, securityToken, null);
        return new DLFAuthProvider(null, token, region);
    }

    public DLFAuthProvider(@Nullable DLFTokenLoader tokenLoader, @Nullable DLFToken token, String region) {
        this.tokenLoader = tokenLoader;
        this.token = token;
        this.region = region;
    }

    @Override
    public Map<String, String> mergeAuthHeader(Map<String, String> baseHeader, RESTAuthParameter restAuthParameter) {
        DLFToken token = this.getFreshToken();
        try {
            String dateTime = baseHeader.getOrDefault(DLF_DATE_HEADER_KEY.toLowerCase(), ZonedDateTime.now(ZoneOffset.UTC).format(AUTH_DATE_TIME_FORMATTER));
            String date = dateTime.substring(0, 8);
            Map<String, String> signHeaders = DLFAuthProvider.generateSignHeaders(restAuthParameter.data(), dateTime, token.getSecurityToken());
            String authorization = DLFAuthSignature.getAuthorization(restAuthParameter, token, this.region, signHeaders, dateTime, date);
            HashMap<String, String> headersWithAuth = new HashMap<String, String>(baseHeader);
            headersWithAuth.putAll(signHeaders);
            headersWithAuth.put(DLF_AUTHORIZATION_HEADER_KEY, authorization);
            return headersWithAuth;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    DLFToken getFreshToken() {
        if (this.shouldRefresh()) {
            DLFAuthProvider dLFAuthProvider = this;
            synchronized (dLFAuthProvider) {
                if (this.shouldRefresh()) {
                    this.refreshToken();
                }
            }
        }
        return this.token;
    }

    private void refreshToken() {
        Preconditions.checkNotNull(this.tokenLoader);
        LOG.info("begin refresh meta token for loader [{}]", (Object)this.tokenLoader.description());
        this.token = this.tokenLoader.loadToken();
        Preconditions.checkNotNull(this.token);
        LOG.info("end refresh meta token for loader [{}] expiresAtMillis [{}]", (Object)this.tokenLoader.description(), (Object)this.token.getExpirationAtMills());
    }

    private boolean shouldRefresh() {
        if (this.token == null) {
            return true;
        }
        Long expireTime = this.token.getExpirationAtMills();
        if (expireTime == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        return expireTime - now < 3600000L;
    }

    public static Map<String, String> generateSignHeaders(String data, String dateTime, String securityToken) throws Exception {
        HashMap<String, String> signHeaders = new HashMap<String, String>();
        signHeaders.put(DLF_DATE_HEADER_KEY, dateTime);
        signHeaders.put(DLF_CONTENT_SHA56_HEADER_KEY, DLF_CONTENT_SHA56_VALUE);
        signHeaders.put(DLF_AUTH_VERSION_HEADER_KEY, "v1");
        if (data != null && !data.isEmpty()) {
            signHeaders.put(DLF_CONTENT_TYPE_KEY, MEDIA_TYPE);
            signHeaders.put(DLF_CONTENT_MD5_HEADER_KEY, DLFAuthSignature.md5(data));
        }
        if (securityToken != null) {
            signHeaders.put(DLF_SECURITY_TOKEN_HEADER_KEY, securityToken);
        }
        return signHeaders;
    }
}

