/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.paimon.rest.auth.DLFToken;
import org.apache.paimon.rest.auth.RESTAuthParameter;
import org.apache.paimon.shade.guava30.com.google.common.base.Joiner;
import org.apache.paimon.utils.StringUtils;

public class DLFAuthSignature {
    public static final String VERSION = "v1";
    private static final String SIGNATURE_ALGORITHM = "DLF4-HMAC-SHA256";
    private static final String PRODUCT = "DlfNext";
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String REQUEST_TYPE = "aliyun_v4_request";
    private static final String SIGNATURE_KEY = "Signature";
    private static final String NEW_LINE = "\n";
    private static final List<String> SIGNED_HEADERS = Arrays.asList("Content-MD5".toLowerCase(), "Content-Type".toLowerCase(), "x-dlf-content-sha256".toLowerCase(), "x-dlf-date".toLowerCase(), "x-dlf-version".toLowerCase(), "x-dlf-security-token".toLowerCase());

    public static String getAuthorization(RESTAuthParameter restAuthParameter, DLFToken dlfToken, String region, Map<String, String> headers, String dateTime, String date) throws Exception {
        String canonicalRequest = DLFAuthSignature.getCanonicalRequest(restAuthParameter, headers);
        String stringToSign = Joiner.on(NEW_LINE).join(SIGNATURE_ALGORITHM, dateTime, String.format("%s/%s/%s/%s", date, region, PRODUCT, REQUEST_TYPE), DLFAuthSignature.sha256Hex(canonicalRequest));
        byte[] dateKey = DLFAuthSignature.hmacSha256(("aliyun_v4" + dlfToken.getAccessKeySecret()).getBytes(), date);
        byte[] dateRegionKey = DLFAuthSignature.hmacSha256(dateKey, region);
        byte[] dateRegionServiceKey = DLFAuthSignature.hmacSha256(dateRegionKey, PRODUCT);
        byte[] signingKey = DLFAuthSignature.hmacSha256(dateRegionServiceKey, REQUEST_TYPE);
        byte[] result = DLFAuthSignature.hmacSha256(signingKey, stringToSign);
        String signature = DLFAuthSignature.hexEncode(result);
        return Joiner.on(",").join(String.format("%s Credential=%s/%s/%s/%s/%s", SIGNATURE_ALGORITHM, dlfToken.getAccessKeyId(), date, region, PRODUCT, REQUEST_TYPE), String.format("%s=%s", SIGNATURE_KEY, signature), new Object[0]);
    }

    public static String md5(String raw) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(raw.getBytes(StandardCharsets.UTF_8));
        byte[] md5 = messageDigest.digest();
        return Base64.getEncoder().encodeToString(md5);
    }

    private static byte[] hmacSha256(byte[] key, String data) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, HMAC_SHA256);
            Mac mac = Mac.getInstance(HMAC_SHA256);
            mac.init(secretKeySpec);
            return mac.doFinal(data.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate HMAC-SHA256", e);
        }
    }

    public static String getCanonicalRequest(RESTAuthParameter restAuthParameter, Map<String, String> headers) {
        String canonicalRequest = Joiner.on(NEW_LINE).join(restAuthParameter.method(), restAuthParameter.resourcePath(), new Object[0]);
        TreeMap<String, String> orderMap = new TreeMap<String, String>();
        if (restAuthParameter.parameters() != null) {
            orderMap.putAll(restAuthParameter.parameters());
        }
        String separator = "";
        StringBuilder canonicalPart = new StringBuilder();
        for (Map.Entry entry : orderMap.entrySet()) {
            canonicalPart.append(separator).append(StringUtils.trim((String)entry.getKey()));
            if (entry.getValue() != null && !((String)entry.getValue()).isEmpty()) {
                canonicalPart.append("=").append(StringUtils.trim((String)entry.getValue()));
            }
            separator = "&";
        }
        canonicalRequest = Joiner.on(NEW_LINE).join(canonicalRequest, canonicalPart, new Object[0]);
        TreeMap<String, String> sortedSignedHeadersMap = DLFAuthSignature.buildSortedSignedHeadersMap(headers);
        for (Map.Entry<String, String> entry : sortedSignedHeadersMap.entrySet()) {
            canonicalRequest = Joiner.on(NEW_LINE).join(canonicalRequest, String.format("%s:%s", entry.getKey(), entry.getValue()), new Object[0]);
        }
        String string = headers.getOrDefault("x-dlf-content-sha256", "UNSIGNED-PAYLOAD");
        return Joiner.on(NEW_LINE).join(canonicalRequest, string, new Object[0]);
    }

    private static TreeMap<String, String> buildSortedSignedHeadersMap(Map<String, String> headers) {
        TreeMap<String, String> orderMap = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                String key = header.getKey().toLowerCase();
                if (!SIGNED_HEADERS.contains(key)) continue;
                orderMap.put(key, StringUtils.trim(header.getValue()));
            }
        }
        return orderMap;
    }

    private static String sha256Hex(String raw) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(raw.getBytes(StandardCharsets.UTF_8));
        return DLFAuthSignature.hexEncode(hash);
    }

    private static String hexEncode(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : raw) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }
}

