/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.CastElementGetter;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;

public class CastedArray
implements InternalArray {
    private final CastElementGetter castElementGetter;
    private InternalArray array;

    protected CastedArray(CastElementGetter castElementGetter) {
        this.castElementGetter = castElementGetter;
    }

    public static CastedArray from(CastElementGetter castElementGetter) {
        return new CastedArray(castElementGetter);
    }

    public CastedArray replaceArray(InternalArray array) {
        this.array = array;
        return this;
    }

    @Override
    public int size() {
        return this.array.size();
    }

    @Override
    public boolean[] toBooleanArray() {
        boolean[] result = new boolean[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Boolean)this.castElementGetter.getElementOrNull(this.array, i);
        }
        return result;
    }

    @Override
    public byte[] toByteArray() {
        byte[] result = new byte[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Byte)this.castElementGetter.getElementOrNull(this.array, i);
        }
        return result;
    }

    @Override
    public short[] toShortArray() {
        short[] result = new short[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Short)this.castElementGetter.getElementOrNull(this.array, i);
        }
        return result;
    }

    @Override
    public int[] toIntArray() {
        int[] result = new int[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)this.castElementGetter.getElementOrNull(this.array, i);
        }
        return result;
    }

    @Override
    public long[] toLongArray() {
        long[] result = new long[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Long)this.castElementGetter.getElementOrNull(this.array, i);
        }
        return result;
    }

    @Override
    public float[] toFloatArray() {
        float[] result = new float[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Float)this.castElementGetter.getElementOrNull(this.array, i)).floatValue();
        }
        return result;
    }

    @Override
    public double[] toDoubleArray() {
        double[] result = new double[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Double)this.castElementGetter.getElementOrNull(this.array, i);
        }
        return result;
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.castElementGetter.getElementOrNull(this.array, pos) == null;
    }

    @Override
    public boolean getBoolean(int pos) {
        return (Boolean)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public byte getByte(int pos) {
        return (Byte)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public short getShort(int pos) {
        return (Short)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public int getInt(int pos) {
        return (Integer)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public long getLong(int pos) {
        return (Long)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public float getFloat(int pos) {
        return ((Float)this.castElementGetter.getElementOrNull(this.array, pos)).floatValue();
    }

    @Override
    public double getDouble(int pos) {
        return (Double)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public BinaryString getString(int pos) {
        return (BinaryString)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return (Decimal)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return (Timestamp)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public byte[] getBinary(int pos) {
        return (byte[])this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public Variant getVariant(int pos) {
        return (Variant)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public InternalArray getArray(int pos) {
        return (InternalArray)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public InternalMap getMap(int pos) {
        return (InternalMap)this.castElementGetter.getElementOrNull(this.array, pos);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return (InternalRow)this.castElementGetter.getElementOrNull(this.array, pos);
    }
}

