/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;

@Public
public interface InternalArray
extends DataGetters {
    public int size();

    public boolean[] toBooleanArray();

    public byte[] toByteArray();

    public short[] toShortArray();

    public int[] toIntArray();

    public long[] toLongArray();

    public float[] toFloatArray();

    public double[] toDoubleArray();

    public static ElementGetter createElementGetter(DataType elementType) {
        ElementGetter elementGetter;
        switch (elementType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                elementGetter = DataGetters::getString;
                break;
            }
            case BOOLEAN: {
                elementGetter = DataGetters::getBoolean;
                break;
            }
            case BINARY: 
            case VARBINARY: {
                elementGetter = DataGetters::getBinary;
                break;
            }
            case DECIMAL: {
                int decimalPrecision = DataTypeChecks.getPrecision((DataType)elementType);
                int decimalScale = DataTypeChecks.getScale((DataType)elementType);
                elementGetter = (array, pos) -> array.getDecimal(pos, decimalPrecision, decimalScale);
                break;
            }
            case TINYINT: {
                elementGetter = DataGetters::getByte;
                break;
            }
            case SMALLINT: {
                elementGetter = DataGetters::getShort;
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                elementGetter = DataGetters::getInt;
                break;
            }
            case BIGINT: {
                elementGetter = DataGetters::getLong;
                break;
            }
            case FLOAT: {
                elementGetter = DataGetters::getFloat;
                break;
            }
            case DOUBLE: {
                elementGetter = DataGetters::getDouble;
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = DataTypeChecks.getPrecision((DataType)elementType);
                elementGetter = (array, pos) -> array.getTimestamp(pos, timestampPrecision);
                break;
            }
            case ARRAY: {
                elementGetter = DataGetters::getArray;
                break;
            }
            case MULTISET: 
            case MAP: {
                elementGetter = DataGetters::getMap;
                break;
            }
            case ROW: {
                int rowFieldCount = DataTypeChecks.getFieldCount((DataType)elementType);
                elementGetter = (array, pos) -> array.getRow(pos, rowFieldCount);
                break;
            }
            case VARIANT: {
                elementGetter = DataGetters::getVariant;
                break;
            }
            default: {
                String msg = String.format("type %s not support in %s", elementType.getTypeRoot().toString(), InternalArray.class.getName());
                throw new IllegalArgumentException(msg);
            }
        }
        if (!elementType.isNullable()) {
            return elementGetter;
        }
        return (array, pos) -> {
            if (array.isNullAt(pos)) {
                return null;
            }
            return elementGetter.getElementOrNull(array, pos);
        };
    }

    public static interface ElementGetter
    extends Serializable {
        @Nullable
        public Object getElementOrNull(InternalArray var1, int var2);
    }
}

