/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.common.config;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.Config;
import org.apache.gravitino.OverwriteDefaultConfig;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public class LanceConfig
extends Config
implements OverwriteDefaultConfig {
    public static final String LANCE_CONFIG_PREFIX = "gravitino.lance-rest.";
    public static final String CONFIG_NAMESPACE_BACKEND = "namespace-backend";
    public static final String CONFIG_METALAKE = "metalake";
    public static final String CONFIG_URI = "uri";
    public static final int DEFAULT_LANCE_REST_SERVICE_HTTP_PORT = 9101;
    public static final int DEFAULT_LANCE_REST_SERVICE_HTTPS_PORT = 9533;
    public static final String GRAVITINO_NAMESPACE_BACKEND = "gravitino";
    public static final String GRAVITINO_URI = "http://localhost:8090";
    public static final ConfigEntry<String> NAMESPACE_BACKEND = new ConfigBuilder("namespace-backend").doc("The backend implementation for namespace operations").version("1.1.0").stringConf().createWithDefault((Object)"gravitino");
    public static final ConfigEntry<String> METALAKE_NAME = new ConfigBuilder("gravitino-metalake").doc("The Metalake name for Lance Gravitino namespace backend").version("1.1.0").stringConf().create();
    public static final ConfigEntry<String> NAMESPACE_BACKEND_URI = new ConfigBuilder("gravitino-uri").doc("The URI of the namespace backend, e.g., Gravitino server URI").version("1.1.0").stringConf().createWithDefault((Object)"http://localhost:8090");

    public LanceConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, key -> true);
    }

    public LanceConfig() {
        super(false);
    }

    public String getNamespaceBackend() {
        return (String)this.get(NAMESPACE_BACKEND);
    }

    public String getNamespaceBackendUri() {
        return (String)this.get(NAMESPACE_BACKEND_URI);
    }

    public String getGravitinoMetalake() {
        return (String)this.get(METALAKE_NAME);
    }

    public Map<String, String> getOverwriteDefaultConfig() {
        return ImmutableMap.of((Object)"httpPort", (Object)String.valueOf(9101), (Object)"httpsPort", (Object)String.valueOf(9533));
    }
}

