/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.CharObjectPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.CharObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.factory.BiMaps;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.CharObjectMaps;
import org.eclipse.collections.api.factory.primitive.ObjectCharMaps;
import org.eclipse.collections.api.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.api.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.primitive.CharObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.CharObjectPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Functions0;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.factory.PrimitiveFunctions;
import org.eclipse.collections.impl.block.factory.Procedures2;
import org.eclipse.collections.impl.block.procedure.BiMapCollectProcedure;
import org.eclipse.collections.impl.block.procedure.MapCollectProcedure;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableCharKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableCharMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableCharKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedCharObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableCharObjectMap;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.partition.bag.PartitionHashBag;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public class CharObjectHashMap<V>
implements MutableCharObjectMap<V>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private char[] keys;
    private V[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues<V> sentinelValues;
    private boolean copyKeysOnWrite = false;

    public CharObjectHashMap() {
        this.allocateTable(16);
    }

    public CharObjectHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity << 1));
        this.allocateTable(capacity);
    }

    public CharObjectHashMap(CharObjectMap<? extends V> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static <V> CharObjectHashMap<V> newMap() {
        return new CharObjectHashMap<V>();
    }

    public static <V> CharObjectHashMap<V> newMap(CharObjectMap<? extends V> map) {
        return new CharObjectHashMap<V>(map);
    }

    public static <V> CharObjectHashMap<V> newWithKeysValues(char key, V value) {
        return new CharObjectHashMap<V>(1).withKeyValue(key, (Object)value);
    }

    public static <V> CharObjectHashMap<V> newWithKeysValues(char key1, V value1, char key2, V value2) {
        return new CharObjectHashMap<V>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <V> CharObjectHashMap<V> newWithKeysValues(char key1, V value1, char key2, V value2, char key3, V value3) {
        return new CharObjectHashMap<V>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <V> CharObjectHashMap<V> newWithKeysValues(char key1, V value1, char key2, V value2, char key3, V value3, char key4, V value4) {
        return new CharObjectHashMap<V>(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharObjectMap)) {
            return false;
        }
        CharObjectMap other = (CharObjectMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (!(!this.sentinelValues.containsZeroKey || other.containsKey('\u0000') && CharObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).zeroValue, other.get('\u0000')))) {
                return false;
            }
            if (!(!this.sentinelValues.containsOneKey || other.containsKey('\u0001') && CharObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).oneValue, other.get('\u0001')))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharObjectHashMap.isNonSentinel(key) || other.containsKey(key) && CharObjectHashMap.nullSafeEquals(this.values[i], other.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (((SentinelValues)this.sentinelValues).zeroValue == null ? 0 : ((SentinelValues)this.sentinelValues).zeroValue.hashCode());
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (((SentinelValues)this.sentinelValues).oneValue == null ? 0 : ((SentinelValues)this.sentinelValues).oneValue.hashCode());
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (this.values[i] == null ? 0 : this.values[i].hashCode());
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append('\u0000').append("=").append(((SentinelValues)this.sentinelValues).zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append('\u0001').append("=").append(((SentinelValues)this.sentinelValues).oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharObjectHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(((SentinelValues)this.sentinelValues).oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                char key = this.keys[i];
                if (!CharObjectHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<V> iterator() {
        return new InternalIterator();
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result[index++] = this.values[i];
        }
        return result;
    }

    public <T> T[] toArray(T[] a) {
        int size = this.size();
        Object[] result = a.length < size ? (Object[])Array.newInstance(a.getClass().getComponentType(), size) : a;
        this.forEachWithIndex((ObjectIntProcedure & Serializable)(each, index) -> {
            result[index] = each;
        });
        if (result.length > size) {
            result[size] = null;
        }
        return result;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        for (Object item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<?> source) {
        return this.containsAllIterable(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        for (Object item : elements) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public CharObjectHashMap<V> tap(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
        return this;
    }

    public void each(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).zeroValue, index++);
            }
            if (this.sentinelValues.containsOneKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).oneValue, index++);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            objectIntProcedure.value(this.values[i], index++);
        }
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i], parameter);
        }
    }

    public void forEachValue(Procedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000');
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(CharObjectProcedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000', ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001', ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public CharObjectHashMap<V> select(CharObjectPredicate<? super V> predicate) {
        CharObjectHashMap<Object> result = CharObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept('\u0000', ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put('\u0000', ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept('\u0001', ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put('\u0001', ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public CharObjectHashMap<V> reject(CharObjectPredicate<? super V> predicate) {
        CharObjectHashMap<Object> result = CharObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept('\u0000', ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put('\u0000', ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept('\u0001', ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put('\u0001', ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public MutableBag<V> select(Predicate<? super V> predicate) {
        HashBag result = new HashBag();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    public <P> MutableBag<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    public MutableBag<V> reject(Predicate<? super V> predicate) {
        HashBag result = new HashBag();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    public <P> MutableBag<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    public PartitionMutableBag<V> partition(Predicate<? super V> predicate) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach(new PartitionProcedure<V>(predicate, partitionMutableBag));
        return partitionMutableBag;
    }

    public <P> PartitionMutableBag<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach(new PartitionProcedure<V>(Predicates.bind(predicate, parameter), partitionMutableBag));
        return partitionMutableBag;
    }

    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        MutableBag result = Bags.mutable.withInitialCapacity(this.size());
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    public <VV> MutableBag<VV> collect(Function<? super V, ? extends VV> function) {
        return this.collect(function, new HashBag());
    }

    public MutableBooleanBag collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return (MutableBooleanBag)this.collectBoolean(booleanFunction, (MutableBooleanCollection)new BooleanHashBag());
    }

    public MutableByteBag collectByte(ByteFunction<? super V> byteFunction) {
        return (MutableByteBag)this.collectByte(byteFunction, (MutableByteCollection)new ByteHashBag());
    }

    public MutableCharBag collectChar(CharFunction<? super V> charFunction) {
        return (MutableCharBag)this.collectChar(charFunction, (MutableCharCollection)new CharHashBag());
    }

    public MutableDoubleBag collectDouble(DoubleFunction<? super V> doubleFunction) {
        return (MutableDoubleBag)this.collectDouble(doubleFunction, (MutableDoubleCollection)new DoubleHashBag());
    }

    public MutableFloatBag collectFloat(FloatFunction<? super V> floatFunction) {
        return (MutableFloatBag)this.collectFloat(floatFunction, (MutableFloatCollection)new FloatHashBag());
    }

    public MutableIntBag collectInt(IntFunction<? super V> intFunction) {
        return (MutableIntBag)this.collectInt(intFunction, (MutableIntCollection)new IntHashBag());
    }

    public MutableLongBag collectLong(LongFunction<? super V> longFunction) {
        return (MutableLongBag)this.collectLong(longFunction, (MutableLongCollection)new LongHashBag());
    }

    public MutableShortBag collectShort(ShortFunction<? super V> shortFunction) {
        return (MutableShortBag)this.collectShort(shortFunction, (MutableShortCollection)new ShortHashBag());
    }

    public <P, VV> MutableBag<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.collect(Functions.bind(function, parameter));
    }

    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                targetCollection.add((Object)function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter));
            }
            if (this.sentinelValues.containsOneKey) {
                targetCollection.add((Object)function.value(((SentinelValues)this.sentinelValues).oneValue, parameter));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            targetCollection.add((Object)function.value(this.values[i], parameter));
        }
        return targetCollection;
    }

    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.add((Object)function.valueOf(this.values[i]));
        }
        return target;
    }

    public <VV> MutableBag<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return this.collectIf(predicate, function, HashBag.newBag());
    }

    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add((Object)function.valueOf(this.values[i]));
        }
        return target;
    }

    public <VV> MutableBag<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return this.flatCollect(function, new HashBag());
    }

    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                Iterate.addAllTo((Iterable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), target);
            }
            if (this.sentinelValues.containsOneKey) {
                Iterate.addAllTo((Iterable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue), target);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            Iterate.addAllTo((Iterable)function.valueOf(this.values[i]), target);
        }
        return target;
    }

    public V detect(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return this.values[i];
        }
        return null;
    }

    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        return Optional.ofNullable(this.detect(predicate));
    }

    public <P> Optional<V> detectWithOptional(Predicate2<? super V, ? super P> predicate, P parameter) {
        return Optional.ofNullable(this.detectWith(predicate, parameter));
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return (V)function.value();
    }

    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return this.values[i];
        }
        return (V)function.value();
    }

    public int count(Predicate<? super V> predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i], parameter)) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return !this.anySatisfy(predicate);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return !this.anySatisfyWith(predicate, parameter);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.value(result, this.values[i]);
        }
        return result;
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        int result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.intValueOf(result, this.values[i]);
        }
        return result;
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        long result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.longValueOf(result, this.values[i]);
        }
        return result;
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        float result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.floatValueOf(result, this.values[i]);
        }
        return result;
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        double result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.doubleValueOf(result, this.values[i]);
        }
        return result;
    }

    @Deprecated
    public <S> MutableBag<Pair<V, S>> zip(Iterable<S> that) {
        if (that instanceof Collection || that instanceof RichIterable) {
            int thatSize = Iterate.sizeOf(that);
            HashBag target = HashBag.newBag(Math.min(this.size(), thatSize));
            return this.zip(that, target);
        }
        return this.zip(that, HashBag.newBag());
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex((Collection)((Object)UnifiedSet.newSet(this.size())));
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return IterableIterate.zipWithIndex(this, target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.of();
        if (this.notEmpty()) {
            Iterator<V> iterator = this.iterator();
            while (iterator.hasNext()) {
                MutableList batch = Lists.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch);
            }
        }
        return result;
    }

    public <K, VV> MutableMap<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<V, K, VV>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public <VV> MutableBagMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.groupBy(function, HashBagMultimap.newMultimap());
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.put(function.valueOf(this.values[i]), this.values[i]);
        }
        return target;
    }

    public <VV> MutableBagMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.groupByEach(function, HashBagMultimap.newMultimap());
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        if (this.sentinelValues != null) {
            Iterable iterable;
            if (this.sentinelValues.containsZeroKey) {
                iterable = (Iterable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
                for (Object key : iterable) {
                    target.put(key, ((SentinelValues)this.sentinelValues).zeroValue);
                }
            }
            if (this.sentinelValues.containsOneKey) {
                iterable = (Iterable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                for (Object key : iterable) {
                    target.put(key, ((SentinelValues)this.sentinelValues).oneValue);
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            Iterable iterable = (Iterable)function.valueOf(this.values[i]);
            for (Object key : iterable) {
                target.put(key, this.values[i]);
            }
        }
        return target;
    }

    public <VV> MutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap(this.size()));
    }

    public <VV, R extends MutableMapIterable<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && target.put(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), ((SentinelValues)this.sentinelValues).zeroValue) != null) {
                throw new IllegalStateException("Key " + function.valueOf(((SentinelValues)this.sentinelValues).zeroValue) + " already exists in map!");
            }
            if (this.sentinelValues.containsOneKey && target.put(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), ((SentinelValues)this.sentinelValues).oneValue) != null) {
                throw new IllegalStateException("Key " + function.valueOf(((SentinelValues)this.sentinelValues).oneValue) + " already exists in map!");
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || target.put(function.valueOf(this.values[i]), this.values[i]) == null) continue;
            throw new IllegalStateException("Key " + function.valueOf(this.values[i]) + " already exists in map!");
        }
        return target;
    }

    public V getFirst() {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public V getLast() {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            if (this.sentinelValues.containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
        }
        return null;
    }

    public V getOnly() {
        if (this.size() != 1) {
            throw new IllegalStateException("Size must be 1 but was " + this.size());
        }
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public MutableList<V> toList() {
        MutableList list = Lists.mutable.of();
        this.forEachWith(Procedures2.addToCollection(), list);
        return list;
    }

    public <R extends Collection<V>> R into(R target) {
        return Iterate.addAllTo(this, target);
    }

    public MutableSet<V> toSet() {
        UnifiedSet set = UnifiedSet.newSet();
        this.forEachWith(Procedures2.addToCollection(), set);
        return set;
    }

    public MutableSortedSet<V> toSortedSet() {
        TreeSortedSet set = TreeSortedSet.newSet();
        this.forEachWith(Procedures2.addToCollection(), set);
        return set;
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        TreeSortedSet<? super V> set = TreeSortedSet.newSet(comparator);
        this.forEachWith(Procedures2.addToCollection(), set);
        return set;
    }

    public MutableBag<V> toBag() {
        MutableBag bag = Bags.mutable.of();
        this.forEachWith(Procedures2.addToCollection(), bag);
        return bag;
    }

    public MutableSortedBag<V> toSortedBag() {
        TreeBag sortedBag = TreeBag.newBag();
        this.forEachWith(Procedures2.addToCollection(), sortedBag);
        return sortedBag;
    }

    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        TreeBag<? super V> sortedBag = TreeBag.newBag(comparator);
        this.forEachWith(Procedures2.addToCollection(), sortedBag);
        return sortedBag;
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MapCollectProcedure<V, NK, NV>(map, keyFunction, valueFunction));
        return map;
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.toSortedMap((Comparator<? super NK>)Comparators.naturalOrder(), keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        TreeSortedMap sortedMap = TreeSortedMap.newMap(comparator);
        this.forEach(new MapCollectProcedure<V, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    public <NK, NV> MutableBiMap<NK, NV> toBiMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        MutableBiMap biMap = BiMaps.mutable.empty();
        this.forEach(new BiMapCollectProcedure<V, NK, NV>(biMap, keyFunction, valueFunction));
        return biMap;
    }

    public LazyIterable<V> asLazy() {
        return LazyIterate.adapt(this);
    }

    public V min(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min = null;
        boolean isMinSet = false;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                min = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
            }
            if (this.sentinelValues.containsOneKey && (!isMinSet || comparator.compare(min, ((SentinelValues)this.sentinelValues).oneValue) > 0)) {
                min = ((SentinelValues)this.sentinelValues).oneValue;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || isMinSet && comparator.compare(min, this.values[i]) <= 0) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return (V)min;
    }

    public V max(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max = null;
        boolean isMaxSet = false;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                max = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
            }
            if (this.sentinelValues.containsOneKey && (!isMaxSet || comparator.compare(max, ((SentinelValues)this.sentinelValues).oneValue) < 0)) {
                max = ((SentinelValues)this.sentinelValues).oneValue;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || isMaxSet && comparator.compare(max, this.values[i]) >= 0) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return (V)max;
    }

    public V min() {
        return (V)this.min((Comparator<? super V>)Comparators.naturalOrder());
    }

    public V max() {
        return (V)this.max((Comparator<? super V>)Comparators.naturalOrder());
    }

    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max = null;
        boolean isMaxSet = false;
        Comparable maxValue = null;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                max = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
                maxValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMaxSet || nextValue.compareTo(maxValue) > 0) {
                    max = ((SentinelValues)this.sentinelValues).oneValue;
                    isMaxSet = true;
                    maxValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMaxSet && nextValue.compareTo(maxValue) <= 0) continue;
            max = next;
            isMaxSet = true;
            maxValue = nextValue;
        }
        return (V)max;
    }

    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min = null;
        boolean isMinSet = false;
        Comparable minValue = null;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                min = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
                minValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMinSet || nextValue.compareTo(minValue) < 0) {
                    min = ((SentinelValues)this.sentinelValues).oneValue;
                    isMinSet = true;
                    minValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMinSet && nextValue.compareTo(minValue) >= 0) continue;
            min = next;
            isMinSet = true;
            minValue = nextValue;
        }
        return (V)min;
    }

    public long sumOfInt(IntFunction<? super V> function) {
        long sum = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                sum += (long)function.intValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                sum += (long)function.intValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += (long)function.intValueOf(this.values[i]);
        }
        return sum;
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        double sum = 0.0;
        double compensation = 0.0;
        if (this.sentinelValues != null) {
            double nextSum;
            double adjustedValue;
            if (this.sentinelValues.containsZeroKey) {
                adjustedValue = (double)function.floatValueOf(((SentinelValues)this.sentinelValues).zeroValue) - compensation;
                nextSum = sum + adjustedValue;
                compensation = nextSum - sum - adjustedValue;
                sum = nextSum;
            }
            if (this.sentinelValues.containsOneKey) {
                adjustedValue = (double)function.floatValueOf(((SentinelValues)this.sentinelValues).oneValue) - compensation;
                nextSum = sum + adjustedValue;
                compensation = nextSum - sum - adjustedValue;
                sum = nextSum;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = (double)function.floatValueOf(this.values[i]) - compensation;
            double nextSum = sum + adjustedValue;
            compensation = nextSum - sum - adjustedValue;
            sum = nextSum;
        }
        return sum;
    }

    public long sumOfLong(LongFunction<? super V> function) {
        long sum = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                sum += function.longValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                sum += function.longValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += function.longValueOf(this.values[i]);
        }
        return sum;
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        double sum = 0.0;
        double compensation = 0.0;
        if (this.sentinelValues != null) {
            double nextSum;
            double adjustedValue;
            if (this.sentinelValues.containsZeroKey) {
                adjustedValue = function.doubleValueOf(((SentinelValues)this.sentinelValues).zeroValue) - compensation;
                nextSum = sum + adjustedValue;
                compensation = nextSum - sum - adjustedValue;
                sum = nextSum;
            }
            if (this.sentinelValues.containsOneKey) {
                adjustedValue = function.doubleValueOf(((SentinelValues)this.sentinelValues).oneValue) - compensation;
                nextSum = sum + adjustedValue;
                compensation = nextSum - sum - adjustedValue;
                sum = nextSum;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = function.doubleValueOf(this.values[i]) - compensation;
            double nextSum = sum + adjustedValue;
            compensation = nextSum - sum - adjustedValue;
            sum = nextSum;
        }
        return sum;
    }

    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> groupBy, IntFunction<? super V> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> groupBy, FloatFunction<? super V> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> groupBy, LongFunction<? super V> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> groupBy, DoubleFunction<? super V> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.keys = new char[this.keys.length];
            this.copyKeysOnWrite = false;
        }
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
    }

    public V put(char key, V value) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            this.sentinelValues.containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)oldValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            this.sentinelValues.containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            V oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        this.addKeyValueAtIndex(key, value, index);
        return null;
    }

    public void putAll(CharObjectMap<? extends V> map) {
        map.forEachKeyValue((CharObjectProcedure & Serializable)(key, value) -> this.put(key, value));
    }

    public boolean containsKey(char key) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(Object value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i]) || !CharObjectHashMap.nullSafeEquals(this.values[i], value)) continue;
            return true;
        }
        return false;
    }

    public V get(char key) {
        return (V)this.getIfAbsent(key, Functions0.nullValue());
    }

    public V getIfAbsent(char key, Function0<? extends V> ifAbsent) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return (V)ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return (V)ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return (V)ifAbsent.value();
    }

    public V getIfAbsentPut(char key, V value) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public V getIfAbsentPut(char key, Function0<? extends V> function) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.value();
            this.sentinelValues.containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (this.sentinelValues.containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.value();
            this.sentinelValues.containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        Object value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return (V)value;
    }

    public <P> V getIfAbsentPutWith(char key, Function<? super P, ? extends V> function, P parameter) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.valueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (this.sentinelValues.containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.valueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        Object value = function.valueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return (V)value;
    }

    public V getIfAbsentPutWithKey(char key, CharToObjectFunction<? extends V> function) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (this.sentinelValues.containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        Object value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return (V)value;
    }

    public V updateValue(char key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            } else if (this.sentinelValues.containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            } else if (this.sentinelValues.containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        Object value = function.valueOf(factory.value());
        this.addKeyValueAtIndex(key, value, index);
        return (V)value;
    }

    public <P> V updateValueWith(char key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            } else if (this.sentinelValues.containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            } else {
                this.sentinelValues.containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            } else if (this.sentinelValues.containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            } else {
                this.sentinelValues.containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.value(this.values[index], parameter);
            return this.values[index];
        }
        Object value = function.value(factory.value(), parameter);
        this.addKeyValueAtIndex(key, value, index);
        return (V)value;
    }

    public V removeKey(char key) {
        if (CharObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                ((SentinelValues)this.sentinelValues).zeroValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        if (CharObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                ((SentinelValues)this.sentinelValues).oneValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            V oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return null;
    }

    public V remove(char key) {
        return this.removeKey(key);
    }

    public CharObjectHashMap<V> withKeyValue(char key, V value) {
        this.put(key, value);
        return this;
    }

    public MutableCharObjectMap<V> withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    public MutableCharObjectMap<V> withoutAllKeys(CharIterable keys) {
        CharIterator iterator = keys.charIterator();
        while (iterator.hasNext()) {
            char item = iterator.next();
            this.removeKey(item);
        }
        return this;
    }

    public CharObjectHashMap<V> withKeysValues(char key1, V value1, char key2, V value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharObjectHashMap<V> withKeysValues(char key1, V value1, char key2, V value2, char key3, V value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharObjectHashMap<V> withKeysValues(char key1, V value1, char key2, V value2, char key3, V value3, char key4, V value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public MutableCharObjectMap<V> asUnmodifiable() {
        return new UnmodifiableCharObjectMap(this);
    }

    public MutableCharObjectMap<V> asSynchronized() {
        return new SynchronizedCharObjectMap(this);
    }

    public ImmutableCharObjectMap<V> toImmutable() {
        return CharObjectMaps.immutable.withAll((CharObjectMap)this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeChar(0);
                out.writeObject(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeChar(1);
                out.writeObject(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharObjectHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeChar(this.keys[i]);
            out.writeObject(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readChar(), in.readObject());
        }
    }

    private void addKeyValueAtIndex(char key, V value, int index) {
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = '\u0001';
        this.values[index] = null;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        char[] copy = new char[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public MutableCharSet keySet() {
        return new KeySet();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        char[] old = this.keys;
        V[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!CharObjectHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
        this.copyKeysOnWrite = false;
    }

    int probe(char element) {
        int index = this.mask(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        for (int i = 1; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(char element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            char keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(char element, int removedIndex) {
        int nextIndex = SpreadFunctions.charSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.charSpreadTwo(element)) | 1;
        char keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(char element) {
        int code = SpreadFunctions.charSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(char element) {
        int code = SpreadFunctions.charSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new char[sizeToAllocate];
        this.values = new Object[sizeToAllocate];
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharObjectHashMap.isEmptyKey(key) && !CharObjectHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity >> 1);
    }

    public Collection<V> values() {
        return new ValuesCollection();
    }

    public LazyCharIterable keysView() {
        return new KeysView();
    }

    public RichIterable<CharObjectPair<V>> keyValuesView() {
        return new KeyValuesView();
    }

    public MutableObjectCharMap<V> flipUniqueValues() {
        MutableObjectCharMap result = ObjectCharMaps.mutable.empty();
        this.forEachKeyValue((CharObjectProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    static /* synthetic */ char[] access$602(CharObjectHashMap x0, char[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$802(CharObjectHashMap x0, Object[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<CharObjectPair<V>> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super CharObjectPair<V>> procedure) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (((CharObjectHashMap)CharObjectHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair('\u0000', CharObjectHashMap.this.sentinelValues.zeroValue));
                }
                if (((CharObjectHashMap)CharObjectHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair('\u0001', CharObjectHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(CharObjectHashMap.this.keys[i], CharObjectHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super CharObjectPair<V>> objectIntProcedure) {
            int index = 0;
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (((CharObjectHashMap)CharObjectHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair('\u0000', CharObjectHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((CharObjectHashMap)CharObjectHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair('\u0001', CharObjectHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(CharObjectHashMap.this.keys[i], CharObjectHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super CharObjectPair<V>, ? super P> procedure, P parameter) {
            if (CharObjectHashMap.this.sentinelValues != null) {
                if (((CharObjectHashMap)CharObjectHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair('\u0000', CharObjectHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (((CharObjectHashMap)CharObjectHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair('\u0001', CharObjectHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < CharObjectHashMap.this.keys.length; ++i) {
                if (!CharObjectHashMap.isNonSentinel(CharObjectHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(CharObjectHashMap.this.keys[i], CharObjectHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<CharObjectPair<V>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<CharObjectPair<V>> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public CharObjectPair<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (CharObjectHashMap.this.containsKey('\u0000')) {
                        return PrimitiveTuples.pair('\u0000', CharObjectHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (CharObjectHashMap.this.containsKey('\u0001')) {
                        return PrimitiveTuples.pair('\u0001', CharObjectHashMap.this.sentinelValues.oneValue);
                    }
                }
                char[] keys = CharObjectHashMap.this.keys;
                while (!CharObjectHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                CharObjectPair<Object> result = PrimitiveTuples.pair(keys[this.position], CharObjectHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != CharObjectHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyCharIterable {
        private KeysView() {
        }

        public CharIterator charIterator() {
            return new UnmodifiableCharIterator((CharIterator)new KeysSetIterator());
        }

        public void each(CharProcedure procedure) {
            CharObjectHashMap.this.forEachKey(procedure);
        }
    }

    protected class ValuesCollection
    implements Collection<V> {
        protected ValuesCollection() {
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public void clear() {
            CharObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return CharObjectHashMap.this.containsValue(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return Iterate.allSatisfy(collection, Predicates.in(this));
        }

        @Override
        public boolean isEmpty() {
            return CharObjectHashMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return CharObjectHashMap.this.iterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    if (it.next() != null) continue;
                    it.remove();
                    return true;
                }
            } else {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Object o2 = it.next();
                    if (o != o2 && !o2.equals(o)) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            Iterator e = this.iterator();
            while (e.hasNext()) {
                if (collection.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public int size() {
            return CharObjectHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return CharObjectHashMap.this.toArray();
        }

        @Override
        public <T> T[] toArray(T[] result) {
            return CharObjectHashMap.this.toArray(result);
        }
    }

    private class KeysSetIterator
    implements MutableCharIterator {
        private int count;
        private int position;
        private char lastKey;
        private boolean handledZeroKey;
        private boolean handledOneKey;
        private boolean canRemove;

        private KeysSetIterator() {
        }

        public boolean hasNext() {
            return this.count != CharObjectHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (CharObjectHashMap.this.containsKey('\u0000')) {
                    this.lastKey = '\u0000';
                    return this.lastKey;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (CharObjectHashMap.this.containsKey('\u0001')) {
                    this.lastKey = '\u0001';
                    return this.lastKey;
                }
            }
            char[] keys = CharObjectHashMap.this.keys;
            while (!CharObjectHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            CharObjectHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeySet
    extends AbstractMutableCharKeySet {
        private KeysMapWrapper outer;

        private KeySet() {
            this.outer = new KeysMapWrapper();
        }

        @Override
        protected MutableCharKeysMap getOuter() {
            return this.outer;
        }

        @Override
        protected SentinelValues getSentinelValues() {
            return CharObjectHashMap.this.sentinelValues;
        }

        @Override
        protected char getKeyAtIndex(int index) {
            return CharObjectHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return CharObjectHashMap.this.keys.length;
        }

        public MutableCharIterator charIterator() {
            return new KeysSetIterator();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = CharObjectHashMap.this.size();
            Object sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            MutableCharObjectMap retained = CharObjectHashMap.this.select((arg_0, arg_1) -> KeySet.lambda$retainAll$d82771f5$1((CharSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                CharObjectHashMap.access$602(CharObjectHashMap.this, ((CharObjectHashMap)retained).keys);
                CharObjectHashMap.access$802(CharObjectHashMap.this, ((CharObjectHashMap)retained).values);
                CharObjectHashMap.this.sentinelValues = ((CharObjectHashMap)retained).sentinelValues;
                CharObjectHashMap.this.occupiedWithData = ((CharObjectHashMap)retained).occupiedWithData;
                CharObjectHashMap.this.occupiedWithSentinels = ((CharObjectHashMap)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(char ... source) {
            return this.retainAll(CharHashSet.newSetWith(source));
        }

        public CharSet freeze() {
            CharObjectHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (CharObjectHashMap.this.sentinelValues != null) {
                containsZeroKey = ((CharObjectHashMap)CharObjectHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((CharObjectHashMap)CharObjectHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableCharMapKeySet(CharObjectHashMap.this.keys, CharObjectHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        public MutableCharSet newEmpty() {
            return new CharHashSet();
        }

        private static /* synthetic */ boolean lambda$retainAll$d82771f5$1(CharSet sourceSet, char key, Object value) {
            return sourceSet.contains(key);
        }
    }

    private class KeysMapWrapper
    implements MutableCharKeysMap {
        private KeysMapWrapper() {
        }

        @Override
        public int size() {
            return CharObjectHashMap.this.size();
        }

        @Override
        public boolean containsKey(char key) {
            return CharObjectHashMap.this.containsKey(key);
        }

        @Override
        public void forEachKey(CharProcedure procedure) {
            CharObjectHashMap.this.forEachKey(procedure);
        }

        @Override
        public boolean isEmpty() {
            return CharObjectHashMap.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return CharObjectHashMap.this.notEmpty();
        }

        @Override
        public void removeKey(char key) {
            CharObjectHashMap.this.removeKey(key);
        }

        @Override
        public void clear() {
            CharObjectHashMap.this.clear();
        }
    }

    private class InternalIterator
    implements Iterator<V> {
        private int count;
        private int position;
        private char currentKey;
        private boolean isCurrentKeySet;
        private boolean handledZeroKey;
        private boolean handledOneKey;

        private InternalIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != CharObjectHashMap.this.size();
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (CharObjectHashMap.this.containsKey('\u0000')) {
                    this.currentKey = '\u0000';
                    this.isCurrentKeySet = true;
                    return CharObjectHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (CharObjectHashMap.this.containsKey('\u0001')) {
                    this.currentKey = '\u0001';
                    this.isCurrentKeySet = true;
                    return CharObjectHashMap.this.sentinelValues.oneValue;
                }
            }
            char[] keys = CharObjectHashMap.this.keys;
            while (!CharObjectHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = CharObjectHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            Object result = CharObjectHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (CharObjectHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                CharObjectHashMap.this.removeKeyAtIndex(index);
            } else {
                CharObjectHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    private static final class SentinelValues<V>
    extends AbstractSentinelValues {
        private V zeroValue;
        private V oneValue;

        private SentinelValues() {
        }

        @Override
        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(V value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && CharObjectHashMap.nullSafeEquals(this.zeroValue, value);
            boolean valueEqualsOneValue = this.containsOneKey && CharObjectHashMap.nullSafeEquals(this.oneValue, value);
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

