/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppAttemptBlock
extends HtmlBlock {
    private static final Logger LOG = LoggerFactory.getLogger(AppAttemptBlock.class);
    protected ApplicationBaseProtocol appBaseProt;
    protected ApplicationAttemptId appAttemptId = null;

    @Inject
    public AppAttemptBlock(ApplicationBaseProtocol appBaseProt, View.ViewContext ctx) {
        super(ctx);
        this.appBaseProt = appBaseProt;
    }

    protected void render(HtmlBlock.Block html) {
        ApplicationAttemptReport appAttemptReport;
        String attemptid = this.$("appattempt.id");
        if (attemptid.isEmpty()) {
            this.puts(new Object[]{"Bad request: requires application attempt ID"});
            return;
        }
        try {
            this.appAttemptId = ApplicationAttemptId.fromString((String)attemptid);
        }
        catch (IllegalArgumentException e) {
            this.puts(new Object[]{"Invalid application attempt ID: " + attemptid});
            return;
        }
        UserGroupInformation callerUGI = this.getCallerUGI();
        try {
            final GetApplicationAttemptReportRequest request = GetApplicationAttemptReportRequest.newInstance((ApplicationAttemptId)this.appAttemptId);
            appAttemptReport = callerUGI == null ? this.getApplicationAttemptReport(request) : (ApplicationAttemptReport)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationAttemptReport>(){

                @Override
                public ApplicationAttemptReport run() throws Exception {
                    return AppAttemptBlock.this.getApplicationAttemptReport(request);
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the application attempt " + this.appAttemptId + ".";
            LOG.error(message, (Throwable)e);
            html.p().__(new Object[]{message}).__();
            return;
        }
        if (appAttemptReport == null) {
            this.puts(new Object[]{"Application Attempt not found: " + attemptid});
            return;
        }
        boolean exceptionWhenGetContainerReports = false;
        Collection<Object> containers = null;
        try {
            final GetContainersRequest request = GetContainersRequest.newInstance((ApplicationAttemptId)this.appAttemptId);
            containers = callerUGI == null ? this.getContainers(request) : (Collection)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<ContainerReport>>(){

                @Override
                public Collection<ContainerReport> run() throws Exception {
                    return AppAttemptBlock.this.getContainers(request);
                }
            });
        }
        catch (RuntimeException e) {
            exceptionWhenGetContainerReports = true;
        }
        catch (Exception e) {
            exceptionWhenGetContainerReports = true;
        }
        AppAttemptInfo appAttempt = new AppAttemptInfo(appAttemptReport);
        this.setTitle(StringHelper.join((Object[])new Object[]{"Application Attempt ", attemptid}));
        String node = "N/A";
        if (appAttempt.getHost() != null && appAttempt.getRpcPort() >= 0 && appAttempt.getRpcPort() < 65536) {
            node = appAttempt.getHost() + ":" + appAttempt.getRpcPort();
        }
        this.generateOverview(appAttemptReport, containers, appAttempt, node);
        if (exceptionWhenGetContainerReports) {
            html.p().__(new Object[]{"Sorry, Failed to get containers for application attempt" + attemptid + "."}).__();
            return;
        }
        this.createAttemptHeadRoomTable(html);
        html.__(InfoBlock.class);
        this.createTablesForAttemptMetrics(html);
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#containers").thead().tr().th(".id", "Container ID").th(".node", "Node").th(".exitstatus", "Container Exit Status").th(".logs", "Logs").__()).__()).tbody();
        StringBuilder containersTableData = new StringBuilder("[\n");
        for (ContainerReport containerReport : containers) {
            ContainerInfo container = new ContainerInfo(containerReport);
            containersTableData.append("[\"<a href='").append(this.url(new String[]{"container", container.getContainerId()})).append("'>").append(container.getContainerId()).append("</a>\",\"<a ").append(container.getNodeHttpAddress() == null ? "#" : "href='" + container.getNodeHttpAddress()).append("'>").append(container.getNodeHttpAddress() == null ? "N/A" : StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)container.getNodeHttpAddress()))).append("</a>\",\"").append(container.getContainerExitStatus()).append("\",\"<a href='").append(container.getLogUrl() == null ? "#" : container.getLogUrl()).append("'>").append(container.getLogUrl() == null ? "N/A" : "Logs").append("</a>\"],\n");
        }
        if (containersTableData.charAt(containersTableData.length() - 2) == ',') {
            containersTableData.delete(containersTableData.length() - 2, containersTableData.length() - 1);
        }
        containersTableData.append("]");
        html.script().$type("text/javascript").__(new Object[]{"var containersTableData=" + containersTableData}).__();
        ((Hamlet.TABLE)tbody.__()).__();
    }

    protected List<ContainerReport> getContainers(GetContainersRequest request) throws YarnException, IOException {
        return this.appBaseProt.getContainers(request).getContainerList();
    }

    protected ApplicationAttemptReport getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        return this.appBaseProt.getApplicationAttemptReport(request).getApplicationAttemptReport();
    }

    protected void generateOverview(ApplicationAttemptReport appAttemptReport, Collection<ContainerReport> containers, AppAttemptInfo appAttempt, String node) {
        String amContainerId = appAttempt.getAmContainerId();
        this.info("Application Attempt Overview").__("Application Attempt State:", (Object)(appAttempt.getAppAttemptState() == null ? "N/A" : appAttempt.getAppAttemptState())).__("AM Container:", amContainerId == null || containers == null || !this.hasAMContainer(appAttemptReport.getAMContainerId(), containers) ? null : this.root_url(new String[]{"container", amContainerId}), (Object)(amContainerId == null ? "N/A" : amContainerId)).__("Node:", (Object)node).__("Tracking URL:", appAttempt.getTrackingUrl() == null || appAttempt.getTrackingUrl().equals("N/A") ? null : this.root_url(new String[]{appAttempt.getTrackingUrl()}), (Object)(appAttempt.getTrackingUrl() == null || appAttempt.getTrackingUrl().equals("N/A") ? "Unassigned" : (appAttempt.getAppAttemptState() == YarnApplicationAttemptState.FINISHED || appAttempt.getAppAttemptState() == YarnApplicationAttemptState.FAILED || appAttempt.getAppAttemptState() == YarnApplicationAttemptState.KILLED ? "History" : "ApplicationMaster"))).__("Diagnostics Info:", (Object)(appAttempt.getDiagnosticsInfo() == null ? "" : appAttempt.getDiagnosticsInfo()));
    }

    protected boolean hasAMContainer(ContainerId containerId, Collection<ContainerReport> containers) {
        for (ContainerReport container : containers) {
            if (!containerId.equals((Object)container.getContainerId())) continue;
            return true;
        }
        return false;
    }

    protected void createAttemptHeadRoomTable(HtmlBlock.Block html) {
    }

    protected void createTablesForAttemptMetrics(HtmlBlock.Block html) {
    }
}

