/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util.hash;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;

public class SimpleHasher
implements ArrowBufHasher {
    public static SimpleHasher INSTANCE = new SimpleHasher();

    protected SimpleHasher() {
    }

    @Override
    public int hashCode(long address, long length) {
        int hashValue = 0;
        int index = 0;
        while ((long)(index + 8) <= length) {
            long longValue = MemoryUtil.UNSAFE.getLong(address + (long)index);
            int longHash = this.getLongHashCode(longValue);
            hashValue = this.combineHashCode(hashValue, longHash);
            index += 8;
        }
        if ((long)(index + 4) <= length) {
            int intValue;
            int intHash = intValue = MemoryUtil.UNSAFE.getInt(address + (long)index);
            hashValue = this.combineHashCode(hashValue, intHash);
            index += 4;
        }
        while ((long)index < length) {
            byte byteValue;
            byte byteHash = byteValue = MemoryUtil.UNSAFE.getByte(address + (long)index);
            hashValue = this.combineHashCode(hashValue, byteHash);
            ++index;
        }
        return this.finalizeHashCode(hashValue);
    }

    @Override
    public int hashCode(ArrowBuf buf, long offset, long length) {
        buf.checkBytes(offset, offset + length);
        return this.hashCode(buf.memoryAddress() + offset, length);
    }

    protected int combineHashCode(int currentHashCode, int newHashCode) {
        return currentHashCode * 37 + newHashCode;
    }

    protected int getLongHashCode(long longValue) {
        return Long.hashCode(longValue);
    }

    protected int finalizeHashCode(int hashCode) {
        return hashCode;
    }

    public int hashCode() {
        return 123;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof SimpleHasher;
    }
}

