/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Schema;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;

public class SchemaDetails
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;

    public SchemaDetails(CommandContext context, String metalake, String catalog, String schema) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
    }

    @Override
    public void handle() {
        Schema result = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            result = client.loadCatalog(this.catalog).asSchemas().loadSchema(this.schema);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (result != null) {
            this.printResults(result);
        }
    }
}

