/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.indexes;

import com.google.common.base.Objects;
import java.util.Arrays;
import org.apache.gravitino.rel.indexes.Index;

public class Indexes {
    public static final Index[] EMPTY_INDEXES = new Index[0];
    public static final String DEFAULT_MYSQL_PRIMARY_KEY_NAME = "PRIMARY";

    public static Index unique(String name, String[][] fieldNames) {
        return Indexes.of(Index.IndexType.UNIQUE_KEY, name, fieldNames);
    }

    public static Index createMysqlPrimaryKey(String[][] fieldNames) {
        return Indexes.primary(DEFAULT_MYSQL_PRIMARY_KEY_NAME, fieldNames);
    }

    public static Index primary(String name, String[][] fieldNames) {
        return Indexes.of(Index.IndexType.PRIMARY_KEY, name, fieldNames);
    }

    public static Index of(Index.IndexType indexType, String name, String[][] fieldNames) {
        return IndexImpl.builder().withIndexType(indexType).withName(name).withFieldNames(fieldNames).build();
    }

    private Indexes() {
    }

    public static final class IndexImpl
    implements Index {
        private final Index.IndexType indexType;
        private final String name;
        private final String[][] fieldNames;

        private IndexImpl(Index.IndexType indexType, String name, String[][] fieldNames) {
            this.indexType = indexType;
            this.name = name;
            this.fieldNames = fieldNames;
        }

        @Override
        public Index.IndexType type() {
            return this.indexType;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String[][] fieldNames() {
            return this.fieldNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexImpl index = (IndexImpl)o;
            return this.indexType == index.indexType && Objects.equal(this.name, index.name) && Arrays.deepEquals((Object[])this.fieldNames, (Object[])index.fieldNames);
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.indexType, this.name, Arrays.hashCode((Object[])this.fieldNames)});
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            protected Index.IndexType indexType;
            protected String name;
            protected String[][] fieldNames;

            public Builder withIndexType(Index.IndexType indexType) {
                this.indexType = indexType;
                return this;
            }

            public Builder withName(String name) {
                this.name = name;
                return this;
            }

            public Builder withFieldNames(String[][] fieldNames) {
                this.fieldNames = fieldNames;
                return this;
            }

            public Index build() {
                return new IndexImpl(this.indexType, this.name, this.fieldNames);
            }
        }
    }
}

