/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class DoubleFieldMetrics
extends FieldMetrics<Double> {
    private DoubleFieldMetrics(int id, long valueCount, long nanValueCount, Double lowerBound, Double upperBound) {
        super(id, valueCount, 0L, nanValueCount, lowerBound, upperBound, (Type)Types.DoubleType.get());
    }

    public static class Builder {
        private final int id;
        private long valueCount = 0L;
        private long nanValueCount = 0L;
        private double lowerBound = Double.POSITIVE_INFINITY;
        private double upperBound = Double.NEGATIVE_INFINITY;

        public Builder(int id) {
            this.id = id;
        }

        public void addValue(double value) {
            ++this.valueCount;
            if (Double.isNaN(value)) {
                ++this.nanValueCount;
            } else {
                if (Double.compare(value, this.lowerBound) < 0) {
                    this.lowerBound = value;
                }
                if (Double.compare(value, this.upperBound) > 0) {
                    this.upperBound = value;
                }
            }
        }

        public DoubleFieldMetrics build() {
            boolean hasBound = this.valueCount - this.nanValueCount > 0L;
            return new DoubleFieldMetrics(this.id, this.valueCount, this.nanValueCount, hasBound ? Double.valueOf(this.lowerBound) : null, hasBound ? Double.valueOf(this.upperBound) : null);
        }
    }
}

