/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.SchemaMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.ibatis.annotations.Param;

public class SchemaMetaPostgreSQLProvider
extends SchemaMetaBaseSQLProvider {
    @Override
    public String insertSchemaMetaOnDuplicateKeyUpdate(SchemaPO schemaPO) {
        return "INSERT INTO schema_meta (schema_id, schema_name, metalake_id, catalog_id, schema_comment, properties, audit_info, current_version, last_version, deleted_at) VALUES ( #{schemaMeta.schemaId}, #{schemaMeta.schemaName}, #{schemaMeta.metalakeId}, #{schemaMeta.catalogId}, #{schemaMeta.schemaComment}, #{schemaMeta.properties}, #{schemaMeta.auditInfo}, #{schemaMeta.currentVersion}, #{schemaMeta.lastVersion}, #{schemaMeta.deletedAt} ) ON CONFLICT(schema_id) DO UPDATE SET schema_name = #{schemaMeta.schemaName}, metalake_id = #{schemaMeta.metalakeId}, catalog_id = #{schemaMeta.catalogId}, schema_comment = #{schemaMeta.schemaComment}, properties = #{schemaMeta.properties}, audit_info = #{schemaMeta.auditInfo}, current_version = #{schemaMeta.currentVersion}, last_version = #{schemaMeta.lastVersion}, deleted_at = #{schemaMeta.deletedAt}";
    }

    @Override
    public String updateSchemaMeta(@Param(value="newSchemaMeta") SchemaPO newSchemaPO, @Param(value="oldSchemaMeta") SchemaPO oldSchemaPO) {
        return "UPDATE schema_meta SET schema_name = #{newSchemaMeta.schemaName}, metalake_id = #{newSchemaMeta.metalakeId}, catalog_id = #{newSchemaMeta.catalogId}, schema_comment = #{newSchemaMeta.schemaComment}, properties = #{newSchemaMeta.properties}, audit_info = #{newSchemaMeta.auditInfo}, current_version = #{newSchemaMeta.currentVersion}, last_version = #{newSchemaMeta.lastVersion}, deleted_at = #{newSchemaMeta.deletedAt} WHERE schema_id = #{oldSchemaMeta.schemaId} AND schema_name = #{oldSchemaMeta.schemaName} AND metalake_id = #{oldSchemaMeta.metalakeId} AND catalog_id = #{oldSchemaMeta.catalogId} AND (schema_comment = #{oldSchemaMeta.schemaComment}   OR (CAST(schema_comment AS VARCHAR) IS NULL   AND CAST(#{oldSchemaMeta.schemaComment} AS VARCHAR) IS NULL)) AND properties = #{oldSchemaMeta.properties} AND audit_info = #{oldSchemaMeta.auditInfo} AND current_version = #{oldSchemaMeta.currentVersion} AND last_version = #{oldSchemaMeta.lastVersion} AND deleted_at = 0";
    }

    @Override
    public String softDeleteSchemaMetasBySchemaId(Long schemaId) {
        return "UPDATE schema_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteSchemaMetasByMetalakeId(Long metalakeId) {
        return "UPDATE schema_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteSchemaMetasByCatalogId(Long catalogId) {
        return "UPDATE schema_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    @Override
    public String deleteSchemaMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM schema_meta WHERE schema_id IN (SELECT schema_id FROM schema_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

