/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.FourLetterWordMain;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerStartupTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServerStartupTest.class);
    private static int PORT = PortAssignment.unique();
    private static String HOST = "127.0.0.1";
    private static String HOSTPORT = HOST + ":" + PORT;
    private static final String ZK_NOT_SERVING = "This ZooKeeper instance is not currently serving requests";
    private ServerCnxnFactory servcnxnf;
    private ZooKeeperServer zks;
    private File tmpDir;
    private CountDownLatch startupDelayLatch = new CountDownLatch(1);

    @After
    public void teardown() throws Exception {
        this.startupDelayLatch.countDown();
        if (this.servcnxnf != null) {
            this.servcnxnf.shutdown();
        }
        if (this.zks != null) {
            this.zks.shutdown();
        }
        if (this.zks.getZKDatabase() != null) {
            this.zks.getZKDatabase().close();
        }
        if (this.tmpDir != null) {
            ClientBase.recursiveDelete(this.tmpDir);
        }
    }

    @Test(timeout=30000L)
    public void testClientConnectionRequestDuringStartupWithNIOServerCnxn() throws Exception {
        this.tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        this.startSimpleZKServer(this.startupDelayLatch);
        SimpleZooKeeperServer simplezks = (SimpleZooKeeperServer)this.zks;
        Assert.assertTrue((String)"Failed to invoke zks#startup() method during server startup", (boolean)simplezks.waitForStartupInvocation(10L));
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zkClient = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        Assert.assertFalse((String)"Since server is not fully started, zks#createSession() shouldn't be invoked", (boolean)simplezks.waitForSessionCreation(5L));
        LOG.info("Decrements the count of the latch, so that server will proceed with startup");
        this.startupDelayLatch.countDown();
        Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"Failed to invoke zks#createSession() method during client session creation", (boolean)simplezks.waitForSessionCreation(5L));
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        zkClient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testClientConnectionRequestDuringStartupWithNettyServerCnxn() throws Exception {
        this.tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        String originalServerCnxnFactory = System.getProperty("zookeeper.serverCnxnFactory");
        try {
            System.setProperty("zookeeper.serverCnxnFactory", NettyServerCnxnFactory.class.getName());
            this.startSimpleZKServer(this.startupDelayLatch);
            SimpleZooKeeperServer simplezks = (SimpleZooKeeperServer)this.zks;
            Assert.assertTrue((String)"Failed to invoke zks#startup() method during server startup", (boolean)simplezks.waitForStartupInvocation(10L));
            ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
            ZooKeeper zkClient = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
            Assert.assertFalse((String)"Since server is not fully started, zks#createSession() shouldn't be invoked", (boolean)simplezks.waitForSessionCreation(5L));
            LOG.info("Decrements the count of the latch, so that server will proceed with startup");
            this.startupDelayLatch.countDown();
            Assert.assertTrue((String)"waiting for server being up ", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            Assert.assertTrue((String)"Failed to invoke zks#createSession() method during client session creation", (boolean)simplezks.waitForSessionCreation(5L));
            watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
            zkClient.close();
        }
        finally {
            if (originalServerCnxnFactory == null) {
                System.clearProperty("zookeeper.serverCnxnFactory");
            } else {
                System.setProperty("zookeeper.serverCnxnFactory", originalServerCnxnFactory);
            }
        }
    }

    @Test(timeout=30000L)
    public void testFourLetterWordsWithNIOServerCnxn() throws Exception {
        this.startSimpleZKServer(this.startupDelayLatch);
        this.verify("conf", ZK_NOT_SERVING);
        this.verify("crst", ZK_NOT_SERVING);
        this.verify("cons", ZK_NOT_SERVING);
        this.verify("dump", ZK_NOT_SERVING);
        this.verify("mntr", ZK_NOT_SERVING);
        this.verify("stat", ZK_NOT_SERVING);
        this.verify("srst", ZK_NOT_SERVING);
        this.verify("wchs", ZK_NOT_SERVING);
        this.verify("isro", "null");
    }

    @Test(timeout=30000L)
    public void testFourLetterWordsWithNettyServerCnxn() throws Exception {
        String originalServerCnxnFactory = System.getProperty("zookeeper.serverCnxnFactory");
        try {
            this.startSimpleZKServer(this.startupDelayLatch);
            this.verify("conf", ZK_NOT_SERVING);
            this.verify("crst", ZK_NOT_SERVING);
            this.verify("cons", ZK_NOT_SERVING);
            this.verify("dump", ZK_NOT_SERVING);
            this.verify("mntr", ZK_NOT_SERVING);
            this.verify("stat", ZK_NOT_SERVING);
            this.verify("srst", ZK_NOT_SERVING);
            this.verify("wchs", ZK_NOT_SERVING);
            this.verify("isro", "null");
        }
        finally {
            if (originalServerCnxnFactory == null) {
                System.clearProperty("zookeeper.serverCnxnFactory");
            } else {
                System.setProperty("zookeeper.serverCnxnFactory", originalServerCnxnFactory);
            }
        }
    }

    private void verify(String cmd, String expected) throws IOException {
        String resp = this.sendRequest(cmd);
        LOG.info("cmd " + cmd + " expected " + expected + " got " + resp);
        Assert.assertTrue((String)("Unexpected response: " + resp), (boolean)resp.contains(expected));
    }

    private String sendRequest(String cmd) throws IOException {
        return FourLetterWordMain.send4LetterWord((String)HOST, (int)PORT, (String)cmd);
    }

    private void startSimpleZKServer(CountDownLatch startupDelayLatch) throws IOException {
        this.zks = new SimpleZooKeeperServer(this.tmpDir, this.tmpDir, 3000, startupDelayLatch);
        SyncRequestProcessor.setSnapCount((int)100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        this.servcnxnf = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        Thread startupThread = new Thread(){

            @Override
            public void run() {
                try {
                    ZooKeeperServerStartupTest.this.servcnxnf.startup(ZooKeeperServerStartupTest.this.zks);
                }
                catch (IOException e) {
                    LOG.error("Unexcepted exception during server startup", (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.error("Unexcepted exception during server startup", (Throwable)e);
                }
            }
        };
        LOG.info("Starting zk server {}", (Object)HOSTPORT);
        startupThread.start();
    }

    private static class SimpleZooKeeperServer
    extends ZooKeeperServer {
        private CountDownLatch startupDelayLatch;
        private CountDownLatch startupInvokedLatch = new CountDownLatch(1);
        private CountDownLatch createSessionInvokedLatch = new CountDownLatch(1);

        public SimpleZooKeeperServer(File snapDir, File logDir, int tickTime, CountDownLatch startupDelayLatch) throws IOException {
            super(snapDir, logDir, tickTime);
            this.startupDelayLatch = startupDelayLatch;
        }

        public synchronized void startup() {
            try {
                this.startupInvokedLatch.countDown();
                this.startupDelayLatch.await();
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Unexpected InterruptedException while startinng up!");
            }
            super.startup();
        }

        long createSession(ServerCnxn cnxn, byte[] passwd, int timeout) {
            this.createSessionInvokedLatch.countDown();
            return super.createSession(cnxn, passwd, timeout);
        }

        boolean waitForStartupInvocation(long timeout) throws InterruptedException {
            return this.startupInvokedLatch.await(timeout, TimeUnit.SECONDS);
        }

        boolean waitForSessionCreation(long timeout) throws InterruptedException {
            return this.createSessionInvokedLatch.await(timeout, TimeUnit.SECONDS);
        }
    }
}

