/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import org.apache.zookeeper.server.persistence.TxnLogToolkit;
import org.apache.zookeeper.server.persistence.TxnLogToolkitCliParser;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TxnLogToolkitCliParserTest {
    private TxnLogToolkitCliParser parser;

    @Before
    public void setUp() {
        this.parser = new TxnLogToolkitCliParser();
    }

    @Test(expected=TxnLogToolkit.TxnLogToolkitParseException.class)
    public void testParseWithNoArguments() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(null);
    }

    @Test(expected=TxnLogToolkit.TxnLogToolkitParseException.class)
    public void testParseWithEmptyArgs() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[0]);
    }

    @Test(expected=TxnLogToolkit.TxnLogToolkitParseException.class)
    public void testParseWith2Filenames() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"file1.log", "file2.log "});
    }

    @Test(expected=TxnLogToolkit.TxnLogToolkitParseException.class)
    public void testParseWithInvalidShortSwitch() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"-v", "-i", "txnlog.txt"});
    }

    @Test(expected=TxnLogToolkit.TxnLogToolkitParseException.class)
    public void testParseWithInvalidLongSwitch() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"-v", "--invalid", "txnlog.txt"});
    }

    @Test
    public void testParseRecoveryModeSwitchShort() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"-r", "txnlog.txt"});
        Assert.assertThat((String)"Recovery short switch should turn on recovery mode", (Object)this.parser.isRecoveryMode(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testParseRecoveryModeSwitchLong() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"--recover", "txnlog.txt"});
        Assert.assertThat((String)"Recovery long switch should turn on recovery mode", (Object)this.parser.isRecoveryMode(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testParseVerboseModeSwitchShort() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"-v", "txnlog.txt"});
        Assert.assertThat((String)"Verbose short switch should turn on verbose mode", (Object)this.parser.isVerbose(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testParseVerboseModeSwitchLong() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"--verbose", "txnlog.txt"});
        Assert.assertThat((String)"Verbose long switch should turn on verbose mode", (Object)this.parser.isVerbose(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testParseDumpModeSwitchShort() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"-r", "txnlog.txt"});
        this.parser.parse(new String[]{"-d", "txnlog.txt"});
        Assert.assertThat((String)"Dump short switch should turn off recover mode", (Object)this.parser.isRecoveryMode(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testParseDumpModeSwitchLong() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"-r", "txnlog.txt"});
        this.parser.parse(new String[]{"--dump", "txnlog.txt"});
        Assert.assertThat((String)"Dump long switch should turn off recovery mode", (Object)this.parser.isRecoveryMode(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testParseForceModeSwitchShort() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"-y", "txnlog.txt"});
        Assert.assertThat((String)"Force short switch should turn on force mode", (Object)this.parser.isForce(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testParseForceModeSwitchLong() throws TxnLogToolkit.TxnLogToolkitParseException {
        this.parser.parse(new String[]{"--yes", "txnlog.txt"});
        Assert.assertThat((String)"Force long switch should turn on force mode", (Object)this.parser.isForce(), (Matcher)Is.is((Object)true));
    }
}

