/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.events.AddIndexEvent;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterIndexEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.metastore.events.DropIndexEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.InsertEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;

@InterfaceAudience.Private
public class MetaStoreListenerNotifier {
    private static Map<EventMessage.EventType, EventNotifier> notificationEvents = Maps.newHashMap((Map)ImmutableMap.builder().put((Object)EventMessage.EventType.CREATE_DATABASE, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onCreateDatabase((CreateDatabaseEvent)event);
        }
    }).put((Object)EventMessage.EventType.DROP_DATABASE, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropDatabase((DropDatabaseEvent)event);
        }
    }).put((Object)EventMessage.EventType.CREATE_TABLE, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onCreateTable((CreateTableEvent)event);
        }
    }).put((Object)EventMessage.EventType.DROP_TABLE, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropTable((DropTableEvent)event);
        }
    }).put((Object)EventMessage.EventType.ADD_PARTITION, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAddPartition((AddPartitionEvent)event);
        }
    }).put((Object)EventMessage.EventType.DROP_PARTITION, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropPartition((DropPartitionEvent)event);
        }
    }).put((Object)EventMessage.EventType.ALTER_TABLE, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAlterTable((AlterTableEvent)event);
        }
    }).put((Object)EventMessage.EventType.ALTER_PARTITION, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAlterPartition((AlterPartitionEvent)event);
        }
    }).put((Object)EventMessage.EventType.INSERT, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onInsert((InsertEvent)event);
        }
    }).put((Object)EventMessage.EventType.CREATE_FUNCTION, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onCreateFunction((CreateFunctionEvent)event);
        }
    }).put((Object)EventMessage.EventType.DROP_FUNCTION, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropFunction((DropFunctionEvent)event);
        }
    }).put((Object)EventMessage.EventType.CREATE_INDEX, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAddIndex((AddIndexEvent)event);
        }
    }).put((Object)EventMessage.EventType.DROP_INDEX, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropIndex((DropIndexEvent)event);
        }
    }).put((Object)EventMessage.EventType.ALTER_INDEX, (Object)new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAlterIndex((AlterIndexEvent)event);
        }
    }).build());

    public static Map<String, String> notifyEvent(List<MetaStoreEventListener> listeners, EventMessage.EventType eventType, ListenerEvent event) throws MetaException {
        Preconditions.checkNotNull(listeners, (Object)"Listeners must not be null.");
        Preconditions.checkNotNull((Object)event, (Object)"The event must not be null.");
        for (MetaStoreEventListener listener : listeners) {
            notificationEvents.get((Object)eventType).notify(listener, event);
        }
        return event.getParameters();
    }

    public static Map<String, String> notifyEvent(List<MetaStoreEventListener> listeners, EventMessage.EventType eventType, ListenerEvent event, EnvironmentContext environmentContext) throws MetaException {
        Preconditions.checkNotNull((Object)event, (Object)"The event must not be null.");
        event.setEnvironmentContext(environmentContext);
        return MetaStoreListenerNotifier.notifyEvent(listeners, eventType, event);
    }

    public static Map<String, String> notifyEvent(List<MetaStoreEventListener> listeners, EventMessage.EventType eventType, ListenerEvent event, EnvironmentContext environmentContext, Map<String, String> parameters, RawStore ms) throws MetaException {
        Preconditions.checkNotNull((Object)event, (Object)"The event must not be null.");
        event.putParameters(parameters);
        if (ms != null) {
            event.putParameter("HIVE_METASTORE_TRANSACTION_ACTIVE", Boolean.toString(ms.isActiveTransaction()));
        }
        return MetaStoreListenerNotifier.notifyEvent(listeners, eventType, event, environmentContext);
    }

    private static interface EventNotifier {
        public void notify(MetaStoreEventListener var1, ListenerEvent var2) throws MetaException;
    }
}

