/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;

public class GenericEntity
implements Entity,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The unique identifier");
    public static final Field ENTITY_TYPE = Field.required("entityType", Entity.EntityType.class, "The entity's type");
    private Long id;
    private Entity.EntityType entityType;
    private String name;

    private GenericEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap<Field, Object> fields = new HashMap<Field, Object>();
        fields.put(ID, this.id);
        fields.put(ENTITY_TYPE, (Object)this.type());
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public Entity.EntityType type() {
        return this.entityType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericEntity)) {
            return false;
        }
        GenericEntity other = (GenericEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.id;
        Long other$id = other.id;
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Entity.EntityType this$entityType = this.entityType;
        Entity.EntityType other$entityType = other.entityType;
        if (this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Entity.EntityType $entityType = this.entityType;
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "GenericEntity(id=" + this.id + ", entityType=" + String.valueOf((Object)this.entityType) + ", name=" + this.name + ")";
    }

    public static class Builder {
        private final GenericEntity entity = new GenericEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.entity.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.entity.name = name;
            return this;
        }

        public Builder withEntityType(Entity.EntityType type) {
            this.entity.entityType = type;
            return this;
        }

        public GenericEntity build() {
            GenericEntity genericEntity = new GenericEntity();
            genericEntity.id = this.entity.id;
            genericEntity.name = this.entity.name;
            genericEntity.entityType = this.entity.entityType;
            genericEntity.validate();
            return genericEntity;
        }
    }
}

