/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.exceptions.IllegalMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchJobException;
import org.apache.gravitino.exceptions.NoSuchJobTemplateException;
import org.apache.gravitino.exceptions.NoSuchMetadataObjectException;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.utils.NameIdentifierUtil;

public class MetadataObjectUtil {
    private static final Joiner DOT = Joiner.on((String)".");
    private static final BiMap<MetadataObject.Type, Entity.EntityType> TYPE_TO_TYPE_MAP = ImmutableBiMap.builder().put((Object)MetadataObject.Type.METALAKE, (Object)Entity.EntityType.METALAKE).put((Object)MetadataObject.Type.CATALOG, (Object)Entity.EntityType.CATALOG).put((Object)MetadataObject.Type.SCHEMA, (Object)Entity.EntityType.SCHEMA).put((Object)MetadataObject.Type.TABLE, (Object)Entity.EntityType.TABLE).put((Object)MetadataObject.Type.TOPIC, (Object)Entity.EntityType.TOPIC).put((Object)MetadataObject.Type.FILESET, (Object)Entity.EntityType.FILESET).put((Object)MetadataObject.Type.COLUMN, (Object)Entity.EntityType.COLUMN).put((Object)MetadataObject.Type.ROLE, (Object)Entity.EntityType.ROLE).put((Object)MetadataObject.Type.MODEL, (Object)Entity.EntityType.MODEL).put((Object)MetadataObject.Type.TAG, (Object)Entity.EntityType.TAG).put((Object)MetadataObject.Type.POLICY, (Object)Entity.EntityType.POLICY).put((Object)MetadataObject.Type.JOB_TEMPLATE, (Object)Entity.EntityType.JOB_TEMPLATE).put((Object)MetadataObject.Type.JOB, (Object)Entity.EntityType.JOB).build();

    private MetadataObjectUtil() {
    }

    public static Entity.EntityType toEntityType(MetadataObject metadataObject) {
        Preconditions.checkArgument((metadataObject != null ? 1 : 0) != 0, (Object)"metadataObject cannot be null");
        return Optional.ofNullable((Entity.EntityType)((Object)TYPE_TO_TYPE_MAP.get((Object)metadataObject.type()))).orElseThrow(() -> new IllegalArgumentException("Unknown metadata object type: " + String.valueOf(metadataObject.type())));
    }

    public static Entity.EntityType toEntityType(MetadataObject.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"metadataObject type cannot be null");
        return Optional.ofNullable((Entity.EntityType)((Object)TYPE_TO_TYPE_MAP.get((Object)type))).orElseThrow(() -> new IllegalArgumentException("Unknown metadata object type: " + String.valueOf(type)));
    }

    public static NameIdentifier toEntityIdent(String metalakeName, MetadataObject metadataObject) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)metalakeName), (Object)"metalakeName cannot be blank");
        Preconditions.checkArgument((metadataObject != null ? 1 : 0) != 0, (Object)"metadataObject cannot be null");
        switch (metadataObject.type()) {
            case METALAKE: {
                return NameIdentifierUtil.ofMetalake(metalakeName);
            }
            case ROLE: {
                return AuthorizationUtils.ofRole(metalakeName, metadataObject.name());
            }
            case TAG: {
                return NameIdentifierUtil.ofTag(metalakeName, metadataObject.name());
            }
            case POLICY: {
                return NameIdentifierUtil.ofPolicy(metalakeName, metadataObject.name());
            }
            case JOB: {
                return NameIdentifierUtil.ofJob(metalakeName, metadataObject.name());
            }
            case JOB_TEMPLATE: {
                return NameIdentifierUtil.ofJobTemplate(metalakeName, metadataObject.name());
            }
            case CATALOG: 
            case SCHEMA: 
            case TABLE: 
            case TOPIC: 
            case FILESET: 
            case COLUMN: 
            case MODEL: {
                String fullName = DOT.join((Object)metalakeName, (Object)metadataObject.fullName(), new Object[0]);
                return NameIdentifier.parse((String)fullName);
            }
        }
        throw new IllegalArgumentException("Unknown metadata object type: " + String.valueOf(metadataObject.type()));
    }

    public static void checkMetadataObject(String metalake, MetadataObject object) {
        GravitinoEnv env = GravitinoEnv.getInstance();
        NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, object);
        Supplier<NoSuchMetadataObjectException> exceptionToThrowSupplier = () -> new NoSuchMetadataObjectException("Metadata object %s type %s doesn't exist", new Object[]{object.fullName(), object.type()});
        switch (object.type()) {
            case METALAKE: {
                if (!metalake.equals(object.name())) {
                    throw new IllegalMetadataObjectException("The metalake object name must be %s", new Object[]{metalake});
                }
                NameIdentifierUtil.checkMetalake(identifier);
                MetadataObjectUtil.check(env.metalakeDispatcher().metalakeExists(identifier), exceptionToThrowSupplier);
                break;
            }
            case CATALOG: {
                NameIdentifierUtil.checkCatalog(identifier);
                MetadataObjectUtil.check(env.catalogDispatcher().catalogExists(identifier), exceptionToThrowSupplier);
                break;
            }
            case SCHEMA: {
                NameIdentifierUtil.checkSchema(identifier);
                MetadataObjectUtil.check(env.schemaDispatcher().schemaExists(identifier), exceptionToThrowSupplier);
                break;
            }
            case FILESET: {
                NameIdentifierUtil.checkFileset(identifier);
                MetadataObjectUtil.check(env.filesetDispatcher().filesetExists(identifier), exceptionToThrowSupplier);
                break;
            }
            case TABLE: {
                NameIdentifierUtil.checkTable(identifier);
                MetadataObjectUtil.check(env.tableDispatcher().tableExists(identifier), exceptionToThrowSupplier);
                break;
            }
            case COLUMN: {
                NameIdentifierUtil.checkColumn(identifier);
                NameIdentifier tableIdent = NameIdentifier.of((String[])identifier.namespace().levels());
                MetadataObjectUtil.check(env.tableDispatcher().tableExists(tableIdent), exceptionToThrowSupplier);
                break;
            }
            case TOPIC: {
                NameIdentifierUtil.checkTopic(identifier);
                MetadataObjectUtil.check(env.topicDispatcher().topicExists(identifier), exceptionToThrowSupplier);
                break;
            }
            case MODEL: {
                NameIdentifierUtil.checkModel(identifier);
                MetadataObjectUtil.check(env.modelDispatcher().modelExists(identifier), exceptionToThrowSupplier);
                break;
            }
            case ROLE: {
                AuthorizationUtils.checkRole(identifier);
                try {
                    env.accessControlDispatcher().getRole(metalake, object.fullName());
                    break;
                }
                catch (NoSuchRoleException nsr) {
                    throw exceptionToThrowSupplier.get();
                }
            }
            case TAG: {
                NameIdentifierUtil.checkTag(identifier);
                try {
                    env.tagDispatcher().getTag(metalake, object.fullName());
                    break;
                }
                catch (NoSuchTagException nsr) {
                    throw exceptionToThrowSupplier.get();
                }
            }
            case POLICY: {
                NameIdentifierUtil.checkPolicy(identifier);
                try {
                    env.policyDispatcher().getPolicy(metalake, object.fullName());
                    break;
                }
                catch (NoSuchPolicyException nsr) {
                    throw (NoSuchMetadataObjectException)((Supplier)Preconditions.checkNotNull(exceptionToThrowSupplier)).get();
                }
            }
            case JOB: {
                NameIdentifierUtil.checkJob(identifier);
                try {
                    env.jobOperationDispatcher().getJob(metalake, object.fullName());
                    break;
                }
                catch (NoSuchJobException e) {
                    throw exceptionToThrowSupplier.get();
                }
            }
            case JOB_TEMPLATE: {
                NameIdentifierUtil.checkJobTemplate(identifier);
                try {
                    env.jobOperationDispatcher().getJobTemplate(metalake, object.fullName());
                    break;
                }
                catch (NoSuchJobTemplateException e) {
                    throw exceptionToThrowSupplier.get();
                }
            }
            default: {
                throw new IllegalArgumentException(String.format("Doesn't support the type %s", object.type()));
            }
        }
    }

    private static void check(boolean expression, Supplier<? extends RuntimeException> exceptionToThrowSupplier) {
        if (!expression) {
            Preconditions.checkArgument((exceptionToThrowSupplier != null ? 1 : 0) != 0, (Object)"exceptionToThrowSupplier should not be null");
            throw exceptionToThrowSupplier.get();
        }
    }
}

