/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.rocksdb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.paimon.lookup.BulkLoader;
import org.apache.paimon.lookup.ListBulkLoader;
import org.apache.paimon.lookup.ValueBulkLoader;
import org.apache.paimon.utils.ListDelimitedSerializer;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.EnvOptions;
import org.rocksdb.IngestExternalFileOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.SstFileWriter;
import org.rocksdb.TtlDB;

public class RocksDBBulkLoader
implements ValueBulkLoader,
ListBulkLoader {
    private final String uuid = UUID.randomUUID().toString();
    private final ListDelimitedSerializer listSerializer = new ListDelimitedSerializer();
    private final ColumnFamilyHandle columnFamily;
    private final String path;
    private final RocksDB db;
    private final boolean isTtlEnabled;
    private final Options options;
    private final List<String> files = new ArrayList<String>();
    private final int currentTimeSeconds;
    private SstFileWriter writer = null;
    private int sstIndex = 0;
    private long recordNum = 0L;

    public RocksDBBulkLoader(RocksDB db, Options options, ColumnFamilyHandle columnFamily, String path) {
        this.db = db;
        this.isTtlEnabled = db instanceof TtlDB;
        this.options = options;
        this.columnFamily = columnFamily;
        this.path = path;
        this.currentTimeSeconds = (int)(System.currentTimeMillis() / 1000L);
    }

    @Override
    public void write(byte[] key, byte[] value) throws BulkLoader.WriteException {
        try {
            if (this.writer == null) {
                this.writer = new SstFileWriter(new EnvOptions(), this.options);
                String path = new File(this.path, "sst-" + this.uuid + "-" + this.sstIndex++).getPath();
                this.writer.open(path);
                this.files.add(path);
            }
            if (this.isTtlEnabled) {
                value = this.appendTimestamp(value);
            }
            try {
                this.writer.put(key, value);
            }
            catch (RocksDBException e) {
                throw new BulkLoader.WriteException(e);
            }
            ++this.recordNum;
            if (this.recordNum % 1000L == 0L && this.writer.fileSize() >= this.options.targetFileSizeBase()) {
                this.writer.finish();
                this.writer.close();
                this.writer = null;
                this.recordNum = 0L;
            }
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(byte[] key, List<byte[]> value) throws BulkLoader.WriteException {
        byte[] bytes;
        try {
            bytes = this.listSerializer.serializeList(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.write(key, bytes);
    }

    private byte[] appendTimestamp(byte[] value) {
        byte[] newValue = new byte[value.length + 4];
        System.arraycopy(value, 0, newValue, 0, value.length);
        newValue[value.length] = (byte)(this.currentTimeSeconds & 0xFF);
        newValue[value.length + 1] = (byte)(this.currentTimeSeconds >> 8 & 0xFF);
        newValue[value.length + 2] = (byte)(this.currentTimeSeconds >> 16 & 0xFF);
        newValue[value.length + 3] = (byte)(this.currentTimeSeconds >> 24 & 0xFF);
        return newValue;
    }

    @Override
    public void finish() {
        try {
            if (this.writer != null) {
                this.writer.finish();
                this.writer.close();
            }
            if (this.files.size() > 0) {
                IngestExternalFileOptions ingestOptions = new IngestExternalFileOptions();
                this.db.ingestExternalFile(this.columnFamily, this.files, ingestOptions);
                ingestOptions.close();
            }
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }
}

