/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.utils.FileUtils;

public class HintFileUtils {
    public static final String EARLIEST = "EARLIEST";
    public static final String LATEST = "LATEST";
    private static final int READ_HINT_RETRY_NUM = 3;
    private static final int READ_HINT_RETRY_INTERVAL = 1;

    @Nullable
    public static Long findLatest(FileIO fileIO, Path dir, String prefix, Function<Long, Path> file) throws IOException {
        long nextSnapshot;
        Long snapshotId = HintFileUtils.readHint(fileIO, LATEST, dir);
        if (snapshotId != null && snapshotId > 0L && !fileIO.exists(file.apply(nextSnapshot = snapshotId + 1L))) {
            return snapshotId;
        }
        return HintFileUtils.findByListFiles(fileIO, Math::max, dir, prefix);
    }

    @Nullable
    public static Long findEarliest(FileIO fileIO, Path dir, String prefix, Function<Long, Path> file) throws IOException {
        Long snapshotId = HintFileUtils.readHint(fileIO, EARLIEST, dir);
        if (snapshotId != null && fileIO.exists(file.apply(snapshotId))) {
            return snapshotId;
        }
        return HintFileUtils.findByListFiles(fileIO, Math::min, dir, prefix);
    }

    public static Long readHint(FileIO fileIO, String fileName, Path dir) {
        Path path = new Path(dir, fileName);
        int retryNumber = 0;
        while (retryNumber++ < 3) {
            try {
                return fileIO.readOverwrittenFileUtf8(path).map(Long::parseLong).orElse(null);
            }
            catch (Exception exception) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    public static Long findByListFiles(FileIO fileIO, BinaryOperator<Long> reducer, Path dir, String prefix) throws IOException {
        return FileUtils.listVersionedFiles(fileIO, dir, prefix).reduce(reducer).orElse(null);
    }

    public static void commitLatestHint(FileIO fileIO, long id, Path dir) throws IOException {
        HintFileUtils.commitHint(fileIO, id, LATEST, dir);
    }

    public static void commitEarliestHint(FileIO fileIO, long id, Path dir) throws IOException {
        HintFileUtils.commitHint(fileIO, id, EARLIEST, dir);
    }

    public static void deleteLatestHint(FileIO fileIO, Path dir) throws IOException {
        Path hintFile = new Path(dir, LATEST);
        fileIO.delete(hintFile, false);
    }

    public static void deleteEarliestHint(FileIO fileIO, Path dir) throws IOException {
        Path hintFile = new Path(dir, EARLIEST);
        fileIO.delete(hintFile, false);
    }

    public static void commitHint(FileIO fileIO, long id, String fileName, Path dir) throws IOException {
        Path hintFile = new Path(dir, fileName);
        int loopTime = 3;
        while (loopTime-- > 0) {
            try {
                fileIO.overwriteHintFile(hintFile, String.valueOf(id));
                return;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(ThreadLocalRandom.current().nextInt(1000) + 500);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                if (loopTime != 0) continue;
                throw e;
            }
        }
    }
}

