/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AppPriorityACLGroup;

public class AppPriorityACLConfigurationParser {
    private static final Log LOG = LogFactory.getLog(AppPriorityACLConfigurationParser.class);
    public static final String PATTERN_FOR_PRIORITY_ACL = "\\[([^\\]]+)";
    @InterfaceAudience.Private
    public static final String ALL_ACL = "*";
    @InterfaceAudience.Private
    public static final String NONE_ACL = " ";

    public List<AppPriorityACLGroup> getPriorityAcl(Priority clusterMaxPriority, String aclString) {
        ArrayList<AppPriorityACLGroup> aclList = new ArrayList<AppPriorityACLGroup>();
        Matcher matcher = Pattern.compile(PATTERN_FOR_PRIORITY_ACL).matcher(aclString);
        while (matcher.find()) {
            String aclSubGroup = matcher.group(1);
            if (aclSubGroup.trim().isEmpty()) continue;
            AppPriorityACLGroup userPriorityACL = new AppPriorityACLGroup();
            ArrayList<StringBuilder> userAndGroupName = new ArrayList<StringBuilder>();
            for (String kvPair : aclSubGroup.trim().split(" +")) {
                String[] splits = kvPair.split("=");
                if (splits == null || splits.length <= 1) continue;
                this.parsePriorityACLType(userPriorityACL, splits, userAndGroupName);
            }
            if (userPriorityACL.getMaxPriority().getPriority() > clusterMaxPriority.getPriority()) {
                LOG.warn((Object)("ACL configuration for '" + userPriorityACL.getMaxPriority() + "' is greater that cluster max priority. Resetting ACLs to " + clusterMaxPriority));
                userPriorityACL.setMaxPriority(Priority.newInstance((int)clusterMaxPriority.getPriority()));
            }
            AccessControlList acl = this.createACLStringForPriority(userAndGroupName);
            userPriorityACL.setACLList(acl);
            aclList.add(userPriorityACL);
        }
        return aclList;
    }

    private void parsePriorityACLType(AppPriorityACLGroup userPriorityACL, String[] splits, List<StringBuilder> userAndGroupName) {
        AppPriorityACLKeyType aclType = AppPriorityACLKeyType.valueOf(StringUtils.toUpperCase((String)splits[0].trim()));
        switch (aclType) {
            case MAX_PRIORITY: {
                userPriorityACL.setMaxPriority(Priority.newInstance((int)Integer.parseInt(splits[1])));
                break;
            }
            case USER: {
                userAndGroupName.add(this.getUserOrGroupACLStringFromConfig(splits[1]));
                break;
            }
            case GROUP: {
                userAndGroupName.add(this.getUserOrGroupACLStringFromConfig(splits[1]));
                break;
            }
            case DEFAULT_PRIORITY: {
                int defaultPriority = Integer.parseInt(splits[1]);
                Priority priority = defaultPriority < 0 ? Priority.newInstance((int)0) : Priority.newInstance((int)defaultPriority);
                userPriorityACL.setDefaultPriority(priority);
                break;
            }
        }
    }

    private AccessControlList createACLStringForPriority(List<StringBuilder> acls) {
        String finalACL = "";
        String userACL = acls.get(0).toString();
        if (userACL.trim().equals(ALL_ACL)) {
            finalACL = ALL_ACL;
        } else if (userACL.equals(NONE_ACL)) {
            finalACL = NONE_ACL;
        } else {
            String groupACL;
            if (!userACL.trim().isEmpty()) {
                finalACL = acls.get(0).toString();
            }
            if (acls.size() > 1 && !(groupACL = acls.get(1).toString()).trim().isEmpty()) {
                finalACL = finalACL + NONE_ACL + acls.get(1).toString();
            }
        }
        return new AccessControlList(finalACL.trim());
    }

    private StringBuilder getUserOrGroupACLStringFromConfig(String value) {
        StringBuilder aclTypeName = new StringBuilder();
        if (value.trim().equals(ALL_ACL)) {
            aclTypeName.setLength(0);
            aclTypeName.append(ALL_ACL);
            return aclTypeName;
        }
        aclTypeName.append(value.trim());
        return aclTypeName;
    }

    public static enum AppPriorityACLKeyType {
        USER(1),
        GROUP(2),
        MAX_PRIORITY(3),
        DEFAULT_PRIORITY(4);

        private final int id;

        private AppPriorityACLKeyType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

