/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.adlsv2;

import com.azure.storage.file.datalake.DataLakeFileClient;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.iceberg.azure.AzureProperties;
import org.apache.iceberg.azure.adlsv2.ADLSInputFile;
import org.apache.iceberg.azure.adlsv2.ADLSOutputStream;
import org.apache.iceberg.azure.adlsv2.BaseADLSFile;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.metrics.MetricsContext;

class ADLSOutputFile
extends BaseADLSFile
implements OutputFile {
    ADLSOutputFile(String location, DataLakeFileClient fileClient, AzureProperties azureProperties, MetricsContext metrics) {
        super(location, fileClient, azureProperties, metrics);
    }

    public PositionOutputStream create() {
        if (!this.exists()) {
            return this.createOrOverwrite();
        }
        throw new AlreadyExistsException("Location already exists: %s", new Object[]{this.location()});
    }

    public PositionOutputStream createOrOverwrite() {
        try {
            return new ADLSOutputStream(this.fileClient(), this.azureProperties(), this.metrics());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create output stream for location: " + this.location(), e);
        }
    }

    public InputFile toInputFile() {
        return new ADLSInputFile(this.location(), this.fileClient(), this.azureProperties(), this.metrics());
    }
}

